/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.common.message;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.languages.common.base.file.ProjectBasedFileAccess;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteTransformationChain;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.robotics.codegen.common.utils.PackageTools;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.profile.robotics.commpattern.CommunicationPattern;
import org.eclipse.papyrus.robotics.ros2.codegen.common.RoboticsTContext;
import org.eclipse.papyrus.robotics.ros2.codegen.common.message.CreateMessage;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.MessageUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.RosHelpers;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class CreateMsgPackage {
    private Map<String, Boolean> packageNames;
    private Map<String, Boolean> availRosPackages;

    public CreateMsgPackage() {
        HashMap<String, Boolean> _hashMap = new HashMap<String, Boolean>();
        this.packageNames = _hashMap;
        this.availRosPackages = MessageUtils.ros2AvailMsgPkgs();
    }

    public void createMsgPkgs(TemplateBinding tb) {
        CommunicationPattern cp = InteractionUtils.getCommunicationPattern((TemplateBinding)tb);
        if (InteractionUtils.isQuery((CommunicationPattern)cp) || InteractionUtils.isAction((CommunicationPattern)cp)) {
            Interface sd = InteractionUtils.getServiceDefinition((TemplateBinding)tb);
            this.createMsgPkg(MessageUtils.getMessagePackage((NamedElement)sd));
        }
        EList _parameterSubstitutions = tb.getParameterSubstitutions();
        for (TemplateParameterSubstitution tps : _parameterSubstitutions) {
            ParameterableElement _actual = tps.getActual();
            DataType actual = (DataType)_actual;
            MessageUtils.makeDTExternal(actual);
            this.createMsgPkg(MessageUtils.getMessagePackage((NamedElement)actual));
        }
    }

    public void createMsgPkg(DataType dt) {
        this.createMsgPkg(MessageUtils.getMessagePackage((NamedElement)dt));
    }

    public void createMsgPkg(Package msgPkg) {
        String msgPkgName = msgPkg.getName();
        boolean _containsKey = this.packageNames.containsKey(msgPkgName);
        if (_containsKey) {
            return;
        }
        this.packageNames.put(msgPkgName, true);
        NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS((Element)TransformationContext.current.modelRoot, (String)msgPkgName);
        Package srcPkg = (Package)_qualifiedElementFromRS;
        IProject project = this.getMessageProject(PackageTools.pkgName((Package)msgPkg));
        if (project == null) {
            return;
        }
        ProjectBasedFileAccess fileAccess = new ProjectBasedFileAccess(project);
        RoboticsTContext.current.lst.createMsgBuildFiles((IPFileSystemAccess)fileAccess, srcPkg);
        CreateMessage cm = new CreateMessage(this);
        List _messages = InteractionUtils.getMessages((Package)srcPkg);
        for (DataType msg : _messages) {
            cm.generateFile((IPFileSystemAccess)fileAccess, RosHelpers.escapeUnderscore(msg.getName()), "msg", cm.createDtOrEnumMsg(msg));
        }
        List _queries = InteractionUtils.getQueries((Package)srcPkg);
        for (Interface sd : _queries) {
            TemplateBinding tb = InteractionUtils.getTemplateBinding((Interface)sd);
            NamedElement req = MessageUtils.getRequest(tb);
            NamedElement res = MessageUtils.getResponse(tb);
            cm.generateFile((IPFileSystemAccess)fileAccess, RosHelpers.escapeUnderscore(InteractionUtils.getNameWoPrefix((Interface)sd)), "srv", cm.createServiceMsg((DataType)req, (DataType)res));
        }
        List _actions = InteractionUtils.getActions((Package)srcPkg);
        for (Interface sd_1 : _actions) {
            TemplateBinding tb = InteractionUtils.getTemplateBinding((Interface)sd_1);
            NamedElement goal = MessageUtils.getGoal(tb);
            NamedElement res = MessageUtils.getResponse(tb);
            NamedElement feedback = MessageUtils.getFeedback(tb);
            cm.generateFile((IPFileSystemAccess)fileAccess, RosHelpers.escapeUnderscore(InteractionUtils.getNameWoPrefix((Interface)sd_1)), "action", cm.createActionMsg((DataType)goal, (DataType)res, (DataType)feedback));
        }
        try {
            IFolder _folder = project.getFolder("msg");
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            fileAccess.cleanUntouched(_folder, (IProgressMonitor)_nullProgressMonitor);
            IFolder _folder_1 = project.getFolder("srv");
            NullProgressMonitor _nullProgressMonitor_1 = new NullProgressMonitor();
            fileAccess.cleanUntouched(_folder_1, (IProgressMonitor)_nullProgressMonitor_1);
            IFolder _folder_2 = project.getFolder("action");
            NullProgressMonitor _nullProgressMonitor_2 = new NullProgressMonitor();
            fileAccess.cleanUntouched(_folder_2, (IProgressMonitor)_nullProgressMonitor_2);
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException e = (CoreException)_t;
                throw new RuntimeException(e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public IProject getMessageProject(String msgPkgName) {
        block4: {
            try {
                boolean _containsKey = this.availRosPackages.containsKey(msgPkgName);
                if (!_containsKey) break block4;
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        IProject genProject = RoboticsTContext.current.lst.getProject(msgPkgName);
        if (genProject == null) {
            throw new TransformationException(ExecuteTransformationChain.USER_CANCEL);
        }
        return genProject;
    }
}

