/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.cdteditor.sync;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.codesync.SyncStatus;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.SyncInformation;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.Utils;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.sync.SyncCDTtoModel;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.robotics.core.utils.ScanUtils;
import org.eclipse.papyrus.robotics.ros2.cdteditor.TextEditorConstants;
import org.eclipse.papyrus.robotics.ros2.cdteditor.sync.SyncParametersToModel;
import org.eclipse.papyrus.robotics.ros2.cdteditor.sync.SyncPortsToModel;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.UMLPackage;

public class SyncRoboticsCDTtoModel
extends SyncCDTtoModel {
    public SyncRoboticsCDTtoModel(IEditorInput input, Classifier classifier, String projectName, String generatorID) {
        super(input, classifier, projectName, generatorID);
    }

    public void run() {
        block12: {
            ICElement ice = CDTUITools.getEditorInputCElement((IEditorInput)this.m_input);
            SyncStatus.syncFromEditor = true;
            if (ice instanceof ITranslationUnit) {
                ICProject project = CoreModel.getDefault().getCModel().getCProject(this.m_projectName);
                IIndex index = null;
                try {
                    index = CCorePlugin.getIndexManager().getIndex(project);
                    index.acquireReadLock();
                    ITranslationUnit itu = (ITranslationUnit)ice;
                    IASTTranslationUnit ast = itu.getAST(index, 2);
                    IASTNodeSelector selector = ast.getNodeSelector(null);
                    this.examineChildren(itu, selector, (IParent)itu);
                    this.updateCppInclude(itu);
                    if (this.m_classifier instanceof Class) {
                        List pathMapURIs = ScanUtils.allPathmapModels((String)".servicedef.uml");
                        SyncPortsToModel.sync((Class)this.m_classifier, pathMapURIs, (IASTNode)ast, itu);
                        SyncParametersToModel.sync((Class)this.m_classifier, ast);
                    }
                    CUIPlugin.getDefault().getProblemMarkerManager();
                    if (itu instanceof IWorkingCopy) {
                        ((IWorkingCopy)itu).reconcile(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (CModelException e) {
                    Activator.log.error((Throwable)e);
                    if (index != null) {
                        index.releaseReadLock();
                    }
                    break block12;
                }
                catch (Exception e) {
                    try {
                        Activator.log.error((Throwable)e);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (index != null) {
                            index.releaseReadLock();
                        }
                    }
                }
                if (index == null) break block12;
                index.releaseReadLock();
            }
        }
        SyncStatus.syncFromEditor = false;
    }

    public void examineChildren(ITranslationUnit itu, IASTNodeSelector selector, IParent parent) throws CModelException {
        int position = 0;
        ICElement[] iCElementArray = parent.getChildren();
        int n = iCElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement child = iCElementArray[n2];
            if (child instanceof IParent) {
                this.examineChildren(itu, selector, (IParent)child);
            }
            ISourceRange range = null;
            if (child instanceof ISourceReference) {
                range = ((ISourceReference)child).getSourceRange();
            }
            if (child instanceof IFunctionDeclaration) {
                String name = ((IFunctionDeclaration)child).getElementName();
                IASTNode node = selector.findEnclosingNode(range.getStartPos(), range.getLength());
                if (node instanceof IASTFunctionDefinition) {
                    NamedElement ne;
                    IASTFunctionDefinition definition = (IASTFunctionDefinition)node;
                    IASTFunctionDeclarator declarator = definition.getDeclarator();
                    String unfilteredBody = SyncRoboticsCDTtoModel.getBody((ITranslationUnit)itu, (IASTFunctionDefinition)definition);
                    SyncInformation syncInfo = this.m_codegen.getSyncInformation(name, unfilteredBody);
                    String body = Utils.removeGenerated((String)unfilteredBody);
                    if (!(syncInfo != null && syncInfo.isGenerated || (ne = this.updateMethod(position, parent, name, body, declarator, syncInfo)) == null)) {
                        this.updateComment(itu, definition, ne);
                    }
                }
                ++position;
            }
            ++n2;
        }
    }

    public void updateCppInclude(ITranslationUnit itu) {
        Include include;
        String contents = new String(itu.getContents());
        int preBodyStart = contents.indexOf("// Include from Include stereotype (pre-body)");
        int preBodyEnd = contents.indexOf("// End of Include stereotype (pre-body)");
        String preBody = "";
        String body = "";
        if (preBodyStart != -1 && preBodyEnd > (preBodyStart += "// Include from Include stereotype (pre-body)".length())) {
            preBody = contents.substring(preBodyStart, preBodyEnd).trim();
        }
        int bodyStart = contents.indexOf("// Include from Include declaration (body)");
        int bodyEnd = contents.indexOf("// End of Include declaration (body)");
        if (bodyStart != -1 && bodyEnd > (bodyStart += "// Include from Include declaration (body)".length() + 1)) {
            body = contents.substring(bodyStart, bodyEnd).trim();
        }
        if ((body.length() > 0 || preBody.length() > 0) && (include = (Include)StereotypeUtil.applyApp((Element)this.m_classifier, Include.class)) != null) {
            include.setPreBody(preBody);
            include.setBody(body);
        }
    }

    public NamedElement updateMethod(int position, IParent parent, String qualifiedName, String body, IASTFunctionDeclarator declarator, SyncInformation syncInfo) {
        String[] names = qualifiedName.split("::");
        String name = names[names.length - 1];
        Behavior behavior = null;
        if (syncInfo == null || syncInfo.behavior == null && syncInfo.createBehaviorName == null) {
            behavior = this.getModelBehaviorFromName(name, parent, position);
            if (behavior != null) {
                behavior.setName(name);
            }
        } else if (syncInfo.behavior != null) {
            behavior = syncInfo.behavior;
        } else if (syncInfo.createBehaviorName != null && this.m_classifier instanceof Class) {
            Class clazz = (Class)this.m_classifier;
            behavior = (OpaqueBehavior)clazz.createOwnedBehavior(syncInfo.createBehaviorName, UMLPackage.eINSTANCE.getOpaqueBehavior().eClass());
        }
        if (behavior == null) {
            return null;
        }
        if (behavior instanceof OpaqueBehavior) {
            OpaqueBehavior ob = (OpaqueBehavior)behavior;
            if (ob.getBodies().size() == 0) {
                ob.getLanguages().add((Object)"C/C++");
                ob.getBodies().add((Object)"");
            }
            int i = 0;
            while (i < ob.getLanguages().size()) {
                String language = (String)ob.getLanguages().get(i);
                if ((TextEditorConstants.CPP.matcher(language).matches() || "C/C++".equals(language)) && i < ob.getBodies().size()) {
                    ob.getBodies().set(i, (Object)body);
                }
                ++i;
            }
        }
        return behavior;
    }

    public Behavior getModelBehaviorFromName(String name, IParent parent, int position) {
        PackageableElement beh = this.m_classifier.getNearestPackage().getPackagedElement(name);
        if (beh instanceof OpaqueBehavior) {
            return (OpaqueBehavior)beh;
        }
        ArrayList<Behavior> bl = new ArrayList<Behavior>();
        for (PackageableElement pe : this.m_classifier.getNearestPackage().getPackagedElements()) {
            if (!(pe instanceof Behavior)) continue;
            bl.add((Behavior)pe);
        }
        Behavior be = null;
        if (position < bl.size()) {
            be = (Behavior)bl.get(position);
            String modelName = be.getName();
            try {
                ICElement[] iCElementArray = parent.getChildren();
                int n = iCElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String cdtName;
                    ICElement child = iCElementArray[n2];
                    if (child instanceof IMethodDeclaration && (cdtName = ((IMethodDeclaration)child).getElementName()).equals(modelName)) {
                        be = null;
                        break;
                    }
                    ++n2;
                }
            }
            catch (CModelException cModelException) {
                // empty catch block
            }
        }
        return be;
    }

    public void updateComment(ITranslationUnit itu, IASTFunctionDefinition definition, NamedElement ne) {
        int start;
        IASTFileLocation bodyLoc = definition.getFileLocation();
        int end = start = bodyLoc.getNodeOffset() - 1;
        char[] contents = itu.getContents();
        String comment = "";
        while (start > 0) {
            if (contents[start] == '/' && contents[start + 1] == '*') {
                int i = start += "/**".length();
                while (i < end) {
                    comment = String.valueOf(comment) + contents[i];
                    ++i;
                }
                comment = comment.replace("\n * ", "\n").replace("*/", "").trim();
                break;
            }
            --start;
        }
        if (comment.length() > 0) {
            Comment commentUML;
            int atParam = comment.indexOf("@param");
            String commentMethodOnly = atParam != -1 ? comment.substring(0, atParam).trim() : comment;
            EList commentsUML = ne.getOwnedComments();
            if (commentsUML.size() == 0) {
                commentUML = ne.createOwnedComment();
                commentUML.getAnnotatedElements().add((Object)commentUML);
            } else {
                commentUML = (Comment)commentsUML.get(0);
            }
            while (atParam != -1) {
                int currentAtParam = atParam;
                String commentParam = (atParam = comment.indexOf("@param", atParam + 1)) != -1 ? comment.substring(currentAtParam, atParam) : comment.substring(currentAtParam);
                int atParamName = "@param".length();
                while (atParamName < commentParam.length() && Character.isWhitespace(commentParam.charAt(atParamName))) {
                    ++atParamName;
                }
                int atParamNameEnd = atParamName;
                while (atParamNameEnd < commentParam.length() && !Character.isWhitespace(commentParam.charAt(atParamNameEnd))) {
                    ++atParamNameEnd;
                }
                if (atParamNameEnd >= commentParam.length() - 1) continue;
                String parameterName = commentParam.substring(atParamName, atParamNameEnd);
                String commentParamText = commentParam.substring(atParamNameEnd).trim();
                Parameter parameter = null;
                if (ne instanceof BehavioralFeature) {
                    parameter = ((BehavioralFeature)ne).getOwnedParameter(parameterName, null, false, false);
                } else if (ne instanceof Behavior) {
                    parameter = ((Behavior)ne).getOwnedParameter(parameterName, null, false, false);
                }
                if (parameter != null) {
                    Comment commentParamUML;
                    EList commentsParamUML = parameter.getOwnedComments();
                    if (commentsParamUML.size() == 0) {
                        commentParamUML = parameter.createOwnedComment();
                        commentParamUML.getAnnotatedElements().add((Object)commentParamUML);
                    } else {
                        commentParamUML = (Comment)commentsParamUML.get(0);
                    }
                    commentParamUML.setBody(commentParamText);
                    continue;
                }
                commentMethodOnly = String.valueOf(commentMethodOnly) + "\n @param" + parameterName + " not found(!) " + commentParamText;
            }
            commentUML.setBody(commentMethodOnly);
        }
    }

    public ILangCodegen getCodeGen() {
        return this.m_codegen;
    }
}

