/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.properties.modelelement;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.robotics.core.provider.EClassGraphicalContentProvider;
import org.eclipse.papyrus.robotics.core.utils.PortUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentPort;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentService;
import org.eclipse.papyrus.robotics.properties.modelelement.ProvidedInterfaceObservable;
import org.eclipse.papyrus.robotics.properties.modelelement.RequiredInterfaceObservable;
import org.eclipse.papyrus.uml.properties.modelelement.StereotypeModelElement;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class RoboticsStereotypeME
extends StereotypeModelElement {
    static final String PROVIDES = "provides";
    static final String REQUIRES = "requires";

    public RoboticsStereotypeME(EObject stereotypeApplication, Stereotype stereotype) {
        this(stereotypeApplication, stereotype, (EditingDomain)TransactionUtil.getEditingDomain((EObject)stereotypeApplication));
    }

    public RoboticsStereotypeME(EObject stereotypeApplication, Stereotype stereotype, EditingDomain domain) {
        super(stereotypeApplication, stereotype, domain);
    }

    public void updateSource(EObject source) {
        this.source = source;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        if (propertyPath.equals(PROVIDES) || propertyPath.equals(REQUIRES)) {
            EStructuralFeature feature = this.getFeature(propertyPath);
            return new EClassGraphicalContentProvider(this.source, UMLPackage.eINSTANCE.getInterface(), feature);
        }
        return super.getContentProvider(propertyPath);
    }

    public IObservable doGetObservable(String propertyPath) {
        Object observable = null;
        if (this.source instanceof ComponentPort) {
            if (propertyPath.equals(PROVIDES)) {
                boolean assign;
                Port port = ((ComponentPort)this.source).getBase_Port();
                if ((port.getType() == null || !StereotypeUtil.isApplied((Element)port.getType(), ComponentService.class)) && (assign = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Create component service?", (String)String.format("In RobMoSys compliant models, ports are typed with a component service. Should the current type (%s) be replaced with a component service?", port.getType() != null ? port.getType().getName() : "unset")))) {
                    ICommand assocCmd = PortUtils.associateCSCommand((Port)port);
                    TransactionUtil.getEditingDomain((EObject)port).getCommandStack().execute(GMFtoEMFCommandWrapper.wrap((ICommand)assocCmd));
                }
                observable = new ProvidedInterfaceObservable(port, this.domain);
            } else if (propertyPath.equals(REQUIRES)) {
                Port port = ((ComponentPort)this.source).getBase_Port();
                observable = new RequiredInterfaceObservable(port, this.domain);
            } else {
                observable = super.doGetObservable(propertyPath);
            }
        } else {
            observable = super.doGetObservable(propertyPath);
        }
        return observable;
    }

    protected boolean isFeatureEditable(String propertyPath) {
        if (this.source instanceof ComponentPort) {
            return true;
        }
        return super.isFeatureEditable(propertyPath);
    }

    public boolean getDirectCreation(String propertyPath) {
        return super.getDirectCreation(propertyPath);
    }
}

