/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.profile.skills;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.robotics.profile.robotics.services.CoordinationEvent;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillFailState;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillOperationalState;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillSemantic;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillSuccessState;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLUtil;

public class SkillSemanticOperations {
    public static SkillFailState getFail(SkillSemantic skillSem) {
        SkillFailState res = null;
        EList regions = skillSem.getBase_StateMachine().getRegions();
        if (!regions.isEmpty()) {
            EList vertices = ((Region)regions.get(0)).getSubvertices();
            for (Vertex v : vertices) {
                res = (SkillFailState)UMLUtil.getStereotypeApplication((Element)v, SkillFailState.class);
                if (res != null) break;
            }
        }
        return res;
    }

    public static EList<SkillOperationalState> getOperational(SkillSemantic skillSem) {
        BasicEList list = new BasicEList();
        EList regions = skillSem.getBase_StateMachine().getRegions();
        if (!regions.isEmpty()) {
            EList vertices = ((Region)regions.get(0)).getSubvertices();
            for (Vertex v : vertices) {
                SkillOperationalState ops = (SkillOperationalState)UMLUtil.getStereotypeApplication((Element)v, SkillOperationalState.class);
                if (ops == null) continue;
                list.add((Object)ops);
            }
        }
        return list;
    }

    public static SkillSuccessState getSuccess(SkillSemantic skillSem) {
        SkillSuccessState res = null;
        EList regions = skillSem.getBase_StateMachine().getRegions();
        if (!regions.isEmpty()) {
            EList vertices = ((Region)regions.get(0)).getSubvertices();
            for (Vertex v : vertices) {
                res = (SkillSuccessState)UMLUtil.getStereotypeApplication((Element)v, SkillSuccessState.class);
                if (res != null) break;
            }
        }
        return res;
    }

    public static EList<CoordinationEvent> getFailEvts(SkillSemantic skillSem) {
        return SkillSemanticOperations.getSuccOrFailEvts(skillSem, SkillFailState.class);
    }

    public static EList<CoordinationEvent> getSuccEvts(SkillSemantic skillSem) {
        return SkillSemanticOperations.getSuccOrFailEvts(skillSem, SkillSuccessState.class);
    }

    protected static EList<CoordinationEvent> getSuccOrFailEvts(SkillSemantic skillSem, Class<? extends EObject> stereotype) {
        BasicEList events = new BasicEList();
        EList regions = skillSem.getBase_StateMachine().getRegions();
        if (!regions.isEmpty()) {
            EList transitions = ((Region)regions.get(0)).getTransitions();
            for (Transition t : transitions) {
                EObject fail = UMLUtil.getStereotypeApplication((Element)t.getTarget(), stereotype);
                if (fail == null) continue;
                for (Trigger g : t.getTriggers()) {
                    CoordinationEvent ce = (CoordinationEvent)UMLUtil.getStereotypeApplication((Element)g.getEvent(), CoordinationEvent.class);
                    if (ce == null) continue;
                    events.add((Object)ce);
                }
            }
        }
        return events;
    }
}

