/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.modelexplorer.queries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetManager;
import org.eclipse.papyrus.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.papyrus.emf.facet.query.java.core.IJavaQuery2;
import org.eclipse.papyrus.emf.facet.query.java.core.IParameterValueList2;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentService;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Usage;

public class CustomPackagedElement
implements IJavaQuery2<Element, List<PackageableElement>> {
    public List<PackageableElement> evaluate(Element context, IParameterValueList2 parameterValues, IFacetManager facetManager) throws DerivedTypedElementException {
        if (!(context instanceof Package)) {
            return Collections.emptyList();
        }
        return CustomPackagedElement.getFilteredElements((Package)context);
    }

    public static List<PackageableElement> getFilteredElements(Package pkg) {
        ArrayList<PackageableElement> result = new ArrayList<PackageableElement>();
        for (PackageableElement pe : pkg.getPackagedElements()) {
            if (StereotypeUtil.isApplied((Element)pe, ComponentService.class)) continue;
            if (pe instanceof Usage) {
                NamedElement client;
                Usage usage = (Usage)pe;
                boolean csSource = false;
                if (usage.getClients().size() > 0 && StereotypeUtil.isApplied((Element)(client = (NamedElement)usage.getClients().get(0)), ComponentService.class)) {
                    csSource = true;
                }
                if (csSource) continue;
                result.add(pe);
                continue;
            }
            result.add(pe);
        }
        return result;
    }
}

