/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.codegen.common.utils;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.uml.tools.utils.ConnectorUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.xtend2.lib.StringConcatenation;

public class TopicUtils {
    public static String getTopic(Port port) {
        return port.getName();
    }

    public static boolean isQualified(Port port) {
        int _indexOf = port.getName().indexOf("/");
        return _indexOf != -1;
    }

    public static String getTopic(Property part, Port port, ConnectorEnd oppositeEnd) {
        String _xblockexpression = null;
        ConnectableElement _role = oppositeEnd.getRole();
        Port oppositePort = (Port)_role;
        if (TopicUtils.isQualified(port) && TopicUtils.isQualified(oppositePort)) {
            String _topic_1;
            boolean _notEquals;
            String _topic = TopicUtils.getTopic(port);
            boolean bl = _notEquals = !Objects.equal((Object)_topic, (Object)(_topic_1 = TopicUtils.getTopic(oppositePort)));
            if (_notEquals) {
                String _format = String.format("Trying to connect two different qualified port names: %s with %s", TopicUtils.getTopic(port), TopicUtils.getTopic(oppositePort));
                throw new RuntimeException(_format);
            }
        }
        String _xifexpression = null;
        _xifexpression = TopicUtils.isQualified(port) || port.getProvideds().size() > 0 ? TopicUtils.getTopic(part, port) : TopicUtils.getTopic(oppositeEnd.getPartWithPort(), oppositePort);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static String getTopic(Property part, Port port) {
        String _xifexpression = null;
        boolean _isQualified = TopicUtils.isQualified(port);
        if (_isQualified) {
            _xifexpression = port.getName();
        } else {
            StringConcatenation _builder = new StringConcatenation();
            String _name = part.getName();
            _builder.append(_name);
            _builder.append("/");
            String _name_1 = InteractionUtils.getCommObject((Port)port).getName();
            _builder.append(_name_1);
            _builder.append("/");
            String _name_2 = port.getName();
            _builder.append(_name_2);
            _xifexpression = _builder.toString();
        }
        return _xifexpression;
    }

    public static ConnectorEnd getOpposite(Class system, Property part, Port port) {
        EList _ownedConnectors = system.getOwnedConnectors();
        for (Connector connector : _ownedConnectors) {
            ConnectorEnd end;
            boolean _connectsPort = ConnectorUtil.connectsPort((Connector)connector, (Port)port);
            if (!_connectsPort || (end = ConnectorUtil.connEndNotPart((Connector)connector, (Property)part)) == null) continue;
            return end;
        }
        return null;
    }
}

