/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.codegen.common.utils;

import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinitionModel;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ComponentUtils {
    public static ComponentDefinitionModel getComponentDefinitionModel(Class component) {
        Package root = PackageUtil.getRootPackage((Element)component);
        return (ComponentDefinitionModel)UMLUtil.getStereotypeApplication((Element)root, ComponentDefinitionModel.class);
    }

    public static List<String> getDependsPackage(Class component) {
        ComponentDefinitionModel cdm = ComponentUtils.getComponentDefinitionModel(component);
        if (cdm != null) {
            return cdm.getDependsPackage();
        }
        return Collections.emptyList();
    }

    public static boolean isRegistered(Class component) {
        ComponentDefinitionModel cdm = ComponentUtils.getComponentDefinitionModel(component);
        if (cdm != null) {
            return cdm.isRegistered();
        }
        return false;
    }

    public static boolean isRegistered(List<Class> components) {
        for (Class component : components) {
            boolean _isRegistered = ComponentUtils.isRegistered(component);
            if (!_isRegistered) continue;
            return true;
        }
        return false;
    }

    public static String getInstName(Class component) {
        return component.getName().toLowerCase();
    }
}

