/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.codegen.common.component;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.robotics.codegen.common.utils.ActivityUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.Activity;
import org.eclipse.papyrus.robotics.profile.robotics.functions.Function;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.xtend2.lib.StringConcatenation;

public abstract class CodeSkeleton {
    public static String POSTFIX = "_impl";
    protected Class component;

    public CodeSkeleton(Class component) {
        this.component = component;
    }

    public void createSkeleton() {
        Package _nearestPackage = this.component.getNearestPackage();
        String _name = this.component.getName();
        String _plus = String.valueOf(_name) + POSTFIX;
        Class skeleton = _nearestPackage.createOwnedClass(_plus, false);
        Comment comment = skeleton.createOwnedComment();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("This is a skeleton class generated for component ");
        String _name_1 = this.component.getName();
        _builder.append(_name_1);
        _builder.newLineIfNotEmpty();
        _builder.append("Copy it into the source folder as an initial base (or copy parts");
        _builder.newLine();
        _builder.append("of it whenever you add modify the component).");
        _builder.newLine();
        comment.setBody(_builder.toString());
        skeleton.createGeneralization((Classifier)this.component);
        this.addConstrOp(skeleton);
        List<Activity> _activities = ActivityUtils.getActivities(this.component);
        for (Activity activity : _activities) {
            EList _functions = activity.getFunctions();
            for (Function function : _functions) {
                boolean _not;
                boolean _isCodeInModel = function.isCodeInModel();
                boolean bl = _not = !_isCodeInModel;
                if (!_not) continue;
                this.moveFunction(skeleton, function);
            }
        }
    }

    public abstract Operation addConstrOp(Class var1);

    public boolean moveFunction(Class skeleton, Function function) {
        boolean _xifexpression = false;
        Class _base_Class = function.getBase_Class();
        if (_base_Class instanceof Behavior) {
            boolean _xblockexpression = false;
            Class _base_Class_1 = function.getBase_Class();
            Behavior ob = (Behavior)_base_Class_1;
            skeleton.getOwnedBehaviors().add((Object)ob);
            BehavioralFeature _specification = ob.getSpecification();
            _xifexpression = _xblockexpression = skeleton.getOwnedOperations().add((Object)((Operation)_specification));
        }
        return _xifexpression;
    }
}

