/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.resource.UMLResource;

public class EClassContentProvider
extends AbstractStaticContentProvider
implements IStaticContentProvider,
ITreeContentProvider,
IRevealSemanticElement {
    protected Resource resource;
    protected EClass metaClass;
    protected TreeViewer viewer;

    public EClassContentProvider(EObject eObject, EClass metaClass) {
        this.resource = eObject.eResource();
        if (this.resource == null) {
            Activator.log.debug("EObject passed to EClassContentProvider is not contained in a resource");
        }
        this.metaClass = metaClass;
    }

    public Object[] getElements() {
        ArrayList<EObject> results = new ArrayList<EObject>();
        ArrayList<Namespace> visitedNSs = new ArrayList<Namespace>();
        for (Package pkg : this.getEligiblePkgs()) {
            this.getElements((Namespace)pkg, results, visitedNSs);
        }
        return results.toArray();
    }

    public Object[] getElements(Object input) {
        return this.getEligiblePkgs().toArray();
    }

    protected List<Package> getEligiblePkgs() {
        ArrayList<Package> pkgList = new ArrayList<Package>();
        ResourceSet rs = this.resource.getResourceSet();
        for (Resource resource : rs.getResources()) {
            EObject topLevelElem;
            if (!(resource instanceof UMLResource) || resource.getContents().size() <= 0 || !((topLevelElem = (EObject)resource.getContents().get(0)) instanceof Package) || topLevelElem instanceof Profile) continue;
            pkgList.add((Package)topLevelElem);
        }
        return pkgList;
    }

    protected void getElements(Namespace ns, List<EObject> results, List<Namespace> visitedNSs) {
        if (!visitedNSs.contains(ns)) {
            visitedNSs.add(ns);
            for (EObject eObj : ns.eContents()) {
                if (eObj instanceof Namespace) {
                    this.getElements((Namespace)eObj, results, visitedNSs);
                }
                if (!this.metaClass.isInstance((Object)eObj)) continue;
                results.add(eObj);
            }
        }
    }

    public Object[] getChildren(Object parent) {
        ArrayList<EObject> results = new ArrayList<EObject>();
        if (parent instanceof Namespace) {
            for (EObject eObj : ((Namespace)parent).eContents()) {
                if (!this.metaClass.isInstance((Object)eObj) && !(eObj instanceof Namespace)) continue;
                results.add(eObj);
            }
        }
        return results.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof EObject) {
            return ((EObject)element).eContainer();
        }
        return null;
    }

    public boolean hasChildren(Object parent) {
        return this.getChildren(parent).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer) {
            this.viewer = (TreeViewer)viewer;
        }
        super.inputChanged(viewer, oldInput, newInput);
    }

    public void revealSemanticElement(List<?> elementList) {
        for (Object object : elementList) {
            if (!(object instanceof EObject)) continue;
            EObject eObject = (EObject)object;
            Object[] path = new Object[]{"Model matches", eObject};
            this.viewer.setSelection((ISelection)new TreeSelection(new TreePath(path)), true);
            break;
        }
    }
}

