/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.robotics.core.commands.CreateFunctionCommand;
import org.eclipse.papyrus.robotics.core.utils.FunctionUtils;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.profile.robotics.commpattern.CommunicationPattern;
import org.eclipse.papyrus.robotics.profile.robotics.components.Activity;
import org.eclipse.papyrus.robotics.profile.robotics.components.ActivityPort;
import org.eclipse.papyrus.robotics.profile.robotics.functions.Function;
import org.eclipse.papyrus.robotics.profile.robotics.functions.FunctionKind;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CreateFunctionsCommand
extends RecordingCommand {
    protected Port componentPortUml;
    protected Port activityPortUml;
    protected ActivityPort activityPort;
    protected Activity activity;

    public CreateFunctionsCommand(Port componentPortUml, Port activityPortUml) {
        super(TransactionUtil.getEditingDomain((EObject)activityPortUml), "Create functions");
        this.activityPortUml = activityPortUml;
        this.componentPortUml = componentPortUml;
        this.activityPort = (ActivityPort)UMLUtil.getStereotypeApplication((Element)activityPortUml, ActivityPort.class);
    }

    protected void doExecute() {
        Class activityCl = this.activityPortUml.getClass_();
        this.activity = (Activity)UMLUtil.getStereotypeApplication((Element)activityCl, Activity.class);
        CommunicationPattern cp = InteractionUtils.getCommunicationPattern(this.componentPortUml);
        if (this.componentPortUml.getProvideds().size() > 0) {
            if (InteractionUtils.isSend(cp) || InteractionUtils.isQuery(cp)) {
                this.createFunction("handler");
            } else if (InteractionUtils.isAction(cp)) {
                this.createFunction("goal");
                this.createFunction("cancel");
                this.createFunction("accepted");
            }
        } else if (this.componentPortUml.getRequireds().size() > 0) {
            if (InteractionUtils.isPush(cp)) {
                this.createFunction("handler");
            } else if (InteractionUtils.isQuery(cp)) {
                this.createFunction("result");
            } else if (InteractionUtils.isAction(cp)) {
                this.createFunction("goal");
                this.createFunction("feedback");
                this.createFunction("result");
            }
        }
    }

    protected void setName(Property fctAttr, String postFix) {
        Type function = fctAttr.getType();
        function.setName(String.valueOf(this.componentPortUml.getName()) + "_" + postFix);
    }

    protected void createFunction(String postFix) {
        Function function;
        Behavior fctUml = FunctionUtils.getFunction(this.activityPort, FunctionKind.HANDLER, postFix);
        if (fctUml == null) {
            CreateFunctionCommand createFct = new CreateFunctionCommand(this.activity.getBase_Class());
            createFct.doExecute();
            Property fctAttr = createFct.getFunctionAttr();
            this.activity.getBase_Class().getOwnedAttributes().add((Object)fctAttr);
            this.setName(fctAttr, postFix);
            fctUml = (Behavior)fctAttr.getType();
        }
        if ((function = (Function)UMLUtil.getStereotypeApplication((Element)fctUml, Function.class)) != null && function.getActivityPort() == null) {
            function.setActivityPort(this.activityPort);
        }
    }
}

