/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.parameters.instancevalue;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.cell.AbstractCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.parameters.utils.ParameterTableUtils;
import org.eclipse.papyrus.robotics.profile.robotics.parameters.ParameterInstance;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralSpecification;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class InstanceValueTableCellManager
extends AbstractCellManager {
    public static final String INSTANCE_VALUE_TABLE = "InstanceValueTable";
    public static final String INSTANCES = "instances";

    public boolean handles(Object columnElement, Object rowElement, INattableModelManager mngr) {
        EObject parent;
        return columnElement instanceof IAxis && (parent = ((IAxis)columnElement).eContainer()) != null && (parent = parent.eContainer()) instanceof Table && ((Table)parent).getTableConfiguration().getType().equals(INSTANCE_VALUE_TABLE);
    }

    public boolean isCellEditable(Object columnElement, Object rowElement, INattableModelManager mngr) {
        Property p;
        boolean isEditable = false;
        if (rowElement instanceof Property && (p = (Property)rowElement).upperBound() == 1) {
            isEditable = true;
        }
        return isEditable;
    }

    protected Slot getSlot(EObject context, Property p) {
        ValueSpecification v;
        if (context instanceof Property && (v = ((Property)context).getDefaultValue()) instanceof InstanceValue) {
            for (Slot slot : ((InstanceValue)v).getInstance().getSlots()) {
                if (slot.getDefiningFeature() != p) continue;
                return slot;
            }
        }
        return null;
    }

    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        ValueSpecification value = null;
        EObject context = tableManager.getTable().getContext();
        if (context instanceof Class) {
            context = ParameterUtils.getParameterProperty((Class)((Class)context));
        }
        if (rowElement instanceof Property) {
            Property p = (Property)rowElement;
            Slot slot = this.getSlot(context, p);
            if (slot != null && !slot.getValues().isEmpty()) {
                if (slot.getDefiningFeature().upperBound() == 1) {
                    OpaqueExpression expression;
                    EList bodies;
                    ValueSpecification specification = (ValueSpecification)slot.getValues().iterator().next();
                    if (specification == null) {
                        specification = p.getDefaultValue();
                    }
                    if (specification == null) {
                        value = ParameterTableUtils.createValueSpecification((Element)rowElement, slot, null);
                    } else if (specification instanceof LiteralSpecification) {
                        value = specification;
                    } else if (specification instanceof OpaqueExpression && !(bodies = (expression = (OpaqueExpression)specification).getBodies()).isEmpty()) {
                        LiteralString literalString = UMLFactory.eINSTANCE.createLiteralString();
                        literalString.setValue((String)bodies.iterator().next());
                        value = literalString;
                    }
                }
            } else if (p != null && p.getDefault() != null) {
                return p.getDefaultValue();
            }
        }
        return value;
    }

    protected Slot createSlot(CompositeCommand editingCommand, EObject context, Property p) {
        if (context instanceof Property) {
            Property instance = (Property)context;
            ValueSpecification defaultValue = instance.getDefaultValue();
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)instance);
            if (defaultValue == null) {
                InstanceValue iv = UMLFactory.eINSTANCE.createInstanceValue();
                final InstanceSpecification is = UMLFactory.eINSTANCE.createInstanceSpecification();
                Slot slot = is.createSlot();
                slot.setDefiningFeature((StructuralFeature)p);
                iv.setInstance(is);
                SetRequest setDefaultValue = new SetRequest((EObject)instance, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_DefaultValue(), (Object)iv);
                editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)setDefaultValue));
                Package root = PackageUtil.getRootPackage((Element)instance);
                Package instances = (Package)root.getMember(INSTANCES);
                if (instances == null) {
                    instances = UMLFactory.eINSTANCE.createPackage();
                    instances.setName(INSTANCES);
                    instances.getPackagedElements().add((Object)is);
                    ArrayList<Package> peList = new ArrayList<Package>((Collection<Package>)root.getPackagedElements());
                    peList.add(instances);
                    SetRequest addPackage = new SetRequest((EObject)root, (EStructuralFeature)UMLPackage.eINSTANCE.getPackage_PackagedElement(), peList);
                    editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)addPackage));
                } else {
                    ArrayList<InstanceSpecification> isList = new ArrayList<InstanceSpecification>((Collection<InstanceSpecification>)instances.getPackagedElements());
                    isList.add(is);
                    SetRequest addInstanceSpec = new SetRequest((EObject)instances, (EStructuralFeature)UMLPackage.eINSTANCE.getPackage_PackagedElement(), isList);
                    editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)addInstanceSpec));
                }
                RecordingCommand rc = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)p)){

                    protected void doExecute() {
                        StereotypeUtil.apply((Element)is, ParameterInstance.class);
                    }
                };
                editingCommand.compose((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)rc));
                return slot;
            }
            if (defaultValue instanceof InstanceValue) {
                Slot slot2;
                InstanceSpecification is = ((InstanceValue)defaultValue).getInstance();
                for (Slot slot2 : is.getSlots()) {
                    if (slot2.getDefiningFeature() != p) continue;
                    return slot2;
                }
                slot2 = UMLFactory.eINSTANCE.createSlot();
                slot2.setDefiningFeature((StructuralFeature)p);
                ArrayList<Slot> slotList = new ArrayList<Slot>((Collection<Slot>)is.getSlots());
                slotList.add(slot2);
                SetRequest addSlot = new SetRequest((EObject)is, (EStructuralFeature)UMLPackage.eINSTANCE.getInstanceSpecification_Slot(), slotList);
                editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)addSlot));
                return slot2;
            }
        }
        return null;
    }

    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        EObject context = tableManager.getTable().getContext();
        if (context instanceof Class) {
            context = ParameterUtils.getParameterProperty((Class)((Class)context));
        }
        CompositeCommand editingCommand = new CompositeCommand(null);
        if (newValue instanceof String) {
            String text = (String)newValue;
            Slot slot = rowElement instanceof Property ? this.createSlot(editingCommand, context, (Property)rowElement) : (Slot)rowElement;
            ValueSpecification defaultValue = null;
            if (slot.getDefiningFeature() != null) {
                defaultValue = ((Property)slot.getDefiningFeature()).getDefaultValue();
            }
            if (text != null) {
                if ((text = text.replaceAll("\"", "")).length() == 0 || defaultValue != null && text.equals(defaultValue.stringValue())) {
                    IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)context);
                    DestroyElementRequest request = new DestroyElementRequest(domain, (EObject)slot, false);
                    editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
                } else if (ParameterTableUtils.isSlotValueAnOpaqueExpression(slot)) {
                    OpaqueExpression expression = ParameterTableUtils.getSlotValue(slot);
                    IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)expression);
                    if (provider != null) {
                        EList bodies = expression.getBodies();
                        ArrayList<String> newBodies = new ArrayList<String>();
                        newBodies.add(text);
                        if (!bodies.isEmpty()) {
                            newBodies.addAll(bodies.subList(1, bodies.size()));
                        } else {
                            ArrayList<String> newLanguages = new ArrayList<String>();
                            newLanguages.add("VSL");
                            SetRequest languageRequest = new SetRequest(domain, (EObject)expression, (EStructuralFeature)UMLPackage.eINSTANCE.getOpaqueExpression_Language(), newLanguages);
                            editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)languageRequest));
                        }
                        SetRequest bodiesRequest = new SetRequest(domain, (EObject)expression, (EStructuralFeature)UMLPackage.eINSTANCE.getOpaqueExpression_Body(), newBodies);
                        editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)bodiesRequest));
                    }
                } else {
                    ValueSpecification specification = ParameterTableUtils.createValueSpecification((Element)rowElement, slot, text);
                    IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)slot);
                    if (specification != null && provider != null) {
                        ArrayList<ValueSpecification> values = new ArrayList<ValueSpecification>();
                        values.add(specification);
                        SetRequest request = new SetRequest(domain, (EObject)slot, (EStructuralFeature)UMLPackage.eINSTANCE.getSlot_Value(), values);
                        editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
                    }
                }
            }
        }
        return new GMFtoEMFCommandWrapper((ICommand)editingCommand);
    }
}

