/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.xtext.compdef.ui.contribution;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.robotics.bpc.profile.bpc.Entity;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.Activity;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

public class UnparseCompDef {
    public static CharSequence getCompDefText(Class clazz) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("component ");
        String _name = clazz.getName();
        _builder.append(_name);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        EList _ownedPorts = clazz.getOwnedPorts();
        for (Port port : _ownedPorts) {
            _builder.append("\t");
            _builder.append("port ");
            String _name_1 = port.getName();
            _builder.append(_name_1, "\t");
            _builder.append(" ");
            String _provided = UnparseCompDef.getProvided(port);
            _builder.append(_provided, "\t");
            String _required = UnparseCompDef.getRequired(port);
            _builder.append(_required, "\t");
            _builder.newLineIfNotEmpty();
        }
        EList _ownedAttributes = clazz.getOwnedAttributes();
        for (Property attribute : _ownedAttributes) {
            _builder.append("\t");
            Type type = attribute.getType();
            _builder.newLineIfNotEmpty();
            if (type == null || !StereotypeUtil.isApplied((Element)type, Activity.class)) continue;
            _builder.append("\t");
            _builder.append("activity ");
            String _name_2 = type.getName();
            _builder.append(_name_2, "\t");
            ValueSpecification _defaultValue = attribute.getDefaultValue();
            _builder.append((Object)_defaultValue, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        Class paramClass = ParameterUtils.getParameterClass((Class)clazz);
        _builder.newLineIfNotEmpty();
        if (paramClass != null) {
            EList _attributes = paramClass.getAttributes();
            for (Property parameter : _attributes) {
                _builder.append("\t");
                _builder.append("parameter ");
                String _name_3 = parameter.getName();
                _builder.append(_name_3, "\t");
                String _typeStr = UnparseCompDef.getTypeStr(parameter);
                _builder.append(_typeStr, "\t");
                String _defaultValueStr = UnparseCompDef.getDefaultValueStr(parameter);
                _builder.append(_defaultValueStr, "\t");
                String _comment = UnparseCompDef.getComment(parameter);
                _builder.append(_comment, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static String getProvided(Port port) {
        Interface provided;
        boolean _greaterThan;
        EList provideds = port.getProvideds();
        int _size = provideds.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan && (provided = (Interface)provideds.get(0)) != null && provided.getName() != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("provides ");
            String _qualifiedName = provided.getQualifiedName();
            _builder.append(_qualifiedName);
            return _builder.toString();
        }
        return "";
    }

    public static String getRequired(Port port) {
        Interface required;
        boolean _greaterThan;
        EList requireds = port.getRequireds();
        int _size = requireds.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan && (required = (Interface)requireds.get(0)) != null && required.getName() != null) {
            boolean _greaterThan_1;
            StringConcatenation _builder = new StringConcatenation();
            int _length = UnparseCompDef.getProvided(port).length();
            boolean bl2 = _greaterThan_1 = _length > 0;
            if (_greaterThan_1) {
                _builder.append(" ");
            }
            _builder.append("requires ");
            String _qualifiedName = required.getQualifiedName();
            _builder.append(_qualifiedName);
            return _builder.toString();
        }
        return "";
    }

    public static String getDefaultValueStr(Property attribute) {
        String strVal;
        ValueSpecification value = attribute.getDefaultValue();
        if (value != null && (strVal = value.stringValue()) != null) {
            boolean _not;
            boolean bl = _not = strVal.charAt(0) < '0' || strVal.charAt(0) > '9';
            if (_not) {
                strVal = "\"" + strVal + "\"";
            }
            return " = " + strVal;
        }
        return "";
    }

    public static String getTypeStr(Property attribute) {
        boolean _tripleNotEquals;
        Type _type = attribute.getType();
        boolean bl = _tripleNotEquals = _type != null;
        if (_tripleNotEquals) {
            String _qualifiedName = attribute.getType().getQualifiedName();
            return ": " + _qualifiedName;
        }
        return "";
    }

    public static String getComment(Property parameter) {
        Entity entity = (Entity)UMLUtil.getStereotypeApplication((Element)parameter, Entity.class);
        if (entity != null && entity.getDescription() != null) {
            String _description = entity.getDescription();
            return "\t// " + _description;
        }
        return "";
    }
}

