/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.skillrealization;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.infra.tools.file.IPFileSystemAccess;
import org.eclipse.papyrus.robotics.profile.robotics.skills.InAttribute;
import org.eclipse.papyrus.robotics.profile.robotics.skills.OutAttribute;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillOperationalState;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillParameter;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillSemantic;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.Helpers;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.SkillUtils;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class CreateSkillRealizationCppCode {
    private static String msgAbortMultipleOperationalStatesIsUnsopported() {
        return String.format("abort transformation, code-generation of skill FSMs with many operational states is not supported", new Object[0]);
    }

    private static String msgAbortSystemHasNotCompIf(String ifName) {
        return String.format("abort transformation, there are no components in the system with the required coordination interface (%s)", ifName);
    }

    public static CharSequence createCppSimplestSkillWithSWComponentInteraction(SkillDefinition skill, SkillOperationalState ops, String actionName) {
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// Generated by Papyrus4Robotics");
        _builder.newLine();
        _builder.append("//");
        _builder.newLine();
        _builder.newLine();
        LinkedHashSet<DataType> _uniqueSkillParameterTypes = SkillUtils.getUniqueSkillParameterTypes(skill);
        for (DataType tp : _uniqueSkillParameterTypes) {
            _builder.append("#include \"");
            String _rOS2TypeIncludePath = SkillUtils.getROS2TypeIncludePath(tp);
            _builder.append(_rOS2TypeIncludePath);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("#include \"");
        String _coordinationIfIncludePath = SkillUtils.getCoordinationIfIncludePath(ops);
        _builder.append(_coordinationIfIncludePath);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"nav2_behavior_tree/bt_action_node.hpp\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("class ");
        String _name = SkillUtils.getName(skill);
        _builder.append(_name);
        _builder.append("Action : public nav2_behavior_tree::BtActionNode<");
        String _coordinationIfQn = SkillUtils.getCoordinationIfQn(ops);
        _builder.append(_coordinationIfQn);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("  ");
        String _name_1 = SkillUtils.getName(skill);
        _builder.append(_name_1, "  ");
        _builder.append("Action(");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("const std::string& name,");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("const std::string & action_name,");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("const BT::NodeConfiguration& conf)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append(": nav2_behavior_tree::BtActionNode<");
        String _coordinationIfQn_1 = SkillUtils.getCoordinationIfQn(ops);
        _builder.append(_coordinationIfQn_1, "  ");
        _builder.append(">(name, action_name, conf)");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)skill.getIns());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("  ");
            _builder.append("void on_tick() override");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("{");
            _builder.newLine();
            EList _ins = skill.getIns();
            for (InAttribute param : _ins) {
                _builder.append("  ");
                _builder.append("  ");
                String _externalName = Helpers.externalName((Type)SkillUtils.getType((SkillParameter)param));
                _builder.append(_externalName, "    ");
                _builder.append(" ");
                String _name_2 = SkillUtils.getName((SkillParameter)param);
                _builder.append(_name_2, "    ");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("getInput(\"");
                String _name_3 = SkillUtils.getName((SkillParameter)param);
                _builder.append(_name_3, "    ");
                _builder.append("\", ");
                String _name_4 = SkillUtils.getName((SkillParameter)param);
                _builder.append(_name_4, "    ");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                EList _ownedAttributes = SkillUtils.getType((SkillParameter)param).getOwnedAttributes();
                for (Property prop : _ownedAttributes) {
                    _builder.append("  ");
                    _builder.append("  ");
                    _builder.append("goal_.");
                    String _name_5 = prop.getName();
                    _builder.append(_name_5, "    ");
                    _builder.append(" = ");
                    String _name_6 = SkillUtils.getName((SkillParameter)param);
                    _builder.append(_name_6, "    ");
                    _builder.append(".");
                    String _name_7 = prop.getName();
                    _builder.append(_name_7, "    ");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("  ");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)skill.getOuts());
        boolean bl2 = _not_1 = !_isNullOrEmpty_1;
        if (_not_1) {
            _builder.append("  ");
            _builder.append("BT::NodeStatus on_success() override");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("{");
            _builder.newLine();
            EList _outs = skill.getOuts();
            for (OutAttribute param_1 : _outs) {
                _builder.append("  ");
                _builder.append("\t");
                String _externalName_1 = Helpers.externalName((Type)SkillUtils.getType((SkillParameter)param_1));
                _builder.append(_externalName_1, "  \t");
                _builder.append(" ");
                String _name_8 = SkillUtils.getName((SkillParameter)param_1);
                _builder.append(_name_8, "  \t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                EList _ownedAttributes_1 = SkillUtils.getType((SkillParameter)param_1).getOwnedAttributes();
                for (Property prop_1 : _ownedAttributes_1) {
                    _builder.append("  ");
                    _builder.append("\t");
                    String _name_9 = SkillUtils.getName((SkillParameter)param_1);
                    _builder.append(_name_9, "  \t");
                    _builder.append(".");
                    String _name_10 = prop_1.getName();
                    _builder.append(_name_10, "  \t");
                    _builder.append(" = result_.");
                    String _name_11 = prop_1.getName();
                    _builder.append(_name_11, "  \t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("  ");
                _builder.append("\t");
                _builder.append("setOutput(\"");
                String _name_12 = SkillUtils.getName((SkillParameter)param_1);
                _builder.append(_name_12, "  \t");
                _builder.append("\", ");
                String _name_13 = SkillUtils.getName((SkillParameter)param_1);
                _builder.append(_name_13, "  \t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("  ");
            _builder.append("\t");
            _builder.append("return BT::NodeStatus::SUCCESS;");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("  ");
        CharSequence _createProvidedPortsMethod = CreateSkillRealizationCppCode.createProvidedPortsMethod(skill);
        _builder.append((Object)_createProvidedPortsMethod, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"behaviortree_cpp_v3/bt_factory.h\"");
        _builder.newLine();
        _builder.append("BT_REGISTER_NODES(factory)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("BT::NodeBuilder builder =");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("[](const std::string & name, const BT::NodeConfiguration & config)");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("return std::make_unique<");
        String _name_14 = SkillUtils.getName(skill);
        _builder.append(_name_14, "      ");
        _builder.append("Action>(name, \"");
        _builder.append(actionName, "      ");
        _builder.append("\", config);");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("factory.registerBuilder<");
        String _name_15 = SkillUtils.getName(skill);
        _builder.append(_name_15, "  ");
        _builder.append("Action>(\"");
        String _name_16 = SkillUtils.getName(skill);
        _builder.append(_name_16, "  ");
        _builder.append("\", builder);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence createCppSimplestSkillNoInteraction(SkillDefinition skill) {
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// Generated by Papyrus4Robotics");
        _builder.newLine();
        _builder.append("// ...");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include <string>");
        _builder.newLine();
        _builder.append("#include \"rclcpp/rclcpp.hpp\"");
        _builder.newLine();
        LinkedHashSet<DataType> _uniqueSkillParameterTypes = SkillUtils.getUniqueSkillParameterTypes(skill);
        for (DataType tp : _uniqueSkillParameterTypes) {
            _builder.append("#include \"");
            String _rOS2TypeIncludePath = SkillUtils.getROS2TypeIncludePath(tp);
            _builder.append(_rOS2TypeIncludePath);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("#include \"behaviortree_cpp_v3/action_node.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("class ");
        String _name = SkillUtils.getName(skill);
        _builder.append(_name);
        _builder.append("Action : public BT::SyncActionNode");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("// Any TreeNode with ports must have a constructor with this signature");
        _builder.newLine();
        _builder.append("  ");
        String _name_1 = SkillUtils.getName(skill);
        _builder.append(_name_1, "  ");
        _builder.append("Action(");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("const std::string& name,");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("const BT::NodeConfiguration& config)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append(": SyncActionNode(name, config)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        CharSequence _createProvidedPortsMethod = CreateSkillRealizationCppCode.createProvidedPortsMethod(skill);
        _builder.append((Object)_createProvidedPortsMethod, "  ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("BT::NodeStatus tick() override");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("{");
        _builder.newLine();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)skill.getIns());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("\t");
            _builder.append("// Read from input ports");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//");
            _builder.newLine();
            EList _ins = skill.getIns();
            for (InAttribute param : _ins) {
                _builder.append("\t");
                String _externalName = Helpers.externalName((Type)SkillUtils.getType((SkillParameter)param));
                _builder.append(_externalName, "\t");
                _builder.append(" ");
                String _name_2 = SkillUtils.getName((SkillParameter)param);
                _builder.append(_name_2, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("getInput(\"");
                String _name_3 = SkillUtils.getName((SkillParameter)param);
                _builder.append(_name_3, "\t");
                _builder.append("\", ");
                String _name_4 = SkillUtils.getName((SkillParameter)param);
                _builder.append(_name_4, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* ----------------------------------------------");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* USER CODE HERE USING READINGS FROM INPUT PORTS");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* ----------------------------------------------");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
        }
        _builder.newLine();
        if (IterableExtensions.isNullOrEmpty((Iterable)skill.getIns()) && IterableExtensions.isNullOrEmpty((Iterable)skill.getOuts())) {
            _builder.append("\t");
            _builder.append("/* -------------------");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* SOME USER CODE HERE");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* -------------------");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)skill.getOuts());
        boolean bl2 = _not_1 = !_isNullOrEmpty_1;
        if (_not_1) {
            _builder.append("\t");
            _builder.append("// Share through the blackboard");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//");
            _builder.newLine();
            EList _outs = skill.getOuts();
            for (OutAttribute param_1 : _outs) {
                _builder.append("\t");
                String _externalName_1 = Helpers.externalName((Type)SkillUtils.getType((SkillParameter)param_1));
                _builder.append(_externalName_1, "\t");
                _builder.append(" ");
                String _name_5 = SkillUtils.getName((SkillParameter)param_1);
                _builder.append(_name_5, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("/* -----------------------------------------");
                _builder.newLine();
                _builder.append("\t");
                _builder.append(" ");
                _builder.append("* USER CODE HERE TO INITIALIZE THE VARIABLE");
                _builder.newLine();
                _builder.append("\t");
                _builder.append(" ");
                _builder.append("* -----------------------------------------");
                _builder.newLine();
                _builder.append("\t");
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("setOutput(\"");
                String _name_6 = SkillUtils.getName((SkillParameter)param_1);
                _builder.append(_name_6, "\t");
                _builder.append("\", ");
                String _name_7 = SkillUtils.getName((SkillParameter)param_1);
                _builder.append(_name_7, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
            }
        }
        _builder.append("  \t");
        _builder.append("return BT::NodeStatus::SUCCESS;");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"behaviortree_cpp_v3/bt_factory.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// This function must be implemented in the .cpp file to create");
        _builder.newLine();
        _builder.append("// a plugin that can be loaded at run-time");
        _builder.newLine();
        _builder.append("BT_REGISTER_NODES(factory)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("factory.registerNodeType<");
        String _name_8 = SkillUtils.getName(skill);
        _builder.append(_name_8, "    ");
        _builder.append("Action>(\"");
        String _name_9 = SkillUtils.getName(skill);
        _builder.append(_name_9, "    ");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence createProvidedPortsMethod(SkillDefinition skill) {
        StringConcatenation _builder = new StringConcatenation();
        if (!IterableExtensions.isNullOrEmpty((Iterable)skill.getIns()) || !IterableExtensions.isNullOrEmpty((Iterable)skill.getOuts())) {
            _builder.append("// ");
            String _name = SkillUtils.getName(skill);
            _builder.append(_name);
            _builder.append(" has in/out parameters => must provide a providedPorts method");
            _builder.newLineIfNotEmpty();
            _builder.append("static BT::PortsList providedPorts()");
            _builder.newLine();
            _builder.append("{");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("return{");
            _builder.newLine();
            EList _ins = skill.getIns();
            boolean _hasElements = false;
            for (InAttribute param : _ins) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "    ");
                }
                _builder.append("    ");
                _builder.append("BT::InputPort<");
                String _externalName = Helpers.externalName((Type)SkillUtils.getType((SkillParameter)param));
                _builder.append(_externalName, "    ");
                _builder.append(">(\"");
                String _name_1 = SkillUtils.getName((SkillParameter)param);
                _builder.append(_name_1, "    ");
                _builder.append("\")");
                _builder.newLineIfNotEmpty();
            }
            EList _outs = skill.getOuts();
            boolean _hasElements_1 = false;
            for (OutAttribute param_1 : _outs) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)",", "    ");
                }
                _builder.append("    ");
                _builder.append("BT::OutputPort<");
                String _externalName_1 = Helpers.externalName((Type)SkillUtils.getType((SkillParameter)param_1));
                _builder.append(_externalName_1, "    ");
                _builder.append(">(\"");
                String _name_2 = SkillUtils.getName((SkillParameter)param_1);
                _builder.append(_name_2, "    ");
                _builder.append("\")");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("  ");
            _builder.append("};");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public static void genCode(IPFileSystemAccess fileAccess, Map<SkillDefinition, SkillSemantic> skdefToSemanticsMap, Map<Interface, String> serviceToNameMap) {
        try {
            Set<Map.Entry<SkillDefinition, SkillSemantic>> _entrySet = skdefToSemanticsMap.entrySet();
            for (Map.Entry<SkillDefinition, SkillSemantic> entry : _entrySet) {
                boolean _greaterThan;
                SkillDefinition definition = entry.getKey();
                SkillSemantic semantics = entry.getValue();
                String _realizationFileName = SkillUtils.realizationFileName(definition);
                String skillRealizationFileName = String.valueOf(_realizationFileName) + ".cpp";
                int _size = semantics.getOperational().size();
                boolean bl = _greaterThan = _size > 1;
                if (_greaterThan) {
                    String _msgAbortMultipleOperationalStatesIsUnsopported = CreateSkillRealizationCppCode.msgAbortMultipleOperationalStatesIsUnsopported();
                    throw new TransformationException(_msgAbortMultipleOperationalStatesIsUnsopported);
                }
                SkillOperationalState ops = SkillUtils.getFirstOpState(semantics);
                boolean _doesConfigAndCoordOfComponents = SkillUtils.doesConfigAndCoordOfComponents(ops);
                if (_doesConfigAndCoordOfComponents) {
                    boolean _not;
                    boolean _containsKey = serviceToNameMap.containsKey(SkillUtils.getCompInterface(ops));
                    boolean bl2 = _not = !_containsKey;
                    if (_not) {
                        String _msgAbortSystemHasNotCompIf = CreateSkillRealizationCppCode.msgAbortSystemHasNotCompIf(SkillUtils.getCompInterface(ops).getName());
                        throw new TransformationException(_msgAbortSystemHasNotCompIf);
                    }
                    String actionName = serviceToNameMap.get(SkillUtils.getCompInterface(ops));
                    fileAccess.generateFile(skillRealizationFileName, CreateSkillRealizationCppCode.createCppSimplestSkillWithSWComponentInteraction(definition, ops, actionName).toString());
                    continue;
                }
                fileAccess.generateFile(skillRealizationFileName, CreateSkillRealizationCppCode.createCppSimplestSkillNoInteraction(definition).toString());
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

