/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.infra.tools.file.IPFileSystemAccess;
import org.eclipse.papyrus.robotics.core.utils.InstanceUtils;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.core.utils.PortUtils;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillDefinition;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ComponentUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.PackageTools;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.SequencerUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.SkillUtils;
import org.eclipse.papyrus.robotics.ros2.preferences.Ros2PreferenceUtils;
import org.eclipse.papyrus.uml.tools.utils.ConnectorUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class LaunchScript {
    public static CharSequence createLaunchScript(Class system, List<Property> parts, boolean addSequencer, boolean activate) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("import launch.actions");
        _builder.newLine();
        _builder.append("import launch_ros");
        _builder.newLine();
        _builder.append("import lifecycle_msgs.msg");
        _builder.newLine();
        _builder.newLine();
        _builder.append("from launch_ros.events.lifecycle import ChangeState");
        _builder.newLine();
        _builder.append("from launch import LaunchDescription");
        _builder.newLine();
        _builder.append("from launch_ros.actions import LifecycleNode");
        _builder.newLine();
        _builder.append("from launch_ros.events.lifecycle import ChangeState");
        _builder.newLine();
        _builder.append("from ament_index_python.packages import get_package_share_directory");
        _builder.newLine();
        _builder.newLine();
        _builder.append("share_dir = get_package_share_directory('");
        String _pkgName = PackageTools.pkgName(system.getNearestPackage());
        _builder.append(_pkgName);
        _builder.append("')");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("def generate_launch_description():");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# Launch Description");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ld = launch.LaunchDescription()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# Add the actions to the launch description.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# The order they are added reflects the order in which they will be executed.");
        _builder.newLine();
        for (Property part : parts) {
            _builder.append("\t");
            Type _type = part.getType();
            Class component = (Class)_type;
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _name = part.getName();
            _builder.append(_name, "\t");
            _builder.append("_node = LifecycleNode(");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            boolean _isEloquent = LaunchScript.isEloquent();
            if (_isEloquent) {
                _builder.append("node_");
            }
            _builder.append("name='");
            String _name_1 = part.getName();
            _builder.append(_name_1, "\t\t");
            _builder.append("',");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("package='");
            String _pkgName_1 = PackageTools.pkgName(component.getNearestPackage());
            _builder.append(_pkgName_1, "\t\t");
            _builder.append("', ");
            boolean _isEloquent_1 = LaunchScript.isEloquent();
            if (_isEloquent_1) {
                _builder.append("node_");
            }
            _builder.append("executable='");
            String _name_2 = component.getName();
            _builder.append(_name_2, "\t\t");
            boolean _isRegistered = ComponentUtils.isRegistered(component);
            if (_isRegistered) {
                _builder.append("_main");
            }
            _builder.append("',");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("remappings=[");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            ArrayList<String> _remaps = LaunchScript.remaps(system, part);
            boolean _hasElements = false;
            for (String remap : _remaps) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t\t");
                }
                _builder.append(remap, "\t\t\t");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("],");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("parameters=[share_dir+'/launch/cfg/param.yaml'],");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("output='screen',");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("emulate_tty=True\t# assure that RCLCPP output gets flushed");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(")");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("ld.add_entity(");
            String _name_3 = part.getName();
            _builder.append(_name_3, "\t");
            _builder.append("_node)");
            _builder.newLineIfNotEmpty();
        }
        if (addSequencer) {
            _builder.append("\t");
            String _sequencerName = SequencerUtils.getSequencerName(system);
            _builder.append(_sequencerName, "\t");
            _builder.append("_node = LifecycleNode(");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            boolean _isEloquent_2 = LaunchScript.isEloquent();
            if (_isEloquent_2) {
                _builder.append("node_");
            }
            _builder.append("name='");
            String _sequencerName_1 = SequencerUtils.getSequencerName(system);
            _builder.append(_sequencerName_1, "\t\t");
            _builder.append("',");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("package='bt_sequencer', ");
            boolean _isEloquent_3 = LaunchScript.isEloquent();
            if (_isEloquent_3) {
                _builder.append("node_");
            }
            _builder.append("executable='bt_sequencer',");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("parameters=[share_dir+'/launch/cfg/param.yaml'],");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("output='screen',");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("emulate_tty=True\t# assure that RCLCPP output gets flushed");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(")");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("ld.add_entity(");
            String _sequencerName_2 = SequencerUtils.getSequencerName(system);
            _builder.append(_sequencerName_2, "\t");
            _builder.append("_node)");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        if (activate) {
            _builder.append("\t");
            _builder.append("# transition to configure after startup");
            _builder.newLine();
            for (Property part_1 : parts) {
                _builder.append("\t");
                CharSequence _generateConfig = LaunchScript.generateConfig(part_1.getName());
                _builder.append((Object)_generateConfig, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("# transition to activate, once inactive");
            _builder.newLine();
            for (Property part_2 : parts) {
                _builder.append("\t");
                CharSequence _generateActivation = LaunchScript.generateActivation(part_2.getName());
                _builder.append((Object)_generateActivation, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return ld");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence generateConfig(String name) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("configure_");
        _builder.append(name);
        _builder.append(" = launch.actions.RegisterEventHandler(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("launch.event_handlers.on_process_start.OnProcessStart(");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("target_action=");
        _builder.append(name, "\t\t");
        _builder.append("_node,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("on_start=[");
        _builder.newLine();
        _builder.append(" \t\t\t");
        _builder.append("launch.actions.EmitEvent(");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("event=launch_ros.events.lifecycle.ChangeState(");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("lifecycle_node_matcher=launch.events.matches_action(");
        _builder.append(name, "\t\t\t\t\t");
        _builder.append("_node),");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t");
        _builder.append("transition_id=lifecycle_msgs.msg.Transition.TRANSITION_CONFIGURE");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append(")");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(")");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("]");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(")");
        _builder.newLine();
        _builder.append(")");
        _builder.newLine();
        _builder.append("ld.add_entity(configure_");
        _builder.append(name);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence generateActivation(String name) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("activate_");
        _builder.append(name);
        _builder.append(" = launch.actions.RegisterEventHandler(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("launch_ros.event_handlers.OnStateTransition(");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("target_lifecycle_node=");
        _builder.append(name, "\t\t");
        _builder.append("_node,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("start_state='configuring', goal_state='inactive',");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("entities=[");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("launch.actions.EmitEvent(");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("event=launch_ros.events.lifecycle.ChangeState(");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("lifecycle_node_matcher=launch.events.matches_action(");
        _builder.append(name, "\t\t\t\t\t");
        _builder.append("_node),");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t");
        _builder.append("transition_id=lifecycle_msgs.msg.Transition.TRANSITION_ACTIVATE");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append(")");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(")");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("]");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(")");
        _builder.newLine();
        _builder.append(")");
        _builder.newLine();
        _builder.append("ld.add_entity(activate_");
        _builder.append(name);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence createParameterFile(Class system) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        List _compInstanceList = InstanceUtils.getCompInstanceList((Class)system);
        for (Property part : _compInstanceList) {
            ValueSpecification _defaultValue = part.getDefaultValue();
            if (!(_defaultValue instanceof InstanceValue)) continue;
            ValueSpecification _defaultValue_1 = part.getDefaultValue();
            InstanceSpecification is = ((InstanceValue)_defaultValue_1).getInstance();
            _builder.newLineIfNotEmpty();
            if (is == null) continue;
            String _name = part.getName();
            _builder.append(_name);
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("ros__parameters:");
            _builder.newLine();
            EList _slots = is.getSlots();
            for (Slot slot : _slots) {
                if (slot.getDefiningFeature() == null || DepUtils.firstValue((Slot)slot) == null) continue;
                _builder.append("    ");
                String _name_1 = slot.getDefiningFeature().getName();
                _builder.append(_name_1, "    ");
                _builder.append(" : ");
                String _stringValue = DepUtils.firstValue((Slot)slot).stringValue();
                _builder.append(_stringValue, "    ");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(SkillUtils.getUniqueSkills(system));
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _sequencerName = SequencerUtils.getSequencerName(system);
            _builder.append(_sequencerName);
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("ros__parameters:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("plugin_lib_names: [");
            _builder.newLine();
            LinkedHashSet<SkillDefinition> _uniqueSkills = SkillUtils.getUniqueSkills(system);
            boolean _hasElements = false;
            for (SkillDefinition skill : _uniqueSkills) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "    ");
                }
                _builder.append("    ");
                String _realizationFileName = SkillUtils.realizationFileName(skill);
                String _plus = "  \"" + _realizationFileName;
                _builder.append(_plus, "    ");
                _builder.append("_bt_node\"");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("    ");
            _builder.append("]");
            _builder.newLine();
        }
        return _builder;
    }

    public static CharSequence createLaunchScriptROS1(Class system) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<launch>");
        _builder.newLine();
        List _compInstanceList = InstanceUtils.getCompInstanceList((Class)system);
        for (Property part : _compInstanceList) {
            _builder.append("\t");
            Type _type = part.getType();
            Class component = (Class)_type;
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("<node pkg=\"");
            String _pkgName = PackageTools.pkgName(component.getNearestPackage());
            _builder.append(_pkgName, "\t");
            _builder.append("\" type=\"");
            String _name = component.getName();
            _builder.append(_name, "\t");
            _builder.append("\" name=\"");
            String _name_1 = part.getName();
            _builder.append(_name_1, "\t");
            _builder.append("\" cwd=\"node\" respawn=\"false\" output=\"screen\">");
            _builder.newLineIfNotEmpty();
            ArrayList<String> _remapsXML = LaunchScript.remapsXML(system, part);
            for (String remap : _remapsXML) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append(remap, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("</node>");
            _builder.newLine();
        }
        _builder.append("</launch>");
        _builder.newLine();
        return _builder;
    }

    public static ArrayList<String> remapsXML(Class system, Property part) {
        ArrayList<String> remaps = new ArrayList<String>();
        Type _type = part.getType();
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)((Class)_type));
        for (Port port : _allPorts) {
            ConnectorEnd oppositeEnd = LaunchScript.getOpposite(system, part, port);
            if (oppositeEnd == null) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<remap from=\"");
            CharSequence _topic = LaunchScript.getTopic(port);
            _builder.append((Object)_topic);
            _builder.append("\" to=\"");
            CharSequence _topic_1 = LaunchScript.getTopic(part, port, oppositeEnd);
            _builder.append((Object)_topic_1);
            _builder.append("\"/>");
            remaps.add(_builder.toString());
        }
        return remaps;
    }

    public static CharSequence remapsCmd(Class system, Property part) {
        StringConcatenation _builder = new StringConcatenation();
        Type _type = part.getType();
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)((Class)_type));
        boolean _hasElements = false;
        for (Port port : _allPorts) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" ", "");
            }
            ConnectorEnd oppositeEnd = LaunchScript.getOpposite(system, part, port);
            _builder.newLineIfNotEmpty();
            if (oppositeEnd == null) continue;
            _builder.append("-r ");
            CharSequence _topic = LaunchScript.getTopic(port);
            _builder.append((Object)_topic);
            _builder.append(":=");
            CharSequence _topic_1 = LaunchScript.getTopic(part, port, oppositeEnd);
            _builder.append((Object)_topic_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static ArrayList<String> remaps(Class system, Property part) {
        ArrayList<String> remaps = new ArrayList<String>();
        Type _type = part.getType();
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)((Class)_type));
        for (Port port : _allPorts) {
            ConnectorEnd oppositeEnd = LaunchScript.getOpposite(system, part, port);
            if (oppositeEnd == null || InteractionUtils.getCommObject((Port)port) == null) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("('");
            CharSequence _topic = LaunchScript.getTopic(port);
            _builder.append((Object)_topic);
            _builder.append("', '");
            CharSequence _topic_1 = LaunchScript.getTopic(part, port, oppositeEnd);
            _builder.append((Object)_topic_1);
            _builder.append("')");
            remaps.add(_builder.toString());
        }
        return remaps;
    }

    public static CharSequence getTopic(Port port) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = port.getName();
        _builder.append(_name);
        return _builder;
    }

    public static CharSequence getTopic(Property part, Port port, ConnectorEnd oppositeEnd) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        int _size = port.getProvideds().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            String _name = part.getName();
            _builder.append(_name);
            _builder.append("/");
            String _name_1 = InteractionUtils.getCommObject((Port)port).getName();
            _builder.append(_name_1);
            _builder.append("/");
            String _name_2 = port.getName();
            _builder.append(_name_2);
        } else {
            _builder.newLineIfNotEmpty();
            String _name_3 = oppositeEnd.getPartWithPort().getName();
            _builder.append(_name_3);
            _builder.append("/");
            String _name_4 = InteractionUtils.getCommObject((Port)port).getName();
            _builder.append(_name_4);
            _builder.append("/");
            String _name_5 = oppositeEnd.getRole().getName();
            _builder.append(_name_5);
        }
        return _builder;
    }

    public static ConnectorEnd getOpposite(Class system, Property part, Port port) {
        EList _ownedConnectors = system.getOwnedConnectors();
        for (Connector connector : _ownedConnectors) {
            ConnectorEnd end;
            boolean _connectsPort = ConnectorUtil.connectsPort((Connector)connector, (Port)port);
            if (!_connectsPort || (end = ConnectorUtil.connEndNotPart((Connector)connector, (Property)part)) == null) continue;
            return end;
        }
        return null;
    }

    public static void generateLaunch(IPFileSystemAccess fileAccess, Class system) {
        List parts = InstanceUtils.getCompInstanceList((Class)system);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(SkillUtils.getUniqueSkills(system));
        boolean addSequencer = !_isNullOrEmpty;
        fileAccess.generateFile("launch/launch.py", LaunchScript.createLaunchScript(system, parts, addSequencer, false).toString());
        fileAccess.generateFile("launch/activate.py", LaunchScript.createLaunchScript(system, parts, addSequencer, true).toString());
        for (Property part : parts) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("launch/launch.");
            String _name = part.getName();
            _builder.append(_name);
            _builder.append(".py");
            fileAccess.generateFile(_builder.toString(), LaunchScript.createLaunchScript(system, Collections.singletonList(part), false, false).toString());
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("launch/activate.");
            String _name_1 = part.getName();
            _builder_1.append(_name_1);
            _builder_1.append(".py");
            fileAccess.generateFile(_builder_1.toString(), LaunchScript.createLaunchScript(system, Collections.singletonList(part), false, true).toString());
        }
        if (addSequencer) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("launch/launch.");
            String _sequencerName = SequencerUtils.getSequencerName(system);
            _builder.append(_sequencerName);
            _builder.append(".py");
            fileAccess.generateFile(_builder.toString(), LaunchScript.createLaunchScript(system, Collections.emptyList(), true, false).toString());
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("launch/activate.");
            String _sequencerName_1 = SequencerUtils.getSequencerName(system);
            _builder_1.append(_sequencerName_1);
            _builder_1.append(".py");
            fileAccess.generateFile(_builder_1.toString(), LaunchScript.createLaunchScript(system, Collections.emptyList(), true, false).toString());
        }
        fileAccess.generateFile("launch/cfg/param.yaml", LaunchScript.createParameterFile(system).toString());
    }

    public static boolean isEloquent() {
        String _rosDistro = Ros2PreferenceUtils.getRosDistro();
        return _rosDistro == "eloquent";
    }
}

