/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.transformation.base.utils.ProjectManagement;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteTransformationChain;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.ExecuteTrafoChain;
import org.eclipse.papyrus.robotics.ros2.codegen.commands.PrepareCodegenCmd;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class GenerateCodeHandler
extends CmdHandler {
    ExecuteTrafoChain chain;

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        this.updateSelectedEObject();
        if (!(this.selectedEObject instanceof Classifier) || GenerateCodeHandler.isRunning()) {
            return null;
        }
        final Package pkg = PackageUtil.getRootPackage((Element)((Classifier)this.selectedEObject));
        final PrepareCodegenCmd prepareCmd = new PrepareCodegenCmd(pkg);
        if (prepareCmd.prepare()) {
            final IProject project = ProjectManagement.getCurrentProject();
            Job job = new Job("Generate ROS code"){

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        new ExecuteTransformationChain(pkg, project).executeTransformation(monitor, 0);
                    }
                    finally {
                        prepareCmd.undo();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        return null;
    }

    public static boolean isRunning() {
        if (TransformationContext.current != null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Code generation in progress", (String)"A previous code generation instance is running, please wait until it finishes before starting another one");
            return true;
        }
        return false;
    }
}

