/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.safety.riskanalysis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RiskEstimation implements Enumerator
{
    _1(0, "1", "1"),
    _2(1, "2", "2");

    public static final int _1_VALUE = 0;
    public static final int _2_VALUE = 1;
    private static final RiskEstimation[] VALUES_ARRAY;
    public static final List<RiskEstimation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RiskEstimation[]{_1, _2};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RiskEstimation get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RiskEstimation result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RiskEstimation getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RiskEstimation result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RiskEstimation get(int value) {
        switch (value) {
            case 0: {
                return _1;
            }
            case 1: {
                return _2;
            }
        }
        return null;
    }

    private RiskEstimation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

