/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.utils;

import com.google.common.base.Objects;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.External;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.core.utils.PortUtils;
import org.eclipse.papyrus.robotics.profile.robotics.commpattern.CommunicationPattern;
import org.eclipse.papyrus.robotics.profile.robotics.services.ServiceDefinitionModel;
import org.eclipse.papyrus.robotics.ros2.base.ProcessUtils;
import org.eclipse.papyrus.robotics.ros2.base.Ros2ProcessBuilder;
import org.eclipse.papyrus.robotics.ros2.codegen.Activator;
import org.eclipse.papyrus.robotics.ros2.codegen.message.CreateMsgPackage;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ApplyProfiles;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ComponentUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.Helpers;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class MessageUtils {
    public static final String MESSAGE = "msg";
    public static final String SERVICE = "srv";
    public static final String ACTION = "action";

    public static Package getMessagePackage(NamedElement ne) {
        try {
            Package pkg = ne.getNearestPackage();
            while (pkg instanceof Package) {
                boolean _isApplied = StereotypeUtil.isApplied((Element)pkg, ServiceDefinitionModel.class);
                if (_isApplied) {
                    return pkg;
                }
                pkg = pkg.getOwner();
            }
            String _format = String.format("Cannot find service definition module for element %s.", ne.getName());
            throw new TransformationException(_format);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String getROS2qMsgName(DataType dt) {
        String name = dt.getName();
        Package pkg = MessageUtils.getMessagePackage((NamedElement)dt);
        return String.format("%s/%s/%s", pkg.getName().toLowerCase(), MESSAGE, name);
    }

    public static String getROS2qMsgName(Interface sd) {
        String name = MessageUtils.getNameWoPrefix(sd);
        CommunicationPattern pattern = InteractionUtils.getCommunicationPattern((TemplateBinding)InteractionUtils.getTemplateBinding((Interface)sd));
        String kind = MESSAGE;
        boolean _isQuery = InteractionUtils.isQuery((CommunicationPattern)pattern);
        if (_isQuery) {
            kind = SERVICE;
        } else {
            boolean _isAction = InteractionUtils.isAction((CommunicationPattern)pattern);
            if (_isAction) {
                kind = ACTION;
            }
        }
        Package pkg = MessageUtils.getMessagePackage((NamedElement)sd);
        return String.format("%s/%s/%s", pkg.getName().toLowerCase(), kind, name);
    }

    public static String getNameWoPrefix(Interface sd) {
        String name = sd.getName();
        CommunicationPattern pattern = InteractionUtils.getCommunicationPattern((TemplateBinding)InteractionUtils.getTemplateBinding((Interface)sd));
        if (InteractionUtils.isPush((CommunicationPattern)pattern) && name.startsWith("P_")) {
            return name.substring(2);
        }
        if (InteractionUtils.isQuery((CommunicationPattern)pattern) && name.startsWith("Q_")) {
            return name.substring(2);
        }
        if (InteractionUtils.isSend((CommunicationPattern)pattern) && name.startsWith("S_")) {
            return name.substring(2);
        }
        if (InteractionUtils.isAction((CommunicationPattern)pattern) && name.startsWith("A_")) {
            return name.substring(2);
        }
        return name;
    }

    public static void makeDTExternal(DataType dt) {
        External external = (External)StereotypeUtil.applyApp((Element)dt, External.class);
        if (external == null) {
            ApplyProfiles.applyCppProfile((Element)dt);
            external = (External)StereotypeUtil.applyApp((Element)dt, External.class);
        }
        String qName = MessageUtils.getROS2qMsgName(dt);
        external.setName(qName.replace("/", "::"));
        String _escapeCamlCase = Helpers.escapeCamlCase(qName);
        String _plus = String.valueOf(_escapeCamlCase) + ".hpp";
        external.setIncPath(_plus);
    }

    public static NoCodeGen makeSvcDefExternal(TemplateBinding tb) {
        NoCodeGen _xblockexpression = null;
        Element intf = tb.getOwner();
        _xblockexpression = (NoCodeGen)StereotypeUtil.applyApp((Element)intf, NoCodeGen.class);
        return _xblockexpression;
    }

    public static Interface getServiceType(Port port) {
        CommunicationPattern pattern;
        Stereotype patternSt;
        TemplateBinding tb = InteractionUtils.getTemplateBinding((Port)port);
        MessageUtils.makeSvcDefExternal(tb);
        Interface sd = InteractionUtils.getServiceDefinition((TemplateBinding)tb);
        External external = (External)StereotypeUtil.applyApp((Element)sd, External.class);
        if (external == null) {
            ApplyProfiles.applyCppProfile((Element)sd);
            external = (External)StereotypeUtil.applyApp((Element)sd, External.class);
        }
        if ((patternSt = StereotypeUtil.apply((Element)(pattern = InteractionUtils.getCommunicationPattern((TemplateBinding)tb)).getBase_Collaboration(), NoCodeGen.class)) == null) {
            ApplyProfiles.applyCommonProfile((Element)pattern.getBase_Collaboration());
            StereotypeUtil.apply((Element)pattern.getBase_Collaboration(), NoCodeGen.class);
        }
        String qName = MessageUtils.getROS2qMsgName(sd);
        external.setName(qName.replace("/", "::"));
        String _escapeCamlCase = Helpers.escapeCamlCase(qName);
        String _plus = String.valueOf(_escapeCamlCase) + ".hpp";
        external.setIncPath(_plus);
        return sd;
    }

    public static String primitiveTypeMap(Type type) {
        String _switchResult = null;
        String _name = type.getName();
        boolean _matched = false;
        if (Objects.equal((Object)_name, (Object)"Integer")) {
            _matched = true;
            _switchResult = "int32";
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"String")) {
            _matched = true;
            _switchResult = "string";
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"VSL_Expression")) {
            _matched = true;
            _switchResult = "string";
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"Real")) {
            _matched = true;
            _switchResult = "float64";
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"UnlimitedNatural")) {
            _matched = true;
            _switchResult = "uint64";
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"Boolean")) {
            _matched = true;
            _switchResult = "bool";
        }
        if (!_matched) {
            String _xifexpression = null;
            if (type.getName().endsWith("_t") && type.getNamespace().getName().equals("AnsiCLibrary")) {
                String _name_1 = type.getName();
                int _length = type.getName().length();
                int _minus = _length - 2;
                return _name_1.substring(0, _minus);
            }
            _switchResult = _xifexpression = type.getName();
        }
        return _switchResult;
    }

    public static UniqueEList<String> getMsgFileNames(Package msgPackage) {
        UniqueEList msgFileNames = new UniqueEList();
        List _messages = InteractionUtils.getMessages((Package)msgPackage);
        for (DataType msg : _messages) {
            String _name = msg.getName();
            String _plus = String.valueOf(_name) + ".msg";
            msgFileNames.add((Object)_plus);
        }
        return msgFileNames;
    }

    public static UniqueEList<String> getSrvFileNames(Package msgPackage) {
        UniqueEList srvFileNames = new UniqueEList();
        List _queries = InteractionUtils.getQueries((Package)msgPackage);
        for (Interface sd : _queries) {
            String _nameWoPrefix = MessageUtils.getNameWoPrefix(sd);
            String _plus = String.valueOf(_nameWoPrefix) + ".srv";
            srvFileNames.add((Object)_plus);
        }
        return srvFileNames;
    }

    public static UniqueEList<String> getActFileNames(Package msgPackage) {
        UniqueEList actFileNames = new UniqueEList();
        List _actions = InteractionUtils.getActions((Package)msgPackage);
        for (Interface sd : _actions) {
            String _nameWoPrefix = MessageUtils.getNameWoPrefix(sd);
            String _plus = String.valueOf(_nameWoPrefix) + ".action";
            actFileNames.add((Object)_plus);
        }
        return actFileNames;
    }

    public static void createMessagesOrServices(CreateMsgPackage msgPkgCreator, Class component) {
        EList _ownedPorts = component.getOwnedPorts();
        for (Port port : _ownedPorts) {
            TemplateBinding tb = InteractionUtils.getTemplateBinding((Port)port);
            if (tb == null) continue;
            msgPkgCreator.createMsgPkgs(tb);
        }
    }

    public static NamedElement getRequest(TemplateBinding tb) {
        return MessageUtils.getActual("Request", tb);
    }

    public static NamedElement getResponse(TemplateBinding tb) {
        return MessageUtils.getActual("Response", tb);
    }

    public static NamedElement getGoal(TemplateBinding tb) {
        return MessageUtils.getActual("Goal", tb);
    }

    public static NamedElement getFeedback(TemplateBinding tb) {
        return MessageUtils.getActual("Goal", tb);
    }

    public static NamedElement getActual(String formalName, TemplateBinding tb) {
        EList _parameterSubstitutions = tb.getParameterSubstitutions();
        for (TemplateParameterSubstitution tps : _parameterSubstitutions) {
            ParameterableElement actual = tps.getActual();
            if (!formalName.equals(InteractionUtils.getTPName((TemplateParameter)tps.getFormal())) || !(actual instanceof NamedElement)) continue;
            return (NamedElement)actual;
        }
        return null;
    }

    public static NamedElement getMessage(TemplateBinding tb) {
        EList _parameterSubstitutions = tb.getParameterSubstitutions();
        for (TemplateParameterSubstitution tps : _parameterSubstitutions) {
            ParameterableElement actual = tps.getActual();
            if (!(actual instanceof NamedElement)) continue;
            return (NamedElement)actual;
        }
        return null;
    }

    public static String getFileName(TemplateBinding tb) {
        String names = null;
        EList _parameterSubstitutions = tb.getParameterSubstitutions();
        for (TemplateParameterSubstitution tps : _parameterSubstitutions) {
            ParameterableElement pe = tps.getActual();
            if (!(pe instanceof NamedElement)) continue;
            String name = ((NamedElement)pe).getName();
            names = names == null ? name : String.valueOf(names) + name;
        }
        return names;
    }

    public static List<String> calcDependencies(Class component) {
        return MessageUtils.calcDependencies(Collections.singletonList(component));
    }

    public static List<String> calcDependencies(List<Class> components) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("rclcpp");
        boolean _isRegistered = ComponentUtils.isRegistered(components);
        if (_isRegistered) {
            list.add("rclcpp_components");
        }
        list.add("rclcpp_lifecycle");
        boolean _haveActions = MessageUtils.haveActions(components);
        if (_haveActions) {
            list.add("rclcpp_action");
        }
        List<Package> _calcUsedMessagePackages = MessageUtils.calcUsedMessagePackages(components);
        for (Package pkg : _calcUsedMessagePackages) {
            boolean _not;
            String pkgName = pkg.getName().toLowerCase();
            boolean _contains = list.contains(pkgName);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            list.add(pkgName);
        }
        return list;
    }

    public static UniqueEList<Package> calcDependencies(Package msgPackage) {
        UniqueEList commObjects = new UniqueEList();
        UniqueEList msgPackages = new UniqueEList();
        commObjects.addAll((Collection)InteractionUtils.getMessages((Package)msgPackage));
        List _queries = InteractionUtils.getQueries((Package)msgPackage);
        for (Interface sd : _queries) {
            commObjects.addAll((Collection)InteractionUtils.getCommObjects((TemplateBinding)InteractionUtils.getTemplateBinding((Interface)sd)));
        }
        List _actions = InteractionUtils.getActions((Package)msgPackage);
        for (Interface sd_1 : _actions) {
            commObjects.addAll((Collection)InteractionUtils.getCommObjects((TemplateBinding)InteractionUtils.getTemplateBinding((Interface)sd_1)));
        }
        for (Type commObject : commObjects) {
            msgPackages.add((Object)MessageUtils.getMessagePackage((NamedElement)commObject));
        }
        msgPackages.remove((Object)msgPackage);
        return msgPackages;
    }

    public static List<Package> calcUsedMessagePackages(List<Class> components) {
        ArrayList<Package> list = new ArrayList<Package>();
        for (Class component : components) {
            EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
            for (Port port : _allPorts) {
                boolean _not;
                Package pkg = MessageUtils.getMessagePackage((NamedElement)InteractionUtils.getServiceDefinition((Port)port));
                boolean _contains = list.contains(pkg);
                boolean bl = _not = !_contains;
                if (!_not) continue;
                list.add(pkg);
            }
        }
        return list;
    }

    public static boolean hasActions(Class component) {
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
        for (Port port : _allPorts) {
            boolean _isAction = InteractionUtils.isAction((CommunicationPattern)InteractionUtils.getCommunicationPattern((Port)port));
            if (!_isAction) continue;
            return true;
        }
        return false;
    }

    public static boolean haveActions(List<Class> components) {
        for (Class component : components) {
            boolean _hasActions = MessageUtils.hasActions(component);
            if (!_hasActions) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Boolean> ros2AvailMsgPkgs() {
        Ros2ProcessBuilder pbMsg = new Ros2ProcessBuilder(new String[]{"pkg", "list"});
        HashMap<String, Boolean> availPackages = new HashMap<String, Boolean>();
        try {
            boolean _equals;
            Process p = pbMsg.start();
            InputStream es = p.getErrorStream();
            int _read = es.read();
            boolean bl = _equals = _read == -1;
            if (_equals) {
                InputStream _inputStream = p.getInputStream();
                InputStreamReader _inputStreamReader = new InputStreamReader(_inputStream);
                BufferedReader results = new BufferedReader(_inputStreamReader);
                String line = "";
                boolean found = false;
                while ((line = results.readLine()) != null && !found) {
                    availPackages.put(line.trim(), true);
                }
                results.close();
            } else {
                ProcessUtils.logErrors((Process)p);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                Activator.log.error((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return availPackages;
    }
}

