/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.properties.modelelement;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.robotics.core.provider.FilterStereotypes;
import org.eclipse.papyrus.robotics.core.provider.RoboticsContentProvider;
import org.eclipse.papyrus.robotics.profile.robotics.services.CoordinationService;
import org.eclipse.papyrus.robotics.profile.robotics.skills.InAttribute;
import org.eclipse.papyrus.robotics.profile.robotics.skills.OutAttribute;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillResult;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillsPackage;
import org.eclipse.papyrus.robotics.properties.modelelement.FunctionObservable;
import org.eclipse.papyrus.robotics.properties.modelelement.FunctionReferenceFactory;
import org.eclipse.papyrus.robotics.properties.modelelement.SkillParameterObservable;
import org.eclipse.papyrus.robotics.properties.modelelement.SkillReferenceFactory;
import org.eclipse.papyrus.robotics.properties.modelelement.SkillSemanticObservableCS;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class RoboticsME
extends UMLModelElement {
    static final String QOS = "qos";
    static final String COORDINATION_SVC = "coordinationSvc";
    static final String OUTS = "outs";
    static final String INS = "ins";
    static final String RES = "res";
    static final String FUNCTIONS = "functions";

    public RoboticsME(EObject source) {
        this(source, (EditingDomain)TransactionUtil.getEditingDomain((EObject)source));
    }

    public RoboticsME(EObject source, EditingDomain domain) {
        super(source, domain);
    }

    public void updateSource(EObject source) {
        this.source = source;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        if (propertyPath.equals(COORDINATION_SVC)) {
            SkillDefinition sd = (SkillDefinition)UMLUtil.getStereotypeApplication((Element)((Operation)this.source), SkillDefinition.class);
            EObject oState = SkillSemanticObservableCS.getOperationalState(sd);
            return new RoboticsContentProvider(this.source, (IStaticContentProvider)new UMLContentProvider(oState, (EStructuralFeature)SkillsPackage.eINSTANCE.getSkillOperationalState_CompInterface()), CoordinationService.class, ".servicedef.uml");
        }
        if (propertyPath.equals(INS)) {
            return new FilterStereotypes(super.getContentProvider(propertyPath), InAttribute.class);
        }
        if (propertyPath.equals(OUTS)) {
            return new FilterStereotypes(super.getContentProvider(propertyPath), OutAttribute.class);
        }
        if (propertyPath.endsWith(RES)) {
            return new FilterStereotypes(super.getContentProvider(propertyPath), SkillResult.class);
        }
        return super.getContentProvider(propertyPath);
    }

    public IObservable doGetObservable(String propertyPath) {
        Object observable = null;
        if (propertyPath.equals(COORDINATION_SVC)) {
            SkillDefinition sd = (SkillDefinition)UMLUtil.getStereotypeApplication((Element)((Operation)this.source), SkillDefinition.class);
            observable = new SkillSemanticObservableCS(sd, this.domain);
        } else {
            observable = this.isSkillParameter(propertyPath) ? new SkillParameterObservable((Operation)this.source, this.domain) : (propertyPath.equals(FUNCTIONS) ? new FunctionObservable((Class)this.source, this.domain) : (propertyPath.equals(QOS) ? new FunctionObservable((Class)this.source, this.domain) : super.doGetObservable(propertyPath)));
        }
        return observable;
    }

    protected boolean isSkillParameter(String propertyPath) {
        return propertyPath.equals(INS) || propertyPath.equals(OUTS) || propertyPath.equals(RES);
    }

    protected boolean isFeatureEditable(String propertyPath) {
        if (this.source instanceof Operation) {
            if (this.isSkillParameter(propertyPath)) {
                return true;
            }
            if (propertyPath.equals(COORDINATION_SVC)) {
                return true;
            }
        } else if (this.source instanceof Class && propertyPath.equals(FUNCTIONS)) {
            return true;
        }
        return super.isFeatureEditable(propertyPath);
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        EReference paramFeature = UMLPackage.eINSTANCE.getBehavioralFeature_OwnedParameter();
        EReference attrFeature = UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute();
        if (propertyPath.equals(INS)) {
            return new SkillReferenceFactory((Operation)this.source, paramFeature, ParameterDirectionKind.IN_LITERAL);
        }
        if (propertyPath.equals(OUTS)) {
            return new SkillReferenceFactory((Operation)this.source, paramFeature, ParameterDirectionKind.OUT_LITERAL);
        }
        if (propertyPath.equals(RES)) {
            return new SkillReferenceFactory((Operation)this.source, paramFeature, ParameterDirectionKind.RETURN_LITERAL);
        }
        if (propertyPath.equals(FUNCTIONS)) {
            return new FunctionReferenceFactory((Class)this.source, attrFeature);
        }
        return super.getValueFactory(propertyPath);
    }

    public boolean getDirectCreation(String propertyPath) {
        if (this.isSkillParameter(propertyPath)) {
            return true;
        }
        if (propertyPath.equals(FUNCTIONS)) {
            return true;
        }
        return super.getDirectCreation(propertyPath);
    }
}

