/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.library.advice;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.robotics.library.util.RoboticsLibResource;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class AdviceUtil {
    public static Classifier getPattern(Element anElement, final String patternQN) {
        Classifier pattern = AdviceUtil.getPatternWoMessage(anElement, patternQN);
        if (pattern == null) {
            PackageUtil.loadPackage((URI)RoboticsLibResource.ROBOTICS_LIB_URI, (ResourceSet)anElement.eResource().getResourceSet());
            pattern = AdviceUtil.getPatternWoMessage(anElement, patternQN);
            if (pattern == null) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Can not find communication pattern", (String)String.format("Cannot find communication pattern %s.", patternQN));
                    }
                });
            }
        }
        return pattern;
    }

    public static Classifier getPatternWoMessage(Element anElement, String patternQN) {
        NamedElement pattern = ElementUtils.getQualifiedElementFromRS((Element)anElement, (String)patternQN);
        if (pattern instanceof Classifier) {
            return (Classifier)pattern;
        }
        return null;
    }
}

