/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.editor.modelresource;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.resource.AbstractDynamicModel;
import org.eclipse.papyrus.infra.core.resource.BadArgumentExcetion;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.sirius.editor.internal.sessions.PapyrusSession;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DSemanticDiagram;

public class SiriusDiagramModel
extends AbstractDynamicModel<DSemanticDiagram> {
    private Session siriusSession = null;
    public static final String SIRIUS_DIAGRAM_MODEL_ID = "org.eclipse.papyrus.sirius.editor.DSemanticDiagram";
    private static final String SIRIUS_DIAGRAM_MODEL_FILE_EXTENSION = "aird";

    public void setSiriusSession(Session session) {
        this.siriusSession = session;
    }

    protected String getModelFileExtension() {
        return SIRIUS_DIAGRAM_MODEL_FILE_EXTENSION;
    }

    public String getIdentifier() {
        return SIRIUS_DIAGRAM_MODEL_ID;
    }

    public void loadModel(URI uriWithoutExtension) {
        if (this.exists(uriWithoutExtension)) {
            try {
                super.loadModel(uriWithoutExtension);
            }
            catch (Exception ex) {
                this.createModel(uriWithoutExtension);
            }
        }
        if (this.resource == null) {
            this.createModel(uriWithoutExtension);
        }
    }

    public void addDiagram(DSemanticDiagram siriusDiagram, EObject context) {
        Resource sessionRes;
        if (context != null && !(sessionRes = this.siriusSession.getSessionResource()).getContents().contains((Object)siriusDiagram)) {
            sessionRes.getContents().add((Object)siriusDiagram);
        }
    }

    public boolean canPersist(EObject object) {
        return this.getResource() != null && this.isSupportedRoot(object);
    }

    protected boolean isSupportedRoot(EObject object) {
        return object instanceof DSemanticDiagram;
    }

    public void persist(EObject object) {
        if (!this.canPersist(object)) {
            throw new IllegalArgumentException("cannot persist " + object);
        }
        this.getResource().getContents().add((Object)object);
    }

    protected void configureResource(Resource resource) {
        super.configureResource(resource);
    }

    public DSemanticDiagram getDiagram(String diagramName) throws NotFoundException, BadArgumentExcetion {
        if (diagramName == null || diagramName.length() == 0) {
            throw new BadArgumentExcetion("Diagram name should not be null and size should be >0.");
        }
        for (Resource current : this.modelSet.getResources()) {
            for (EObject element : current.getContents()) {
                DSemanticDiagram diagram;
                if (!(element instanceof DSemanticDiagram) || !diagramName.equals((diagram = (DSemanticDiagram)element).getName())) continue;
                return diagram;
            }
        }
        throw new NotFoundException(NLS.bind((String)"No Diagram named '{0}' can be found in Model.", (Object)diagramName));
    }

    public void unload() {
        this.siriusSession.close((IProgressMonitor)new NullProgressMonitor());
        this.siriusSession = null;
        super.unload();
    }

    public void saveModel() throws IOException {
        if (this.siriusSession != null) {
            if (this.siriusSession instanceof PapyrusSession) {
                ((PapyrusSession)this.siriusSession).papyrusSave(null, (IProgressMonitor)new NullProgressMonitor());
            } else {
                this.resource.save(null);
            }
        }
    }
}

