/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.breakpoint.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.moka.debug.breakpoint.MokaBreakpoint;
import org.eclipse.papyrus.moka.ui.breakpoint.commands.AbstractTraceAndDebugCommand;
import org.eclipse.uml2.uml.NamedElement;

public class ToggleBreakpointCommand
extends AbstractTraceAndDebugCommand {
    public ToggleBreakpointCommand(EObject selectedElement) {
        super("Toggle Breakpoint", TransactionUtil.getEditingDomain((EObject)selectedElement), selectedElement);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        String selectedElementURI = EcoreUtil.getURI((EObject)this.selectedElement).toString();
        if (this.selectedElement != null) {
            MokaBreakpoint breakpoint;
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint[] breakpoints = breakpointManager.getBreakpoints("org.eclipse.papyrus.moka.debug");
            MokaBreakpoint alreadyDefinedBreakpoint = null;
            int i = 0;
            while (i < breakpoints.length && alreadyDefinedBreakpoint == null) {
                breakpoint = (MokaBreakpoint)breakpoints[i];
                String eObjectOfBreakpointUri = null;
                try {
                    eObjectOfBreakpointUri = (String)breakpoint.getMarker().getAttribute("uri");
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
                if (eObjectOfBreakpointUri.equals(selectedElementURI)) {
                    alreadyDefinedBreakpoint = breakpoint;
                }
                ++i;
            }
            try {
                if (alreadyDefinedBreakpoint != null) {
                    breakpointManager.removeBreakpoint(alreadyDefinedBreakpoint, true);
                } else {
                    String label = "";
                    if (this.selectedElement instanceof NamedElement) {
                        label = ((NamedElement)this.selectedElement).getQualifiedName();
                    }
                    breakpoint = new MokaBreakpoint();
                    breakpoint.toggleBreakpoint(this.selectedElement, label);
                    breakpointManager.addBreakpoint((IBreakpoint)breakpoint);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            return null;
        }
        return null;
    }
}

