/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.kernel.service;

import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.papyrus.moka.kernel.service.ServiceClient;

public abstract class ServiceMqttClient
extends ServiceClient<MqttAsyncClient>
implements IMqttAsyncClient {
    protected MemoryPersistence clientPersistence = new MemoryPersistence();

    public ServiceMqttClient(String serverURI, String clientID) {
        try {
            this.client = new MqttAsyncClient(serverURI, clientID, (MqttClientPersistence)this.clientPersistence);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        if (this.client != null && ((MqttAsyncClient)this.client).isConnected()) {
            this.terminate();
        } else {
            MqttConnectOptions options = new MqttConnectOptions();
            options.setCleanSession(true);
            try {
                ((MqttAsyncClient)this.client).connect(options).waitForCompletion();
            }
            catch (MqttSecurityException e) {
                e.printStackTrace();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
        }
    }

    public void terminate() {
        block20: {
            if (this.client != null && ((MqttAsyncClient)this.client).isConnected()) {
                try {
                    try {
                        ((MqttAsyncClient)this.client).disconnect().waitForCompletion();
                    }
                    catch (MqttException e) {
                        e.printStackTrace();
                        if (((MqttAsyncClient)this.client).isConnected()) break block20;
                        try {
                            ((MqttAsyncClient)this.client).close();
                        }
                        catch (MqttException mqttException) {
                            try {
                                ((MqttAsyncClient)this.client).close(true);
                                break block20;
                            }
                            catch (MqttException e1) {
                                e1.printStackTrace();
                            }
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (!((MqttAsyncClient)this.client).isConnected()) {
                        try {
                            ((MqttAsyncClient)this.client).close();
                        }
                        catch (MqttException mqttException) {
                            try {
                                ((MqttAsyncClient)this.client).close(true);
                            }
                            catch (MqttException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                    throw throwable;
                }
                if (!((MqttAsyncClient)this.client).isConnected()) {
                    try {
                        ((MqttAsyncClient)this.client).close();
                    }
                    catch (MqttException mqttException) {
                        try {
                            ((MqttAsyncClient)this.client).close(true);
                        }
                        catch (MqttException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    public void close() throws MqttException {
        if (this.client != null) {
            ((MqttAsyncClient)this.client).close();
        }
    }

    public IMqttToken connect() throws MqttException, MqttSecurityException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).connect();
        }
        return null;
    }

    public IMqttToken connect(MqttConnectOptions arg0) throws MqttException, MqttSecurityException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).connect(arg0);
        }
        return null;
    }

    public IMqttToken connect(Object arg0, IMqttActionListener arg1) throws MqttException, MqttSecurityException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).connect(arg0, arg1);
        }
        return null;
    }

    public IMqttToken connect(MqttConnectOptions arg0, Object arg1, IMqttActionListener arg2) throws MqttException, MqttSecurityException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).connect(arg0, arg1, arg2);
        }
        return null;
    }

    public IMqttToken disconnect() throws MqttException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).disconnect();
        }
        return null;
    }

    public IMqttToken disconnect(long arg0) throws MqttException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).disconnect(arg0);
        }
        return null;
    }

    public IMqttToken disconnect(Object arg0, IMqttActionListener arg1) throws MqttException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).disconnect(arg0, arg1);
        }
        return null;
    }

    public IMqttToken disconnect(long arg0, Object arg1, IMqttActionListener arg2) throws MqttException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).disconnect(arg0, arg1, arg2);
        }
        return null;
    }

    public void disconnectForcibly() throws MqttException {
        if (this.client != null) {
            ((MqttAsyncClient)this.client).disconnectForcibly();
        }
    }

    public void disconnectForcibly(long arg0) throws MqttException {
        if (this.client != null) {
            ((MqttAsyncClient)this.client).disconnectForcibly(arg0);
        }
    }

    public void disconnectForcibly(long arg0, long arg1) throws MqttException {
        if (this.client != null) {
            ((MqttAsyncClient)this.client).disconnectForcibly(arg0, arg1);
        }
    }

    public String getClientId() {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).getClientId();
        }
        return null;
    }

    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).getPendingDeliveryTokens();
        }
        return null;
    }

    public String getServerURI() {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).getServerURI();
        }
        return null;
    }

    public boolean isConnected() {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).isConnected();
        }
        return false;
    }

    public void messageArrivedComplete(int arg0, int arg1) throws MqttException {
        if (this.client != null) {
            ((MqttAsyncClient)this.client).messageArrivedComplete(arg0, arg1);
        }
    }

    public IMqttDeliveryToken publish(String arg0, MqttMessage arg1) throws MqttException, MqttPersistenceException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).publish(arg0, arg1);
        }
        return null;
    }

    public IMqttDeliveryToken publish(String arg0, byte[] arg1, int arg2, boolean arg3) throws MqttException, MqttPersistenceException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).publish(arg0, arg1, arg2, arg3);
        }
        return null;
    }

    public IMqttDeliveryToken publish(String arg0, MqttMessage arg1, Object arg2, IMqttActionListener arg3) throws MqttException, MqttPersistenceException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).publish(arg0, arg1, arg2, arg3);
        }
        return null;
    }

    public IMqttDeliveryToken publish(String arg0, byte[] arg1, int arg2, boolean arg3, Object arg4, IMqttActionListener arg5) throws MqttException, MqttPersistenceException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).publish(arg0, arg1, arg2, arg3, arg4, arg5);
        }
        return null;
    }

    public void setCallback(MqttCallback arg0) {
        if (this.client != null) {
            ((MqttAsyncClient)this.client).setCallback(arg0);
        }
    }

    public void setManualAcks(boolean arg0) {
        if (this.client != null) {
            ((MqttAsyncClient)this.client).setManualAcks(arg0);
        }
    }

    public IMqttToken subscribe(String arg0, int arg1) throws MqttException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).subscribe(arg0, arg1);
        }
        return null;
    }

    public IMqttToken subscribe(String[] arg0, int[] arg1) throws MqttException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).subscribe(arg0, arg1);
        }
        return null;
    }

    public IMqttToken subscribe(String arg0, int arg1, IMqttMessageListener arg2) throws MqttException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).subscribe(arg0, arg1, arg2);
        }
        return null;
    }

    public IMqttToken subscribe(String[] arg0, int[] arg1, IMqttMessageListener[] arg2) throws MqttException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).subscribe(arg0, arg1, arg2);
        }
        return null;
    }

    public IMqttToken subscribe(String arg0, int arg1, Object arg2, IMqttActionListener arg3) throws MqttException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).subscribe(arg0, arg1, arg2, arg3);
        }
        return null;
    }

    public IMqttToken subscribe(String[] arg0, int[] arg1, Object arg2, IMqttActionListener arg3) throws MqttException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).subscribe(arg0, arg1, arg2, arg3);
        }
        return null;
    }

    public IMqttToken subscribe(String arg0, int arg1, Object arg2, IMqttActionListener arg3, IMqttMessageListener arg4) throws MqttException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).subscribe(arg0, arg1, arg2, arg3, arg4);
        }
        return null;
    }

    public IMqttToken subscribe(String[] arg0, int[] arg1, Object arg2, IMqttActionListener arg3, IMqttMessageListener[] arg4) throws MqttException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).subscribe(arg0, arg1, arg2, arg3, arg4);
        }
        return null;
    }

    public IMqttToken unsubscribe(String arg0) throws MqttException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).unsubscribe(arg0);
        }
        return null;
    }

    public IMqttToken unsubscribe(String[] arg0) throws MqttException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).unsubscribe(arg0);
        }
        return null;
    }

    public IMqttToken unsubscribe(String arg0, Object arg1, IMqttActionListener arg2) throws MqttException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).unsubscribe(arg0, arg1, arg2);
        }
        return null;
    }

    public IMqttToken unsubscribe(String[] arg0, Object arg1, IMqttActionListener arg2) throws MqttException {
        if (this.client != null) {
            return ((MqttAsyncClient)this.client).unsubscribe(arg0, arg1, arg2);
        }
        return null;
    }
}

