/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.loci;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IExecution;
import org.eclipse.papyrus.moka.fuml.loci.IExecutionFactory;
import org.eclipse.papyrus.moka.fuml.loci.IExecutor;
import org.eclipse.papyrus.moka.fuml.loci.ILocus;
import org.eclipse.papyrus.moka.fuml.profiling.loci.ExecutionFactoryProfiler;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IExtensionalValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.Object_;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;

public class Locus
implements ILocus {
    public String identifier;
    public Behavior currentModelToBeExecuted;
    public IExecutor executor;
    public IExecutionFactory factory;
    public List<IExtensionalValue> extensionalValues = new ArrayList<IExtensionalValue>();

    public void setExecutor(IExecutor executor) {
        this.executor = executor;
        this.executor.setLocus((ILocus)this);
    }

    public void setFactory(IExecutionFactory factory) {
        this.factory = factory;
        this.factory.setLocus((ILocus)this);
    }

    public List<IExtensionalValue> getExtent(Classifier classifier) {
        ArrayList<IExtensionalValue> extent = new ArrayList<IExtensionalValue>();
        List<IExtensionalValue> extensionalValues = this.extensionalValues;
        int i = 0;
        while (i < extensionalValues.size()) {
            IExtensionalValue value = extensionalValues.get(i);
            List types = value.getTypes();
            boolean conforms = false;
            int j = 1;
            while (!conforms & j <= types.size()) {
                conforms = this.conforms((Classifier)types.get(j - 1), classifier);
                ++j;
            }
            if (conforms) {
                extent.add(value);
            }
            ++i;
        }
        return extent;
    }

    public void add(IExtensionalValue value) {
        value.setLocus((ILocus)this);
        value.setIdentifier(this.makeIdentifier(value));
        this.extensionalValues.add(value);
    }

    public void remove(IExtensionalValue value) {
        value.setLocus(null);
        boolean notFound = true;
        int i = 1;
        while (notFound & i <= this.extensionalValues.size()) {
            if (this.extensionalValues.get(i - 1) == value) {
                this.extensionalValues.remove(i - 1);
                notFound = false;
            }
            ++i;
        }
    }

    public IObject_ instantiate(Class type) {
        Object_ object = null;
        if (type instanceof Behavior) {
            IObject_ iObject_ = null;
            Behavior behavior = (Behavior)type;
            IExecutionFactory iExecutionFactory = this.factory;
            IExecution iExecution = iExecutionFactory.createExecution(behavior, iObject_);
            ExecutionFactoryProfiler.aspectOf().ajc$afterReturning$org_eclipse_papyrus_moka_fuml_profiling_loci_ExecutionFactoryProfiler$1$835cd872(iExecutionFactory, behavior, iObject_, iExecution);
            object = iExecution;
        } else {
            object = new Object_();
            object.addType(type);
            object.createFeatureValues();
            this.add(object);
        }
        return object;
    }

    public Boolean conforms(Classifier type, Classifier classifier) {
        boolean doesConform = false;
        if (type == classifier) {
            doesConform = true;
        } else {
            int i = 1;
            while (!doesConform & i <= type.getGenerals().size()) {
                doesConform = this.conforms((Classifier)type.getGenerals().get(i - 1), classifier);
                ++i;
            }
        }
        return doesConform;
    }

    public String makeIdentifier(IExtensionalValue value) {
        boolean multipleTypes;
        String prefix = "";
        boolean bl = multipleTypes = value.getTypes().size() > 1;
        if (multipleTypes) {
            prefix = String.valueOf(prefix) + "[";
        }
        Iterator typeIterator = value.getTypes().iterator();
        while (typeIterator.hasNext()) {
            prefix = String.valueOf(prefix) + ((Classifier)typeIterator.next()).getName();
            if (!typeIterator.hasNext()) continue;
            prefix = String.valueOf(prefix) + ", ";
        }
        if (multipleTypes) {
            prefix = String.valueOf(prefix) + "]";
        }
        return String.valueOf(prefix) + "@" + UUID.randomUUID().toString();
    }

    public IExecutor getExecutor() {
        return this.executor;
    }

    public IExecutionFactory getFactory() {
        return this.factory;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setExecutedTarget(Behavior behavior) {
        this.currentModelToBeExecuted = behavior;
    }

    public List<IExtensionalValue> getExtensionalValues() {
        return this.extensionalValues;
    }
}

