/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.activities;

import java.util.List;
import org.eclipse.papyrus.moka.fuml.actions.IPinActivation;
import org.eclipse.papyrus.moka.fuml.activities.IActivityParameterNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IToken;
import org.eclipse.papyrus.moka.fuml.activities.ObjectNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.ObjectToken;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IParameterValue;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.profiling.activities.PinActivationProfiler;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.Parameter;

public class ActivityParameterNodeActivation
extends ObjectNodeActivation
implements IActivityParameterNodeActivation {
    @Override
    public void fire(List<IToken> incomingTokens) {
        if (this.getNode().getIncomings().size() == 0) {
            Debug.println("[fire] Input activity parameter node " + this.getNode().getName() + "...");
            Parameter parameter = ((ActivityParameterNode)this.getNode()).getParameter();
            IParameterValue parameterValue = this.getActivityExecution().getParameterValue(parameter);
            if (parameterValue != null) {
                Debug.println("[fire] Parameter has " + parameterValue.getValues().size() + " value(s).");
                List values = parameterValue.getValues();
                int i = 0;
                while (i < values.size()) {
                    IValue value = (IValue)values.get(i);
                    ObjectToken token = new ObjectToken();
                    token.value = value;
                    this.addToken(token);
                    ++i;
                }
                this.sendUnofferedTokens();
            }
        } else {
            Debug.println("[fire] Output activity parameter node " + this.node.getName() + "...");
            List<IToken> list = incomingTokens;
            ActivityParameterNodeActivation activityParameterNodeActivation = this;
            try {
                activityParameterNodeActivation.addTokens(list);
            }
            finally {
                if (activityParameterNodeActivation instanceof IPinActivation) {
                    PinActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_activities_PinActivationProfiler$1$44250678((IPinActivation)activityParameterNodeActivation, list);
                }
            }
        }
    }

    @Override
    public void clearTokens() {
        if (this.node.getIncomings().size() == 0) {
            super.clearTokens();
        }
    }
}

