/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.moka.fuml.actions.ConditionalNodeActivation;
import org.eclipse.papyrus.moka.fuml.actions.IClauseActivation;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.BooleanValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IBooleanValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.uml2.uml.Clause;

public class ClauseActivation
implements IClauseActivation {
    public ConditionalNodeActivation conditionalNodeActivation;
    public Clause clause;

    public void receiveControl() {
        Debug.println("[receiveControl] clauseActivation = " + this);
        if (this.isReady().booleanValue()) {
            Debug.println("[receiveControl] Running test...");
            this.runTest();
            BooleanValue decision = this.getDecision();
            if (decision != null) {
                if (decision.value.booleanValue()) {
                    Debug.println("[receiveControl] Test succeeded.");
                    this.selectBody();
                } else {
                    Debug.println("[receiveControl] Test failed.");
                    List<IClauseActivation> successors = this.getSuccessors();
                    for (IClauseActivation successor : successors) {
                        successor.receiveControl();
                    }
                }
            }
        }
    }

    public Boolean isReady() {
        List<IClauseActivation> predecessors = this.getPredecessors();
        boolean ready = true;
        int i = 1;
        while (ready & i <= predecessors.size()) {
            IClauseActivation predecessor = predecessors.get(i - 1);
            IBooleanValue decisionValue = predecessor.getDecision();
            ready = decisionValue == null ? false : decisionValue.getValue() == false;
            ++i;
        }
        return ready;
    }

    public void runTest() {
        this.conditionalNodeActivation.runTest(this.clause);
    }

    public void selectBody() {
        this.conditionalNodeActivation.selectBody(this.clause);
    }

    public BooleanValue getDecision() {
        List<IValue> deciderValues = this.conditionalNodeActivation.getPinValues(this.clause.getDecider());
        BooleanValue deciderValue = null;
        if (deciderValues.size() > 0) {
            deciderValue = (BooleanValue)deciderValues.get(0);
        }
        return deciderValue;
    }

    public List<IClauseActivation> getPredecessors() {
        ArrayList<IClauseActivation> predecessors = new ArrayList<IClauseActivation>();
        EList predecessorClauses = this.clause.getPredecessorClauses();
        int i = 0;
        while (i < predecessorClauses.size()) {
            Clause predecessorClause = (Clause)predecessorClauses.get(i);
            predecessors.add(this.conditionalNodeActivation.getClauseActivation(predecessorClause));
            ++i;
        }
        return predecessors;
    }

    public List<IClauseActivation> getSuccessors() {
        ArrayList<IClauseActivation> successors = new ArrayList<IClauseActivation>();
        EList successorClauses = this.clause.getSuccessorClauses();
        int i = 0;
        while (i < successorClauses.size()) {
            Clause successorClause = (Clause)successorClauses.get(i);
            successors.add(this.conditionalNodeActivation.getClauseActivation(successorClause));
            ++i;
        }
        return successors;
    }
}

