/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine.uml.animation.service;

import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.moka.animation.engine.AnimationService;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationKind;
import org.eclipse.papyrus.moka.animation.engine.rendering.DiagramHandler;
import org.eclipse.papyrus.moka.engine.uml.animation.animators.UMLAnimator;
import org.eclipse.papyrus.moka.fuml.loci.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.profiling.listeners.IRTCStepListener;
import org.eclipse.papyrus.moka.fuml.profiling.listeners.ISemanticVisitorExecutionListener;
import org.eclipse.papyrus.moka.fuml.profiling.listeners.IValueLifecyleListener;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IReference;
import org.eclipse.papyrus.moka.kernel.assistant.Suspension;
import org.eclipse.papyrus.moka.kernel.engine.IExecutionEngine;
import org.eclipse.papyrus.moka.utils.constants.MokaConstants;

public class UMLAnimationService
extends AnimationService
implements ISemanticVisitorExecutionListener,
IRTCStepListener,
IValueLifecyleListener {
    public void nodeVisited(ISemanticVisitor nodeVisitor) {
        UMLAnimator animator;
        if (MokaConstants.MOKA_AUTOMATIC_ANIMATION && (animator = (UMLAnimator)this.getAnimator(nodeVisitor)) != null) {
            animator.nodeVisited(nodeVisitor);
        }
    }

    public void nodeLeft(ISemanticVisitor nodeVisitor) {
        UMLAnimator animator;
        if (MokaConstants.MOKA_AUTOMATIC_ANIMATION && (animator = (UMLAnimator)this.getAnimator(nodeVisitor)) != null) {
            animator.nodeLeft(nodeVisitor);
        }
    }

    public void nodeSuspended(ISemanticVisitor nodeVisitor, Suspension suspension) {
        UMLAnimator animator;
        if (MokaConstants.MOKA_AUTOMATIC_ANIMATION && (animator = (UMLAnimator)this.getAnimator(nodeVisitor)) != null) {
            animator.nodeSuspended(nodeVisitor, suspension);
        }
    }

    public void valueCreated(IValue value) {
        if (MokaConstants.MOKA_AUTOMATIC_ANIMATION) {
            UMLAnimator animator;
            DiagramHandler diagramHandler;
            if (value instanceof IObject_ && !(diagramHandler = this.engine.getDiagramHandler()).isRegistered((IObject_)value)) {
                Set relatedDiagrams = diagramHandler.findDiagramsInvolved((IObject_)value);
                for (Diagram diagram : relatedDiagrams) {
                    diagramHandler.addRenderable((IObject_)value, diagram);
                }
            }
            if ((animator = (UMLAnimator)this.getAnimator((ISemanticVisitor)value)) != null) {
                animator.valueCreated(value);
            }
        }
    }

    public void valueDestroyed(IValue value) {
        if (MokaConstants.MOKA_AUTOMATIC_ANIMATION) {
            UMLAnimator animator;
            if (value instanceof IObject_) {
                this.engine.getDiagramHandler().deleteRenderable((IObject_)value);
            }
            if ((animator = (UMLAnimator)this.getAnimator((ISemanticVisitor)value)) != null) {
                animator.valueDestroyed(value);
            }
        }
    }

    public void rtcStepBegin(IReference context) {
        UMLAnimator animator;
        if (MokaConstants.MOKA_AUTOMATIC_ANIMATION && (animator = (UMLAnimator)this.getAnimator((ISemanticVisitor)context)) != null) {
            animator.rtcStepBegin(context);
        }
    }

    public void rtcStepEnd(IReference context) {
        UMLAnimator animator;
        if (MokaConstants.MOKA_AUTOMATIC_ANIMATION && (animator = (UMLAnimator)this.getAnimator((ISemanticVisitor)context)) != null) {
            animator.rtcStepEnd(context);
        }
    }

    public void dispose() {
        this.engine.clean();
    }

    public void renderAs(EObject modelElement, IObject_ animator, AnimationKind targetStyle) {
        this.engine.removeRenderingRules(modelElement);
        this.engine.startRendering(modelElement, animator, targetStyle);
    }

    public void renderAs(EObject modelElement, IObject_ animator, AnimationKind sourceStyle, AnimationKind targetStyle, int duration) {
        this.engine.removeRenderingRules(modelElement);
        this.engine.startRendering(modelElement, animator, sourceStyle);
        if (duration >= 25) {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.engine.stopRendering(modelElement, animator, sourceStyle);
        this.engine.startRendering(modelElement, animator, targetStyle);
    }

    public void dispose(IExecutionEngine engine) {
        this.engine.deleteAllMarkers();
    }
}

