/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.xygraph.model.xygraph;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ZoomType implements Enumerator
{
    NONE(11, "NONE", "NONE"),
    RUBBERBAND_ZOOM(0, "RUBBERBAND_ZOOM", "RUBBERBAND_ZOOM"),
    DYNAMIC_ZOOM(1, "DYNAMIC_ZOOM", "DYNAMIC_ZOOM"),
    HORIZONTAL_ZOOM(2, "HORIZONTAL_ZOOM", "HORIZONTAL_ZOOM"),
    VERTICAL_ZOOM(3, "VERTICAL_ZOOM", "VERTICAL_ZOOM"),
    ZOOM_IN(4, "ZOOM_IN", "ZOOM_IN"),
    ZOOM_OUT(5, "ZOOM_OUT", "ZOOM_OUT"),
    ZOOM_IN_HORIZONTALLY(6, "ZOOM_IN_HORIZONTALLY", "ZOOM_IN_HORIZONTALLY"),
    ZOOM_OUT_HORIZONTALLY(7, "ZOOM_OUT_HORIZONTALLY", "ZOOM_OUT_HORIZONTALLY"),
    ZOOM_IN_VERTICALLY(8, "ZOOM_IN_VERTICALLY", "ZOOM_IN_VERTICALLY"),
    ZOOM_OUT_VERTICALLY(9, "ZOOM_OUT_VERTICALLY", "ZOOM_OUT_VERTICALLY"),
    PANNING(10, "PANNING", "PANNING");

    public static final int NONE_VALUE = 11;
    public static final int RUBBERBAND_ZOOM_VALUE = 0;
    public static final int DYNAMIC_ZOOM_VALUE = 1;
    public static final int HORIZONTAL_ZOOM_VALUE = 2;
    public static final int VERTICAL_ZOOM_VALUE = 3;
    public static final int ZOOM_IN_VALUE = 4;
    public static final int ZOOM_OUT_VALUE = 5;
    public static final int ZOOM_IN_HORIZONTALLY_VALUE = 6;
    public static final int ZOOM_OUT_HORIZONTALLY_VALUE = 7;
    public static final int ZOOM_IN_VERTICALLY_VALUE = 8;
    public static final int ZOOM_OUT_VERTICALLY_VALUE = 9;
    public static final int PANNING_VALUE = 10;
    private static final ZoomType[] VALUES_ARRAY;
    public static final List<ZoomType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ZoomType[]{NONE, RUBBERBAND_ZOOM, DYNAMIC_ZOOM, HORIZONTAL_ZOOM, VERTICAL_ZOOM, ZOOM_IN, ZOOM_OUT, ZOOM_IN_HORIZONTALLY, ZOOM_OUT_HORIZONTALLY, ZOOM_IN_VERTICALLY, ZOOM_OUT_VERTICALLY, PANNING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ZoomType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ZoomType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ZoomType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ZoomType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ZoomType get(int value) {
        switch (value) {
            case 11: {
                return NONE;
            }
            case 0: {
                return RUBBERBAND_ZOOM;
            }
            case 1: {
                return DYNAMIC_ZOOM;
            }
            case 2: {
                return HORIZONTAL_ZOOM;
            }
            case 3: {
                return VERTICAL_ZOOM;
            }
            case 4: {
                return ZOOM_IN;
            }
            case 5: {
                return ZOOM_OUT;
            }
            case 6: {
                return ZOOM_IN_HORIZONTALLY;
            }
            case 7: {
                return ZOOM_OUT_HORIZONTALLY;
            }
            case 8: {
                return ZOOM_IN_VERTICALLY;
            }
            case 9: {
                return ZOOM_OUT_VERTICALLY;
            }
            case 10: {
                return PANNING;
            }
        }
        return null;
    }

    private ZoomType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

