/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.simex.utils;

import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.UMLPackage;

public class EventUtil {
    public static final String EVENT_PACKAGE_NAME = "Events";
    public static final String EVENT_SUFFIX = "Event";

    public static Package getEventPackage(Element context) {
        return EventUtil.getEventPackage(context, true);
    }

    public static Package getEventPackage(Element context, boolean create) {
        Package ret = null;
        Model root = context.getModel();
        ret = root.getNestedPackage(EVENT_PACKAGE_NAME);
        if (ret == null && create) {
            ret = root.createNestedPackage(EVENT_PACKAGE_NAME);
        }
        return ret;
    }

    public static SignalEvent getSignalEvent(Signal signal, boolean create) {
        Package eventPack = EventUtil.getEventPackage((Element)signal, create);
        if (eventPack != null) {
            for (PackageableElement elem : eventPack.getPackagedElements()) {
                if (!(elem instanceof SignalEvent) || !signal.equals(((SignalEvent)elem).getSignal())) continue;
                return (SignalEvent)elem;
            }
            if (create) {
                SignalEvent event = (SignalEvent)eventPack.createPackagedElement(String.valueOf(signal.getName()) + EVENT_SUFFIX, UMLPackage.eINSTANCE.getSignalEvent());
                event.setSignal(signal);
                return event;
            }
        }
        return null;
    }

    public static SignalEvent getSignalEvent(Signal signal) {
        return EventUtil.getSignalEvent(signal, true);
    }

    public static void alignEventName(Signal signal) {
        String signalName = signal.getName();
        if (signalName != null) {
            SignalEvent event = EventUtil.getSignalEvent(signal);
            event.setName(String.valueOf(signalName) + EVENT_SUFFIX);
        }
    }

    public static CallEvent getCallEvent(Operation operation) {
        Package eventPack = EventUtil.getEventPackage((Element)operation);
        for (PackageableElement elem : eventPack.getPackagedElements()) {
            if (!(elem instanceof CallEvent) || !operation.equals(((CallEvent)elem).getOperation())) continue;
            return (CallEvent)elem;
        }
        CallEvent event = (CallEvent)eventPack.createPackagedElement(String.valueOf(operation.getQualifiedName()) + EVENT_SUFFIX, UMLPackage.eINSTANCE.getCallEvent());
        event.setOperation(operation);
        return event;
    }
}

