/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.validation.constraints;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.ConnectorKind;
import org.eclipse.uml2.uml.Port;

public class NoDelegationConnectorOnNonBehaviorPort_Constraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        Port port = (Port)ctx.getTarget();
        if (!port.isBehavior()) {
            Class owner = (Class)port.getOwner();
            boolean delegationFound = false;
            Iterator i = owner.getOwnedConnectors().iterator();
            while (i.hasNext() && !delegationFound) {
                Connector c = (Connector)i.next();
                if (c.getKind() != ConnectorKind.DELEGATION_LITERAL) continue;
                boolean endFound = false;
                Iterator j = c.getEnds().iterator();
                while (j.hasNext() && !endFound) {
                    ConnectorEnd ce = (ConnectorEnd)j.next();
                    if (ce.getPartWithPort() != null || ce.getRole() != port) continue;
                    endFound = true;
                }
                if (!endFound) continue;
                return ctx.createSuccessStatus();
            }
            return ctx.createFailureStatus(new Object[]{"A non-behavior port shall have delegation connectors"});
        }
        return ctx.createSuccessStatus();
    }
}

