/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.composites.utils.handlers;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.profile.RegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.CreateObjectAction;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ForkNode;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.StartObjectBehaviorAction;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class Utils {
    public static Profile standardProfile;
    public static String STANDARD_PROFILE_NAME;

    static {
        STANDARD_PROFILE_NAME = "Standard";
    }

    public static Activity getFactory(Class context) {
        Activity factory = null;
        String contextName = context.getName() == null ? "" : context.getName();
        Iterator i = context.getOwnedBehaviors().iterator();
        while (i.hasNext() && factory == null) {
            String cddName;
            Behavior cddFactory = (Behavior)i.next();
            String string = cddName = cddFactory.getName() == null ? "" : cddFactory.getName();
            if (!(cddFactory instanceof Activity) || !cddName.equals(String.valueOf(contextName) + "_Factory")) continue;
            factory = (Activity)cddFactory;
        }
        Parameter returnParam = null;
        if (factory == null) {
            factory = (Activity)context.createOwnedBehavior(String.valueOf(context.getName()) + "_Factory", UMLPackage.eINSTANCE.getActivity());
            returnParam = factory.createOwnedParameter("result", (Type)context);
            returnParam.setDirection(ParameterDirectionKind.RETURN_LITERAL);
        } else {
            factory.getNodes().clear();
            factory.getEdges().clear();
            Iterator i2 = factory.getOwnedParameters().iterator();
            while (i2.hasNext() && returnParam == null) {
                Parameter cddReturn = (Parameter)i2.next();
                if (cddReturn.getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
                returnParam = cddReturn;
            }
            if (returnParam == null) {
                returnParam = factory.createOwnedParameter("result", (Type)context);
                returnParam.setDirection(ParameterDirectionKind.RETURN_LITERAL);
            }
        }
        ActivityParameterNode returnParamNode = (ActivityParameterNode)factory.createOwnedNode("resultParameterNode", UMLPackage.eINSTANCE.getActivityParameterNode());
        returnParamNode.setParameter(returnParam);
        returnParamNode.setType((Type)context);
        LiteralInteger returnParamNodeUpperBound = UMLFactory.eINSTANCE.createLiteralInteger();
        returnParamNodeUpperBound.setValue(1);
        returnParamNode.setUpperBound((ValueSpecification)returnParamNodeUpperBound);
        Operation defaultConstructor = Utils.getDefaultConstructor(context);
        CreateObjectAction createObject = (CreateObjectAction)factory.createOwnedNode("createObject", UMLPackage.eINSTANCE.getCreateObjectAction());
        OutputPin createObjectResultPin = createObject.createResult("result", (Type)context);
        LiteralInteger createObjectResultPinUpperBound = UMLFactory.eINSTANCE.createLiteralInteger();
        createObjectResultPinUpperBound.setValue(1);
        createObjectResultPin.setUpperBound((ValueSpecification)createObjectResultPinUpperBound);
        createObject.setClassifier((Classifier)context);
        CallOperationAction callConstructor = (CallOperationAction)factory.createOwnedNode("callConstructor", UMLPackage.eINSTANCE.getCallOperationAction());
        callConstructor.setOperation(defaultConstructor);
        InputPin callConstructorTargetPin = callConstructor.createTarget("target", (Type)context);
        LiteralInteger callConstructorTargetPinUpperBound = UMLFactory.eINSTANCE.createLiteralInteger();
        callConstructorTargetPinUpperBound.setValue(1);
        callConstructorTargetPin.setUpperBound((ValueSpecification)callConstructorTargetPinUpperBound);
        OutputPin callConstructorResultPin = callConstructor.createResult("result", (Type)context);
        LiteralInteger callConstructorResultPinUpperBound = UMLFactory.eINSTANCE.createLiteralInteger();
        callConstructorResultPinUpperBound.setValue(1);
        callConstructorResultPin.setUpperBound((ValueSpecification)callConstructorResultPinUpperBound);
        ObjectFlow createObjectAction_callConstructor = (ObjectFlow)factory.createEdge("createObjectAction to callConstructor", UMLPackage.eINSTANCE.getObjectFlow());
        createObjectAction_callConstructor.setSource((ActivityNode)createObjectResultPin);
        createObjectAction_callConstructor.setTarget((ActivityNode)callConstructorTargetPin);
        ObjectFlow toReturnParamNode = (ObjectFlow)factory.createEdge("callConstructor to returnParamNode", UMLPackage.eINSTANCE.getObjectFlow());
        toReturnParamNode.setTarget((ActivityNode)returnParamNode);
        if (!context.isActive()) {
            toReturnParamNode.setSource((ActivityNode)callConstructorResultPin);
        } else {
            StartObjectBehaviorAction startBehavior = (StartObjectBehaviorAction)factory.createOwnedNode("start classifier behavior", UMLPackage.eINSTANCE.getStartObjectBehaviorAction());
            InputPin startBehaviorInputPin = startBehavior.createObject("object", (Type)context);
            LiteralInteger startBehaviorInputPinUpperBound = UMLFactory.eINSTANCE.createLiteralInteger();
            startBehaviorInputPinUpperBound.setValue(1);
            startBehaviorInputPin.setUpperBound((ValueSpecification)startBehaviorInputPinUpperBound);
            ForkNode fork = (ForkNode)factory.createOwnedNode("forkInstanciatedObject", UMLPackage.eINSTANCE.getForkNode());
            toReturnParamNode.setSource((ActivityNode)fork);
            ObjectFlow forkToStartBehaviorInputPin = (ObjectFlow)factory.createEdge("fork to startbehavior input pin", UMLPackage.eINSTANCE.getObjectFlow());
            forkToStartBehaviorInputPin.setSource((ActivityNode)fork);
            forkToStartBehaviorInputPin.setTarget((ActivityNode)startBehaviorInputPin);
            ObjectFlow callConstructor_startBehavior = (ObjectFlow)factory.createEdge("callConstructor to startBehavior", UMLPackage.eINSTANCE.getObjectFlow());
            callConstructor_startBehavior.setSource((ActivityNode)callConstructorResultPin);
            callConstructor_startBehavior.setTarget((ActivityNode)fork);
        }
        return factory;
    }

    public static Operation getDefaultConstructor(Class context) {
        Operation createdOp = null;
        int i = 0;
        while (i < context.getOwnedOperations().size() && createdOp == null) {
            Operation cddOperation = (Operation)context.getOwnedOperations().get(i);
            int j = 0;
            while (j < cddOperation.getAppliedStereotypes().size()) {
                Parameter returnParameter;
                Stereotype createStereotype = (Stereotype)cddOperation.getAppliedStereotypes().get(j);
                if (createStereotype.getName().equals("Create") && cddOperation.getName().equals(context.getName()) && cddOperation.getOwnedParameters().size() == 1 && (returnParameter = (Parameter)cddOperation.getOwnedParameters().get(0)).getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL) && returnParameter.getType().getName().equals(context.getName())) {
                    createdOp = cddOperation;
                }
                ++j;
            }
            ++i;
        }
        if (createdOp == null) {
            Stereotype appliedStereotype = null;
            if (!Utils.isStandardProfileApplied((Element)context)) {
                PackageUtil.applyProfile((Package)context.getModel(), (Profile)standardProfile, (boolean)true);
            }
            createdOp = UMLFactory.eINSTANCE.createOperation();
            context.getOwnedOperations().add((Object)createdOp);
            int j = 0;
            while (j < createdOp.getApplicableStereotypes().size() && appliedStereotype == null) {
                Stereotype cddStereotype = (Stereotype)createdOp.getApplicableStereotypes().get(j);
                if (cddStereotype.getName().equals("Create")) {
                    appliedStereotype = cddStereotype;
                }
                ++j;
            }
            Parameter result = UMLFactory.eINSTANCE.createParameter();
            result.setDirection(ParameterDirectionKind.RETURN_LITERAL);
            result.setType((Type)context);
            result.setName("return");
            createdOp.setName(context.getName());
            createdOp.getOwnedParameters().add((Object)result);
            createdOp.applyStereotype(appliedStereotype);
        }
        return createdOp;
    }

    public static Activity getMethod(Class context, Operation operation) {
        Activity method = null;
        if (operation.getMethods().isEmpty()) {
            method = (Activity)context.createOwnedBehavior(String.valueOf(operation.getName()) + "Impl", UMLPackage.eINSTANCE.getActivity());
            method.setSpecification((BehavioralFeature)operation);
            for (Parameter p : operation.getOwnedParameters()) {
                Parameter pAct = method.createOwnedParameter(p.getName(), p.getType());
                pAct.setDirection(p.getDirection());
                pAct.setLowerValue(pAct.getLowerValue());
                pAct.setUpperValue(p.getUpperValue());
            }
        } else {
            Iterator i = operation.getMethods().iterator();
            while (i.hasNext() && method == null) {
                Behavior b = (Behavior)i.next();
                if (!(b instanceof Activity)) continue;
                method = (Activity)b;
            }
        }
        return method;
    }

    public static boolean isStandardProfileApplied(Element element) {
        if (standardProfile == null) {
            IRegisteredProfile registeredProfile = RegisteredProfile.getRegisteredProfile((String)STANDARD_PROFILE_NAME);
            URI modelUri = registeredProfile.getUri();
            Resource modelResource = Util.createTemporaryResourceSet().getResource(modelUri, true);
            if (modelResource.getContents().get(0) instanceof Profile) {
                standardProfile = (Profile)modelResource.getContents().get(0);
            }
        }
        EList appliedProfiles = element.getModel().getAppliedProfiles();
        return appliedProfiles.contains(standardProfile);
    }

    public static Element getSelection() {
        Element selectedElement = null;
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            EObject selectedEObject;
            Object selectedobject = ((IStructuredSelection)selection).getFirstElement();
            if (selectedobject instanceof GraphicalEditPart) {
                Object graphicalElement = ((GraphicalEditPart)selectedobject).getModel();
                if (graphicalElement instanceof View && ((View)graphicalElement).getElement() instanceof Element) {
                    selectedElement = (Element)((View)graphicalElement).getElement();
                }
            } else if (selectedobject instanceof IAdaptable && (selectedEObject = (EObject)((IAdaptable)selectedobject).getAdapter(EObject.class)) instanceof Element) {
                selectedElement = (Element)selectedEObject;
            }
            return selectedElement;
        }
        return null;
    }
}

