/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.animation.engine.animators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.moka.animation.engine.animators.Animator;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationEngine;

public class AnimatorExtensionEvaluator {
    private static final String ANIMATOR_ID = "org.eclipse.papyrus.moka.animation.animator";
    private static final String PRIORITY_ATTR = "priority";
    private static final String CLASS_ATTR = "class";

    public static List<Animator> evaluateAnimators(AnimationEngine engine) {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] configuration = registry.getConfigurationElementsFor(ANIMATOR_ID);
        int i = 0;
        while (i < configuration.length) {
            IConfigurationElement contribution = configuration[i];
            Animator animator = null;
            try {
                animator = (Animator)contribution.createExecutableExtension(CLASS_ATTR);
                animator.setAnimationEngine(engine);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (animator != null) {
                String prioritySpecification = contribution.getAttribute(PRIORITY_ATTR);
                if (prioritySpecification != null && !prioritySpecification.isEmpty()) {
                    int priority = 0;
                    try {
                        priority = Integer.parseInt(prioritySpecification);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    animator.setPriority(priority);
                } else {
                    animator.setPriority(0);
                }
                animators.add(animator);
            }
            ++i;
        }
        return animators;
    }
}

