/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.xygraph.mapping.util;

public class TraceDataBounds {
    private double xMin;
    private double yMin;
    private double xMax;
    private double yMax;

    public TraceDataBounds() {
        this.reset();
    }

    public void reset() {
        this.xMin = Double.POSITIVE_INFINITY;
        this.yMin = Double.POSITIVE_INFINITY;
        this.xMax = Double.NEGATIVE_INFINITY;
        this.yMax = Double.NEGATIVE_INFINITY;
    }

    public void addSample(double x, double y) {
        this.xMax = Math.max(this.xMax, x);
        this.yMax = Math.max(this.yMax, y);
        this.xMin = Math.min(this.xMin, x);
        this.yMin = Math.min(this.yMin, y);
    }

    public void union(TraceDataBounds o) {
        this.xMax = Math.max(this.xMax, o.xMax);
        this.yMax = Math.max(this.yMax, o.yMax);
        this.xMin = Math.min(this.xMin, o.xMin);
        this.yMin = Math.min(this.yMin, o.yMin);
    }

    public double getxMin() {
        return this.xMin;
    }

    public void setxMin(double xMin) {
        this.xMin = xMin;
    }

    public double getyMin() {
        return this.yMin;
    }

    public void setyMin(double yMin) {
        this.yMin = yMin;
    }

    public double getxMax() {
        return this.xMax;
    }

    public void setxMax(double xMax) {
        this.xMax = xMax;
    }

    public double getyMax() {
        return this.yMax;
    }

    public void setyMax(double yMax) {
        this.yMax = yMax;
    }
}

