/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.utils.helper.presentation;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.swt.graphics.Image;

public class LabelProviderHelper
extends LabelProvider {
    protected static LabelProviderHelper INSTANCE = null;
    protected LabelProviderService labelProviderService = this.getLabelProviderService();

    private LabelProviderHelper() {
    }

    private LabelProviderService getLabelProviderService() {
        LabelProviderServiceImpl service = new LabelProviderServiceImpl();
        try {
            service.startService();
        }
        catch (ServiceException serviceException) {
            service = null;
        }
        return service;
    }

    public static LabelProviderHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LabelProviderHelper();
        }
        return INSTANCE;
    }

    public Image getImage(Object element) {
        ILabelProvider provider;
        Image image = null;
        if (this.labelProviderService != null && (provider = this.labelProviderService.getLabelProvider(element)) != null) {
            image = provider.getImage(element);
        }
        return image;
    }

    public String getText(Object element) {
        ILabelProvider provider;
        String text = null;
        if (this.labelProviderService != null && (provider = this.labelProviderService.getLabelProvider(element)) != null) {
            text = provider.getText(element);
        }
        return text;
    }
}

