/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.simex.dnd.command;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CreateViewCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.moka.simex.dnd.strategy.DndMessages;
import org.eclipse.papyrus.moka.simex.utils.RequestUtils;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.UMLFactory;

public class CreateAndDropGenericCommand
extends AbstractCommand {
    protected Activity targetActivity;
    protected EClass eClassToCreate;
    protected EReference eRefToSet;
    protected EObject droppedObject;
    protected Point location;
    protected GraphicalEditPart targetEditPart;
    protected String namePrefix = null;
    protected String nameSuffix = null;
    protected IElementType elementTypeToCreate;

    public CreateAndDropGenericCommand(Activity targetActivity, EClass eClassToCreate, EReference eRefToSet, EObject droppedObject, Point location, GraphicalEditPart targetEditPart) {
        super("Create and Drop Object");
        this.initCommonFields(targetActivity, eRefToSet, droppedObject, location, targetEditPart);
        this.eClassToCreate = eClassToCreate;
        this.elementTypeToCreate = null;
    }

    private void initCommonFields(Activity targetActivity, EReference eRefToSet, EObject droppedObject, Point location, GraphicalEditPart targetEditPart) {
        this.targetActivity = targetActivity;
        this.eRefToSet = eRefToSet;
        this.droppedObject = droppedObject;
        this.location = location;
        this.targetEditPart = targetEditPart;
    }

    public CreateAndDropGenericCommand(Activity targetActivity, IElementType elementTypeToCreate, EReference eRefToSet, EObject droppedObject, Point location, GraphicalEditPart targetEditPart) {
        super("Create and Drop Object");
        this.initCommonFields(targetActivity, eRefToSet, droppedObject, location, targetEditPart);
        this.eClassToCreate = null;
        this.elementTypeToCreate = elementTypeToCreate;
    }

    private EClass getEClassToCreate() {
        return this.eClassToCreate != null ? this.eClassToCreate : this.elementTypeToCreate.getEClass();
    }

    public String getLabel() {
        Object[] bindings = new Object[]{this.droppedObject.eClass().getName(), this.getEClassToCreate().getName()};
        return NLS.bind((String)DndMessages.AbstractDropStrategy_Label, (Object[])bindings);
    }

    private void setFeature(EObject receiver, EStructuralFeature receiverFeature, EObject value) {
        Command setFeatureCommand = RequestUtils.getSetFeatureCommand(receiver, value, (EStructuralFeature)this.eRefToSet);
        if (setFeatureCommand != null && setFeatureCommand.canExecute()) {
            setFeatureCommand.execute();
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        ActivityNode createdNode = this.createNode();
        if (this.eRefToSet != null) {
            this.setFeature((EObject)createdNode, (EStructuralFeature)this.eRefToSet, this.droppedObject);
        }
        this.dropNode(createdNode);
        return CommandResult.newOKCommandResult();
    }

    private void dropNode(ActivityNode createdNode) {
        View targetView = NotationHelper.findView((Object)this.targetEditPart);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)createdNode), Node.class, ((IHintedType)UMLElementTypes.getElementType((String)UMLVisualIDRegistry.getNodeVisualID((View)NotationHelper.findView((Object)this.targetEditPart), (EObject)createdNode))).getSemanticHint(), this.targetEditPart.getDiagramPreferencesHint());
        CreateViewCommand createCommand = new CreateViewCommand(this.targetEditPart.getEditingDomain(), descriptor, targetView);
        try {
            createCommand.execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        Point localLocation = this.location.getCopy();
        this.targetEditPart.getContentPane().translateToRelative((Translatable)localLocation);
        SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.targetEditPart.getEditingDomain(), "move", (IAdaptable)createCommand.getCommandResult().getReturnValue(), localLocation);
        try {
            setBoundsCommand.execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    protected ActivityNode createNode() {
        ActivityNode createdNode = null;
        Element container = this.getNodeContainer();
        if (this.eClassToCreate != null) {
            if (container instanceof Activity) {
                createdNode = ((Activity)container).createOwnedNode(null, this.eClassToCreate);
            } else if (container instanceof StructuredActivityNode) {
                createdNode = (ActivityNode)UMLFactory.eINSTANCE.create(this.eClassToCreate);
                ((StructuredActivityNode)container).getNodes().add((Object)createdNode);
            }
        } else {
            createdNode = (ActivityNode)RequestUtils.createElementWithRequest((EObject)container, this.elementTypeToCreate);
        }
        String defaultName = this.getDefaultName(createdNode);
        createdNode.setName(defaultName);
        return createdNode;
    }

    private Element getNodeContainer() {
        EObject semanticElement = this.targetEditPart.resolveSemanticElement();
        if (semanticElement instanceof StructuredActivityNode) {
            return (StructuredActivityNode)semanticElement;
        }
        return this.targetActivity;
    }

    protected String getDefaultName(ActivityNode createdNode) {
        String defaultName;
        if (this.droppedObject instanceof NamedElement && ((NamedElement)this.droppedObject).getName() != null && (this.namePrefix != null || this.nameSuffix != null)) {
            String droppedObjectName = ((NamedElement)this.droppedObject).getName();
            if (this.namePrefix != null) {
                defaultName = this.namePrefix;
                if (!droppedObjectName.isEmpty()) {
                    defaultName = String.valueOf(defaultName) + Character.toUpperCase(droppedObjectName.charAt(0));
                }
                if (droppedObjectName.length() > 1) {
                    defaultName = String.valueOf(defaultName) + droppedObjectName.substring(1);
                }
            } else {
                defaultName = droppedObjectName;
            }
            if (this.nameSuffix != null) {
                defaultName = String.valueOf(defaultName) + this.nameSuffix;
            }
        } else {
            defaultName = NamedElementUtil.getDefaultNameWithIncrement((EObject)createdNode, (Collection)createdNode.eContainer().eContents());
        }
        return defaultName;
    }

    public void setPrefix(String prefix) {
        this.namePrefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.nameSuffix = suffix;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

