/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.statemachines.Semantics.StateMachines;

import java.util.List;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IBooleanValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IEvaluation;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.BasicBehaviors.IExecution;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.statemachines.Activator;
import org.eclipse.papyrus.moka.fuml.statemachines.Semantics.StateMachines.StateMachineSemanticVisitor;
import org.eclipse.papyrus.moka.fuml.statemachines.Semantics.StateMachines.TransitionActivationProfiler;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.ICompletionEventOccurrence;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.IRegionActivation;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.ITransitionActivation;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.IVertexActivation;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.TransitionMetadata;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.Values.ISM_OpaqueExpressionEvaluation;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.ValueSpecification;

public abstract class TransitionActivation
extends StateMachineSemanticVisitor
implements ITransitionActivation {
    protected IVertexActivation vertexSourceActivation;
    protected IVertexActivation vertexTargetActivation;
    protected TransitionMetadata status = TransitionMetadata.NONE;
    private IRegionActivation leastCommonAncestor = null;
    protected TransitionMetadata analyticalStatus = TransitionMetadata.NONE;
    private IEventOccurrence lastTriggeringEventOccurrence = null;
    private boolean lastPropagation = false;

    public TransitionMetadata getStatus() {
        return this.status;
    }

    public void setStatus(TransitionMetadata state) {
        this.status = state;
    }

    public void setAnalyticalStatus(TransitionMetadata status) {
        this.analyticalStatus = status;
    }

    public TransitionMetadata getAnalyticalStatus() {
        return this.analyticalStatus;
    }

    public IVertexActivation getSourceActivation() {
        return this.vertexSourceActivation;
    }

    public void setSourceActivation(IVertexActivation vertexSourceActivation) {
        this.vertexSourceActivation = vertexSourceActivation;
    }

    public IVertexActivation getTargetActivation() {
        return this.vertexTargetActivation;
    }

    public void setTargetActivation(IVertexActivation vertexTargetActivation) {
        this.vertexTargetActivation = vertexTargetActivation;
    }

    public boolean isReached(boolean staticCheck) {
        boolean reached = true;
        reached = staticCheck ? this.analyticalStatus.equals((Object)TransitionMetadata.REACHED) : this.status.equals((Object)TransitionMetadata.REACHED);
        return reached;
    }

    public boolean isTraversed(boolean staticCheck) {
        boolean traversed = true;
        traversed = staticCheck ? this.analyticalStatus.equals((Object)TransitionMetadata.TRAVERSED) : this.status.equals((Object)TransitionMetadata.TRAVERSED);
        return traversed;
    }

    @Override
    public boolean isVisitorFor(NamedElement node) {
        boolean isVisitor = super.isVisitorFor(node);
        if (!isVisitor) {
            Transition transition = ((Transition)this.node).getRedefinedTransition();
            while (!isVisitor && transition != null) {
                if (transition == node) {
                    isVisitor = true;
                    continue;
                }
                transition = transition.getRedefinedTransition();
            }
        }
        return isVisitor;
    }

    public boolean isTriggered() {
        Transition transition = (Transition)this.node;
        boolean isTriggered = false;
        if (!transition.getTriggers().isEmpty()) {
            isTriggered = true;
        }
        while (!isTriggered && transition.getRedefinedTransition() != null) {
            if ((transition = transition.getRedefinedTransition()).getTriggers().isEmpty()) continue;
            isTriggered = true;
        }
        return isTriggered;
    }

    public boolean isGuarded() {
        Transition transition = (Transition)this.node;
        boolean isGuarded = false;
        if (transition.getGuard() != null) {
            isGuarded = true;
        }
        while (!isGuarded && transition.getRedefinedTransition() != null) {
            if ((transition = transition.getRedefinedTransition()).getGuard() == null) continue;
            isGuarded = true;
        }
        return isGuarded;
    }

    public boolean evaluateGuard(IEventOccurrence eventOccurrence) {
        ValueSpecification specification;
        boolean result = true;
        Transition transition = (Transition)this.node;
        Constraint guard = transition.getGuard();
        while (guard == null && transition.getRedefinedTransition() != null) {
            transition = transition.getRedefinedTransition();
            guard = transition.getGuard();
        }
        if (guard != null && (specification = guard.getSpecification()) != null) {
            IEvaluation evaluation = this.getExecutionLocus().getFactory().createEvaluation(specification);
            if (specification instanceof OpaqueExpression) {
                ((ISM_OpaqueExpressionEvaluation)evaluation).setContext(this.getExecutionContext());
                ((ISM_OpaqueExpressionEvaluation)evaluation).initialize(eventOccurrence);
            }
            if (evaluation != null) {
                IBooleanValue evaluationResult = (IBooleanValue)evaluation.evaluate();
                result = evaluationResult.getValue();
            }
        }
        return result;
    }

    public boolean hasTrigger(IEventOccurrence eventOccurrence) {
        Transition transition = (Transition)this.node;
        boolean match = eventOccurrence.matchAny((List)transition.getTriggers());
        while (!match && transition.getRedefinedTransition() != null) {
            transition = transition.getRedefinedTransition();
            match = eventOccurrence.matchAny((List)transition.getTriggers());
        }
        return match;
    }

    public boolean canFireOn(IEventOccurrence eventOccurrence) {
        boolean reactive;
        boolean bl = reactive = this.hasTrigger(eventOccurrence) && this.evaluateGuard(eventOccurrence) && this.canPropagateExecution(eventOccurrence);
        if (reactive && eventOccurrence instanceof ICompletionEventOccurrence) {
            reactive = this.getSourceActivation() == ((ICompletionEventOccurrence)eventOccurrence).getScope();
        }
        return reactive;
    }

    public boolean canPropagateExecution(IEventOccurrence eventOccurrence) {
        boolean propagate = true;
        if (this.lastTriggeringEventOccurrence != eventOccurrence) {
            propagate = this.vertexTargetActivation.canPropagateExecution((ITransitionActivation)this, eventOccurrence, this.getLeastCommonAncestor());
            this.lastTriggeringEventOccurrence = eventOccurrence;
            this.lastPropagation = propagate;
        } else {
            propagate = this.lastPropagation;
        }
        return propagate;
    }

    public void tryExecuteEffect(IEventOccurrence eventOccurrence) {
        IExecution execution;
        Transition transition = (Transition)this.getNode();
        Behavior effect = transition.getEffect();
        while (effect == null && transition.getRedefinedTransition() != null) {
            transition = transition.getRedefinedTransition();
            effect = transition.getEffect();
        }
        if (effect != null && (execution = this.getExecutionFor(transition.getEffect(), eventOccurrence)) != null) {
            execution.execute();
        }
    }

    public void fire(IEventOccurrence eventOccurrence) {
        IEventOccurrence iEventOccurrence = eventOccurrence;
        TransitionActivation transitionActivation = this;
        try {
            transitionActivation.exitSource(iEventOccurrence);
        }
        finally {
            TransitionActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_statemachines_Semantics_StateMachines_TransitionActivationProfiler$1$13dfb677(transitionActivation, iEventOccurrence);
        }
        this.tryExecuteEffect(eventOccurrence);
        this.setStatus(TransitionMetadata.TRAVERSED);
        Activator.logger.info(String.valueOf(this.getNode().getName()) + " => TRAVERSED");
        IEventOccurrence iEventOccurrence2 = eventOccurrence;
        TransitionActivation transitionActivation2 = this;
        TransitionActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_statemachines_Semantics_StateMachines_TransitionActivationProfiler$2$b6c1f0c7(transitionActivation2, iEventOccurrence2);
        transitionActivation2.enterTarget(iEventOccurrence2);
    }

    public IRegionActivation getLeastCommonAncestor() {
        if (this.vertexSourceActivation.getParentVertexActivation() != this.vertexTargetActivation.getParentVertexActivation() && this.leastCommonAncestor == null) {
            this.leastCommonAncestor = this.vertexSourceActivation.getLeastCommonAncestor(this.vertexTargetActivation, ((Transition)this.getNode()).getKind());
        }
        return this.leastCommonAncestor;
    }

    @Override
    public String toString() {
        String representation = "[" + this.getSourceActivation() + "] -> [" + this.getTargetActivation() + "] (";
        representation = this.isReached(false) ? String.valueOf(representation) + "REACHED" : (this.isTraversed(false) ? String.valueOf(representation) + "TRAVERSED" : String.valueOf(representation) + "NONE");
        return String.valueOf(representation) + ")";
    }
}

