/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmu.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import org.eclipse.papyrus.moka.discreteevent.DEScheduler;
import org.eclipse.papyrus.moka.discreteevent.Event;
import org.eclipse.papyrus.moka.fmu.communication.FMUInterface;
import org.eclipse.papyrus.moka.fmu.json.JSONRequest;
import org.eclipse.papyrus.moka.fmu.json.JSONResponse;

public class JSONSocketClient
extends Thread {
    FMUInterface fmu;
    int portNumber;

    public JSONSocketClient(int portNumber) {
        this.portNumber = portNumber;
    }

    public void setFmu(FMUInterface fmu) {
        this.fmu = fmu;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        JsonFactory factory = new JsonFactory();
        JsonParser parser = null;
        JsonGenerator generator = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                Socket socket = new Socket("localhost", this.portNumber);
                try {
                    PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
                    try {
                        block34: {
                            DataOutputStream dataOut = new DataOutputStream(socket.getOutputStream());
                            try {
                                block33: {
                                    DataInputStream inputStream = new DataInputStream(socket.getInputStream());
                                    try {
                                        try (BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));){
                                            parser = factory.createParser((Reader)in);
                                            generator = factory.createGenerator((Writer)out);
                                            while (true) {
                                                if (parser.nextToken() != JsonToken.START_OBJECT) {
                                                    parser.close();
                                                    generator.close();
                                                    break;
                                                }
                                                JSONRequest request = new JSONRequest();
                                                this.parseRequest(parser, request);
                                                JSONResponse response = this.handleRequest(request);
                                                this.sendResponse(generator, response);
                                            }
                                        }
                                        if (inputStream == null) break block33;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        if (inputStream == null) throw throwable;
                                        inputStream.close();
                                        throw throwable;
                                    }
                                    inputStream.close();
                                }
                                if (dataOut == null) break block34;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (dataOut == null) throw throwable;
                                dataOut.close();
                                throw throwable;
                            }
                            dataOut.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        if (out == null) throw throwable;
                        out.close();
                        throw throwable;
                    }
                    if (socket == null) return;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    if (socket == null) throw throwable;
                    socket.close();
                    throw throwable;
                }
                socket.close();
                return;
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                    throw throwable;
                }
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendResponse(JsonGenerator generator, JSONResponse response) {
        try {
            generator.writeStartObject();
            generator.writeStringField("s", response.status);
            if (response.nextDate != null) {
                generator.writeNumberField("nd", response.nextDate.doubleValue());
            }
            if (response.boolVRs != null) {
                generator.writeFieldName("bv");
                this.writeIntArray(generator, response.boolVRs);
            }
            if (response.bools != null) {
                generator.writeFieldName("b");
                this.writeBoolArray(generator, response.bools);
            }
            if (response.intVRs != null) {
                generator.writeFieldName("iv");
                this.writeIntArray(generator, response.intVRs);
            }
            if (response.ints != null) {
                generator.writeFieldName("i");
                this.writeIntArray(generator, response.ints);
            }
            if (response.doubleVRs != null) {
                generator.writeFieldName("dv");
                this.writeIntArray(generator, response.doubleVRs);
            }
            if (response.doubles != null) {
                generator.writeFieldName("d");
                this.writeDoubleArray(generator, response.doubles);
            }
            if (response.stringVRs != null) {
                generator.writeFieldName("sv");
                this.writeIntArray(generator, response.stringVRs);
            }
            if (response.strings != null) {
                generator.writeFieldName("s");
                this.writeStringArray(generator, response.strings);
            }
            generator.writeEndObject();
            generator.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeIntArray(JsonGenerator generator, int[] array) {
        try {
            generator.writeStartArray();
            int[] nArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                int value = nArray[n2];
                generator.writeNumber(value);
                ++n2;
            }
            generator.writeEndArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeBoolArray(JsonGenerator generator, boolean[] array) {
        try {
            generator.writeStartArray();
            boolean[] blArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                boolean value = blArray[n2];
                generator.writeBoolean(value);
                ++n2;
            }
            generator.writeEndArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeDoubleArray(JsonGenerator generator, double[] array) {
        try {
            generator.writeStartArray();
            double[] dArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                double value = dArray[n2];
                generator.writeNumber(value);
                ++n2;
            }
            generator.writeEndArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeStringArray(JsonGenerator generator, String[] array) {
        try {
            generator.writeStartArray();
            String[] stringArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                generator.writeString(value);
                ++n2;
            }
            generator.writeEndArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseRequest(JsonParser parser, JSONRequest request) {
        try {
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = parser.getCurrentName();
                parser.nextToken();
                if (fieldName.equals("ini")) {
                    request.init = true;
                    continue;
                }
                if (fieldName.equals("ter")) {
                    request.terminate = true;
                    continue;
                }
                if (fieldName.equals("t")) {
                    request.t = parser.getValueAsDouble();
                    continue;
                }
                if (fieldName.equals("h")) {
                    request.h = parser.getValueAsDouble();
                    continue;
                }
                if (fieldName.equals("iv")) {
                    this.parseIntArray(parser, request.intVRs);
                    continue;
                }
                if (fieldName.equals("i")) {
                    this.parseIntArray(parser, request.ints);
                    continue;
                }
                if (fieldName.equals("dv")) {
                    this.parseIntArray(parser, request.doubleVRs);
                    continue;
                }
                if (fieldName.equals("d")) {
                    this.parseDoubleArray(parser, request.doubles);
                    continue;
                }
                if (fieldName.equals("bv")) {
                    this.parseIntArray(parser, request.boolVRs);
                    continue;
                }
                if (fieldName.equals("b")) {
                    this.parseBoolArray(parser, request.bools);
                    continue;
                }
                if (fieldName.equals("sv")) {
                    this.parseIntArray(parser, request.stringVRs);
                    continue;
                }
                if (!fieldName.equals("s")) continue;
                this.parseStringArray(parser, request.strings);
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseIntArray(JsonParser parser, List<Integer> table) {
        try {
            while (!parser.nextToken().equals((Object)JsonToken.END_ARRAY)) {
                table.add(parser.getValueAsInt());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseBoolArray(JsonParser parser, List<Boolean> table) {
        try {
            while (!parser.nextToken().equals((Object)JsonToken.END_ARRAY)) {
                table.add(parser.getValueAsBoolean());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseStringArray(JsonParser parser, List<String> table) {
        try {
            while (!parser.nextToken().equals((Object)JsonToken.END_ARRAY)) {
                table.add(parser.getValueAsString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseDoubleArray(JsonParser parser, List<Double> table) {
        try {
            while (!parser.nextToken().equals((Object)JsonToken.END_ARRAY)) {
                table.add(parser.getValueAsDouble());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private JSONResponse handleRequest(JSONRequest request) {
        JSONResponse resp = new JSONResponse();
        if (request.init) {
            this.updateValues(request);
            this.fmu.init();
            this.fmu.updateMaps();
            this.updateResponse(resp);
            resp.status = "ok";
        } else if (request.terminate) {
            System.exit(0);
        } else {
            this.updateValues(request);
            this.fmu.doStep(request.t, request.h);
            this.fmu.updateMaps();
            this.updateResponse(resp);
            resp.status = "ok";
        }
        return resp;
    }

    private void updateResponse(JSONResponse resp) {
        if (!DEScheduler.getInstance().getEvents().isEmpty()) {
            double absoluteDate = ((Event)DEScheduler.getInstance().getEvents().get(0)).getAbsoluteDate();
            resp.nextDate = absoluteDate;
        }
        int index = 0;
        if (!this.fmu.fmiGetBools().isEmpty()) {
            resp.boolVRs = new int[this.fmu.fmiGetBools().size()];
            resp.bools = new boolean[this.fmu.fmiGetBools().size()];
            for (Map.Entry<Integer, Boolean> entry : this.fmu.fmiGetBools().entrySet()) {
                resp.boolVRs[index] = entry.getKey();
                resp.bools[index] = entry.getValue();
                ++index;
            }
            this.fmu.fmiGetBools().clear();
        }
        if (!this.fmu.fmiGetStrings().isEmpty()) {
            resp.stringVRs = new int[this.fmu.fmiGetStrings().size()];
            resp.strings = new String[this.fmu.fmiGetStrings().size()];
            index = 0;
            for (Map.Entry<Integer, Object> entry : this.fmu.fmiGetStrings().entrySet()) {
                String value = (String)entry.getValue();
                if (value.isEmpty()) {
                    value = "null";
                }
                resp.stringVRs[index] = entry.getKey();
                resp.strings[index] = value;
                ++index;
            }
            this.fmu.fmiGetStrings().clear();
        }
        if (!this.fmu.fmiGetReals().isEmpty()) {
            resp.doubleVRs = new int[this.fmu.fmiGetReals().size()];
            resp.doubles = new double[this.fmu.fmiGetReals().size()];
            index = 0;
            for (Map.Entry<Integer, Object> entry : this.fmu.fmiGetReals().entrySet()) {
                resp.doubleVRs[index] = entry.getKey();
                resp.doubles[index] = (Double)entry.getValue();
                ++index;
            }
            this.fmu.fmiGetReals().clear();
        }
        if (!this.fmu.fmiGetIntegers().isEmpty()) {
            resp.intVRs = new int[this.fmu.fmiGetIntegers().size()];
            resp.ints = new int[this.fmu.fmiGetIntegers().size()];
            index = 0;
            for (Map.Entry<Integer, Object> entry : this.fmu.fmiGetIntegers().entrySet()) {
                resp.intVRs[index] = entry.getKey();
                resp.ints[index] = (Integer)entry.getValue();
                ++index;
            }
            this.fmu.fmiGetIntegers().clear();
        }
    }

    private void updateValues(JSONRequest request) {
        int i;
        if (!request.boolVRs.isEmpty()) {
            i = 0;
            while (i < request.boolVRs.size()) {
                this.fmu.fmiGetBools().put(request.boolVRs.get(i), request.bools.get(i));
                ++i;
            }
            this.fmu.fmiSetBools(this.fmu.fmiGetBools());
        }
        if (!request.doubleVRs.isEmpty()) {
            i = 0;
            while (i < request.doubleVRs.size()) {
                this.fmu.fmiGetReals().put(request.doubleVRs.get(i), request.doubles.get(i));
                ++i;
            }
            this.fmu.fmiSetReals(this.fmu.fmiGetReals());
        }
        if (!request.intVRs.isEmpty()) {
            i = 0;
            while (i < request.intVRs.size()) {
                this.fmu.fmiGetIntegers().put(request.intVRs.get(i), request.ints.get(i));
                ++i;
            }
            this.fmu.fmiSetIntegers(this.fmu.fmiGetIntegers());
        }
        if (!request.stringVRs.isEmpty()) {
            i = 0;
            while (i < request.stringVRs.size()) {
                this.fmu.fmiGetStrings().put(request.stringVRs.get(i), request.strings.get(i));
                ++i;
            }
            this.fmu.fmiSetStrings(this.fmu.fmiGetStrings());
        }
    }
}

