/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.master.masterlibrary;

import java.util.ArrayList;
import org.eclipse.papyrus.moka.fmi.master.fmilibrary.Fmi2Port;
import org.eclipse.papyrus.moka.fmi.master.masterlibrary.CoSimEnvironment;
import org.eclipse.papyrus.moka.fmi.master.masterlibrary.Edge;
import org.eclipse.papyrus.moka.fmi.master.masterlibrary.Node;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Port;

public class DependencyGraph {
    private ArrayList<Edge> edges = new ArrayList();
    private ArrayList<Node> nodes = new ArrayList();
    private boolean cyclic = false;

    public DependencyGraph(CoSimEnvironment cosimEnvironnement) {
        ArrayList<Dependency> ioDependencies = cosimEnvironnement.getIoDependencies();
        Node sourceNode = null;
        Node targetNode = null;
        for (Fmi2Port targetPort : cosimEnvironnement.getInputPorts()) {
            Fmi2Port sourcePort = targetPort.getDrivingPort();
            sourceNode = new Node(sourcePort);
            targetNode = new Node(targetPort);
            Edge edge = new Edge(sourceNode, targetNode);
            this.addNode(sourceNode);
            this.addNode(targetNode);
            this.addEdge(edge);
        }
        for (Dependency d : ioDependencies) {
            if (!(d.getClients().get(0) instanceof Port)) continue;
            Port client = (Port)d.getClients().get(0);
            if (!(d.getSuppliers().get(0) instanceof Port)) continue;
            Port supplier = (Port)d.getSuppliers().get(0);
            for (Node n : this.getNodes()) {
                if (n.getVariable().getPort().equals(client)) {
                    targetNode = n;
                }
                if (!n.getVariable().getPort().equals(supplier)) continue;
                sourceNode = n;
            }
            Edge edge = new Edge(sourceNode, targetNode);
            this.addEdge(edge);
        }
    }

    public ArrayList<Fmi2Port> topoSort() {
        boolean moreEdges = true;
        DependencyGraph G = this;
        ArrayList<Fmi2Port> L = new ArrayList<Fmi2Port>();
        ArrayList<Node> S = new ArrayList<Node>();
        for (Node n : G.nodes) {
            if (n.getIncomings().size() != 0) continue;
            S.add(n);
        }
        while (S.size() > 0) {
            Node n;
            moreEdges = true;
            n = (Node)S.get(0);
            S.remove(0);
            L.add(n.getVariable());
            ArrayList<Edge> n2m = n.getOutgoings();
            if (n2m.size() <= 0) continue;
            while (moreEdges) {
                Node m = n2m.get(0).getTarget();
                this.removeEdge(n2m.get(0), G);
                if (m.getIncomings().size() == 0) {
                    S.add(m);
                }
                if (n2m.size() > 0) {
                    n2m.remove(0);
                }
                if (n2m.size() != 0) continue;
                moreEdges = false;
            }
        }
        if (G.edges.size() > 0) {
            this.cyclic = true;
            System.out.println("the graph is cyclic, cannot continue cosimulation");
        }
        return L;
    }

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public void addEdge(Edge edge) {
        this.edges.add(edge);
        edge.getSource().getOutgoings().add(edge);
        edge.getTarget().getIncomings().add(edge);
    }

    public void removeEdge(Edge edge, DependencyGraph g) {
        int index = g.edges.indexOf(edge);
        if (index != -1) {
            int target_index;
            int source_index = edge.getSource().getOutgoings().indexOf(edge);
            if (source_index != -1) {
                edge.getSource().getOutgoings().remove(source_index);
            }
            if ((target_index = edge.getTarget().getIncomings().indexOf(edge)) != -1) {
                edge.getTarget().getIncomings().remove(target_index);
            }
            g.edges.remove(index);
        } else {
            System.out.println("error, edge not found!!");
        }
    }

    public ArrayList<Edge> getEdges() {
        return this.edges;
    }

    public void setEdges(ArrayList<Edge> edges) {
        this.edges = edges;
    }

    public ArrayList<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(ArrayList<Node> nodes) {
        this.nodes = nodes;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public void setCyclic(boolean cyclic) {
        this.cyclic = cyclic;
    }
}

