/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.master.masterlibrary;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.StructuredClasses.CS_Object;
import org.eclipse.papyrus.moka.composites.interfaces.Semantics.CompositeStructures.StructuredClasses.ICS_Object;
import org.eclipse.papyrus.moka.fmi.fmiprofile.FlowDirection;
import org.eclipse.papyrus.moka.fmi.fmiprofile.Port;
import org.eclipse.papyrus.moka.fmi.master.fmilibrary.Fmi2Parameters;
import org.eclipse.papyrus.moka.fmi.master.fmilibrary.Fmi2Port;
import org.eclipse.papyrus.moka.fmi.master.fmilibrary.Fmi2ScalarVariable;
import org.eclipse.papyrus.moka.fmi.master.fmuproxy.Fmu2ProxyService;
import org.eclipse.papyrus.moka.fmi.profile.util.FMIProfileUtil;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IExtensionalValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IFeatureValue;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuredClassifier;

public class CoSimEnvironment {
    private ICS_Object container = new CS_Object();
    private ArrayList<Fmu2ProxyService> fmus = new ArrayList();
    private ArrayList<Connector> connectors = new ArrayList();
    private ArrayList<Dependency> ioDependencies = new ArrayList();
    private List<Fmi2Port> inputPorts = new ArrayList<Fmi2Port>();

    public CoSimEnvironment(List<IExtensionalValue> locus) {
        ArrayList<Fmu2ProxyService> fmusToAdd = new ArrayList<Fmu2ProxyService>();
        block0: for (IExtensionalValue e : locus) {
            for (Classifier type : e.getTypes()) {
                if (type.getAppliedStereotype(FMIProfileUtil.CS_GRAPH_STEREO_QUALIFIED_NAME) != null) {
                    this.container = (CS_Object)e;
                    for (Connector con : ((Class)((CS_Object)e).types.get(0)).getOwnedConnectors()) {
                        this.connectors.add(con);
                    }
                    continue block0;
                }
                if (type.getAppliedStereotype(FMIProfileUtil.CS_FMU_STEREO_QUALIFIED_NAME) == null) continue;
                Fmi2Parameters parameters = new Fmi2Parameters(type, type.getAppliedStereotype(FMIProfileUtil.CS_FMU_STEREO_QUALIFIED_NAME));
                ((Fmu2ProxyService)e).setParameters(parameters);
                fmusToAdd.add((Fmu2ProxyService)e);
                continue block0;
            }
        }
        this.fmus.addAll(fmusToAdd);
        this.setupIoDependencies();
    }

    protected boolean isPartOrReference(IFeatureValue featureValue) {
        return featureValue != null && featureValue.getFeature() != null && featureValue.getFeature() instanceof Property && featureValue.getFeature().getType() instanceof StructuredClassifier;
    }

    public void setupPortMapping() {
        Boolean sourceFound = false;
        Boolean targetFound = false;
        if (this.connectors.size() > 0) {
            for (Connector c : this.connectors) {
                org.eclipse.uml2.uml.Port sourcePort = null;
                org.eclipse.uml2.uml.Port targetPort = null;
                sourcePort = (org.eclipse.uml2.uml.Port)((ConnectorEnd)c.getEnds().get(0)).getRole();
                Stereotype st = sourcePort.getAppliedStereotype(FMIProfileUtil.PORT_STEREO_QUALIFIED_NAME);
                if (st != null) {
                    Port fmiPort = (Port)sourcePort.getStereotypeApplication(st);
                    if (fmiPort.getDirection() == FlowDirection.OUT) {
                        targetPort = (org.eclipse.uml2.uml.Port)((ConnectorEnd)c.getEnds().get(1)).getRole();
                    } else {
                        sourcePort = (org.eclipse.uml2.uml.Port)((ConnectorEnd)c.getEnds().get(1)).getRole();
                        targetPort = (org.eclipse.uml2.uml.Port)((ConnectorEnd)c.getEnds().get(0)).getRole();
                    }
                }
                String sourceFmuName = ((Classifier)sourcePort.getFeaturingClassifiers().get(0)).getName();
                String targetFmuName = ((Classifier)targetPort.getFeaturingClassifiers().get(0)).getName();
                Fmu2ProxyService sourceFmu = null;
                Fmu2ProxyService targetFmu = null;
                for (Fmu2ProxyService f : this.fmus) {
                    if (((Class)f.types.get(0)).getName().equals(sourceFmuName)) {
                        sourceFmu = f;
                        sourceFound = true;
                    }
                    if (((Class)f.types.get(0)).getName().equals(targetFmuName)) {
                        targetFmu = f;
                        targetFound = true;
                    }
                    if (sourceFound.booleanValue() && !targetFound.booleanValue()) continue;
                }
                Fmi2Port target = this.findPort(targetFmu, targetPort);
                Fmi2Port source = this.findPort(sourceFmu, sourcePort);
                target.setDrivingPort(source);
                this.inputPorts.add(target);
            }
        }
    }

    private Fmi2Port findPort(Fmu2ProxyService targetFmu, org.eclipse.uml2.uml.Port targetPort) {
        for (Fmi2ScalarVariable variable : targetFmu.variables) {
            Fmi2Port fmiPort;
            if (!(variable instanceof Fmi2Port) || (fmiPort = (Fmi2Port)variable).getPort() != targetPort) continue;
            return fmiPort;
        }
        return null;
    }

    public void setupIoDependencies() {
        Model nameSpace = (Model)((Classifier)this.container.getTypes().get(0)).getNamespace();
        nameSpace.getPackageImports();
        for (Fmu2ProxyService fmu : this.fmus) {
            Class fmuClass = (Class)fmu.getTypes().get(0);
            for (Property fmuProp : fmuClass.getOwnedAttributes()) {
                for (Dependency dep : fmuProp.getClientDependencies()) {
                    if (dep.getAppliedStereotype(FMIProfileUtil.OUTPUT_DEPENDENCY_STEREO_QUALIFIED_NAME) == null) continue;
                    this.ioDependencies.add(dep);
                }
            }
        }
    }

    public ICS_Object getContainer() {
        return this.container;
    }

    public void setContainer(ICS_Object container) {
        this.container = container;
    }

    public ArrayList<Fmu2ProxyService> getFmus() {
        return this.fmus;
    }

    public void setFmus(ArrayList<Fmu2ProxyService> fmus) {
        this.fmus = fmus;
    }

    public ArrayList<Connector> getConnectors() {
        return this.connectors;
    }

    public void setConnectors(ArrayList<Connector> connectors) {
        this.connectors = connectors;
    }

    public ArrayList<Dependency> getIoDependencies() {
        return this.ioDependencies;
    }

    public void setIoDependencies(ArrayList<Dependency> ioDependencies) {
        this.ioDependencies = ioDependencies;
    }

    public List<Fmi2Port> getInputPorts() {
        return this.inputPorts;
    }
}

