/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.master.fmuproxy;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Memory;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.byref.DoubleByReference;
import jnr.ffi.byref.IntByReference;
import jnr.ffi.byref.PointerByReference;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.StructuredClasses.CS_Object;
import org.eclipse.papyrus.moka.fmi.fmiprofile.ScalarVariable;
import org.eclipse.papyrus.moka.fmi.master.fmilibrary.Fmi2Parameters;
import org.eclipse.papyrus.moka.fmi.master.fmilibrary.Fmi2Port;
import org.eclipse.papyrus.moka.fmi.master.fmilibrary.Fmi2ScalarVariable;
import org.eclipse.papyrus.moka.fmi.master.jnr.JNRFMUInterface;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class Fmu2ProxyService
extends CS_Object {
    public Fmi2Parameters parameters;
    public ArrayList<Fmi2Port> inputPorts = new ArrayList();
    public ArrayList<Fmi2Port> outputPorts = new ArrayList();
    public ArrayList<Fmi2ScalarVariable> variables = new ArrayList();
    public JNRFMUInterface jnrIf;
    private Pointer component = null;
    public Pointer fmuState = null;
    public JNRFMUInterface.Fmi2Status status = JNRFMUInterface.Fmi2Status.fmi2OK;
    private static final int INTEGER_GET_INDEX = 0;
    private static final int INTEGER_SET_INDEX = 1;
    private static final int REAL_GET_INDEX = 2;
    private static final int REAL_SET_INDEX = 3;
    private static final int STRING_GET_INDEX = 4;
    private static final int STRING_SET_INDEX = 5;
    private static final int BOOLEAN_GET_INDEX = 6;
    private static final int BOOLEAN_SET_INDEX = 7;
    private ArrayList<Fmi2ScalarVariable>[] cacheableVariableArray = (ArrayList[])Array.newInstance(ArrayList.class, 8);
    private Pointer[] valueReferenceArrays = new Pointer[8];
    private int[] numberOfValueReferencesArray = new int[8];
    private Pointer getRealValues = null;
    private Pointer setRealValues = null;
    private Pointer getIntValues = null;
    private Pointer setIntValues = null;
    private boolean[] getBoolValues = null;
    private boolean[] setBoolValues = null;
    private String[] getStringValues = null;
    private String[] setStringValues = null;
    protected Map<Property, Fmi2ScalarVariable> property2VarialeMap = new HashMap<Property, Fmi2ScalarVariable>();

    public void setComponent(Pointer component) {
        this.component = component;
    }

    public Pointer getComponent() {
        return this.component;
    }

    public Fmu2ProxyService(Class service) {
        this.addType(service);
        this.initialize();
    }

    public Fmi2ScalarVariable getVariable(Property p) {
        return this.property2VarialeMap.get(p);
    }

    private void initialize() {
        int index = 0;
        while (index < 8) {
            this.cacheableVariableArray[index] = new ArrayList();
            ++index;
        }
        for (Property p : ((Class)this.types.get(0)).getOwnedAttributes()) {
            Fmi2ScalarVariable variable;
            block48: {
                Stereotype st = null;
                for (EObject application : p.getStereotypeApplications()) {
                    if (!(application instanceof ScalarVariable)) continue;
                    st = UMLUtil.getStereotype((EObject)application);
                    break;
                }
                if (st == null) continue;
                if (p instanceof Port) {
                    variable = new Fmi2Port(this, (Port)p, st);
                    if (variable.getCausality().equals("output")) {
                        this.outputPorts.add((Fmi2Port)variable);
                    } else {
                        this.inputPorts.add((Fmi2Port)variable);
                    }
                } else {
                    variable = new Fmi2ScalarVariable(this, p, st);
                    this.property2VarialeMap.put(p, variable);
                }
                this.variables.add(variable);
                if (!variable.getCausality().equals("input")) break block48;
                switch (variable.getType()) {
                    case "Boolean": {
                        this.cacheableVariableArray[7].add(variable);
                        break;
                    }
                    case "Integer": {
                        this.cacheableVariableArray[1].add(variable);
                        break;
                    }
                    case "Real": {
                        this.cacheableVariableArray[3].add(variable);
                        break;
                    }
                    case "String": {
                        this.cacheableVariableArray[5].add(variable);
                    }
                }
                continue;
            }
            if (!variable.getCausality().equals("output")) continue;
            switch (variable.getType()) {
                case "Boolean": {
                    this.cacheableVariableArray[6].add(variable);
                    break;
                }
                case "Integer": {
                    this.cacheableVariableArray[0].add(variable);
                    break;
                }
                case "Real": {
                    this.cacheableVariableArray[2].add(variable);
                    break;
                }
                case "String": {
                    this.cacheableVariableArray[4].add(variable);
                }
            }
        }
        int cachedKind = 0;
        while (cachedKind < 8) {
            this.intializeVRS(cachedKind, this.cacheableVariableArray[cachedKind]);
            ++cachedKind;
        }
        if (!this.cacheableVariableArray[6].isEmpty()) {
            this.getBoolValues = new boolean[this.cacheableVariableArray[6].size()];
        }
        if (!this.cacheableVariableArray[7].isEmpty()) {
            this.setBoolValues = new boolean[this.cacheableVariableArray[7].size()];
        }
        if (!this.cacheableVariableArray[2].isEmpty()) {
            this.getRealValues = Memory.allocateDirect((Runtime)Runtime.getSystemRuntime(), (int)(this.cacheableVariableArray[2].size() * 8));
        }
        if (!this.cacheableVariableArray[3].isEmpty()) {
            this.setRealValues = Memory.allocateDirect((Runtime)Runtime.getSystemRuntime(), (int)(this.cacheableVariableArray[3].size() * 8));
        }
        if (!this.cacheableVariableArray[0].isEmpty()) {
            this.getIntValues = Memory.allocateDirect((Runtime)Runtime.getSystemRuntime(), (int)(this.cacheableVariableArray[0].size() * 4));
        }
        if (!this.cacheableVariableArray[1].isEmpty()) {
            this.setIntValues = Memory.allocateDirect((Runtime)Runtime.getSystemRuntime(), (int)(this.cacheableVariableArray[1].size() * 4));
        }
        if (!this.cacheableVariableArray[4].isEmpty()) {
            this.getStringValues = new String[this.cacheableVariableArray[4].size()];
        }
        if (!this.cacheableVariableArray[5].isEmpty()) {
            this.setStringValues = new String[this.cacheableVariableArray[5].size()];
        }
    }

    private void intializeVRS(int cachedKind, ArrayList<Fmi2ScalarVariable> cacheableVariables) {
        this.valueReferenceArrays[cachedKind] = Memory.allocateDirect((Runtime)Runtime.getSystemRuntime(), (int)(cacheableVariables.size() * 4));
        int i = 0;
        while (i < cacheableVariables.size()) {
            this.valueReferenceArrays[cachedKind].putInt((long)(i * 4), (int)cacheableVariables.get(i).getValueReference());
            ++i;
        }
        this.numberOfValueReferencesArray[cachedKind] = cacheableVariables.size();
    }

    public void fetchGetCache() {
        if (!this.cacheableVariableArray[2].isEmpty()) {
            this.fetchRealCache();
        }
        if (!this.cacheableVariableArray[0].isEmpty()) {
            this.fetchIntegerCache();
        }
        if (!this.cacheableVariableArray[6].isEmpty()) {
            this.fetchBooleanCache();
        }
        if (!this.cacheableVariableArray[4].isEmpty()) {
            this.fetchStringCache();
        }
    }

    private void fetchStringCache() {
        this.jnrIf.fmi2GetString(this.component, this.valueReferenceArrays[4], this.numberOfValueReferencesArray[4], this.getStringValues);
        int i = 0;
        while (i < this.cacheableVariableArray[4].size()) {
            Fmi2ScalarVariable variable = this.cacheableVariableArray[4].get(i);
            variable.setRuntimeValue(this.getStringValues[i]);
            ++i;
        }
    }

    private void fetchBooleanCache() {
        this.jnrIf.fmi2GetBoolean(this.component, this.valueReferenceArrays[6], this.numberOfValueReferencesArray[6], this.getBoolValues);
        int i = 0;
        while (i < this.cacheableVariableArray[6].size()) {
            Fmi2ScalarVariable variable = this.cacheableVariableArray[6].get(i);
            variable.setRuntimeValue(this.getBoolValues[i]);
            ++i;
        }
    }

    private void fetchIntegerCache() {
        this.jnrIf.fmi2GetInteger(this.component, this.valueReferenceArrays[0], this.numberOfValueReferencesArray[0], this.getIntValues);
        int i = 0;
        while (i < this.cacheableVariableArray[0].size()) {
            Fmi2ScalarVariable variable = this.cacheableVariableArray[0].get(i);
            variable.setRuntimeValue(this.getIntValues.getInt((long)(i * 4)));
            ++i;
        }
    }

    private void fetchRealCache() {
        this.jnrIf.fmi2GetReal(this.component, this.valueReferenceArrays[2], this.numberOfValueReferencesArray[2], this.getRealValues);
        int i = 0;
        while (i < this.cacheableVariableArray[2].size()) {
            Fmi2ScalarVariable variable = this.cacheableVariableArray[2].get(i);
            variable.setRuntimeValue(this.getRealValues.getDouble((long)(i * 8)));
            ++i;
        }
    }

    public void flushSetCache() {
        if (!this.cacheableVariableArray[3].isEmpty()) {
            this.flushRealCache();
        }
        if (!this.cacheableVariableArray[1].isEmpty()) {
            this.flushIntegerCache();
        }
        if (!this.cacheableVariableArray[7].isEmpty()) {
            this.flushBooleanCache();
        }
        if (!this.cacheableVariableArray[5].isEmpty()) {
            this.flushStringCache();
        }
    }

    private void flushStringCache() {
        int i = 0;
        while (i < this.cacheableVariableArray[5].size()) {
            Fmi2ScalarVariable variable = this.cacheableVariableArray[5].get(i);
            this.setStringValues[i] = (String)variable.getRuntimeValue();
            ++i;
        }
        this.jnrIf.fmi2SetString(this.component, this.valueReferenceArrays[5], this.numberOfValueReferencesArray[5], this.setStringValues);
    }

    private void flushBooleanCache() {
        int i = 0;
        while (i < this.cacheableVariableArray[7].size()) {
            Fmi2ScalarVariable variable = this.cacheableVariableArray[7].get(i);
            this.setBoolValues[i] = (Boolean)variable.getRuntimeValue();
            ++i;
        }
        this.jnrIf.fmi2SetBoolean(this.component, this.valueReferenceArrays[7], this.numberOfValueReferencesArray[7], this.setBoolValues);
    }

    private void flushIntegerCache() {
        int i = 0;
        while (i < this.cacheableVariableArray[1].size()) {
            Fmi2ScalarVariable variable = this.cacheableVariableArray[1].get(i);
            this.setIntValues.putInt((long)(i * 4), ((Integer)variable.getRuntimeValue()).intValue());
            ++i;
        }
        this.jnrIf.fmi2SetInteger(this.component, this.valueReferenceArrays[1], this.numberOfValueReferencesArray[1], this.setIntValues);
    }

    private void flushRealCache() {
        int i = 0;
        while (i < this.cacheableVariableArray[3].size()) {
            Fmi2ScalarVariable variable = this.cacheableVariableArray[3].get(i);
            this.setRealValues.putDouble((long)(i * 8), ((Double)variable.getRuntimeValue()).doubleValue());
            ++i;
        }
        this.jnrIf.fmi2SetReal(this.component, this.valueReferenceArrays[3], this.numberOfValueReferencesArray[3], this.setRealValues);
    }

    public Fmi2Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(Fmi2Parameters parameters) {
        this.parameters = parameters;
        this.jnrIf = (JNRFMUInterface)LibraryLoader.create(JNRFMUInterface.class).load(parameters.getDllPath());
    }

    public JNRFMUInterface.Fmi2Status fmi2Instantiate(Pointer callbacksPointer, boolean debug) {
        Pointer component = this.jnrIf.fmi2Instantiate(this.parameters.getModelIdentifier(), JNRFMUInterface.Fmi2Type.fmi2CoSimulation, this.parameters.getGuid(), "file:///" + this.parameters.getResourceFolder(), callbacksPointer, false, debug);
        if (component == null) {
            this.status = JNRFMUInterface.Fmi2Status.fmi2Error;
            throw new RuntimeException("Could not instantiate model.");
        }
        this.status = JNRFMUInterface.Fmi2Status.fmi2OK;
        this.setComponent(component);
        return this.status;
    }

    public void fmi2Get(List<Fmi2ScalarVariable> variables) {
        for (Fmi2ScalarVariable variable : variables) {
            this.fmi2Get(variable);
        }
    }

    public void fmi2Get(Fmi2ScalarVariable variable) {
        int[] valueReferences = new int[]{(int)variable.getValueReference()};
        if ("Boolean".equals(variable.getType())) {
            boolean[] values = new boolean[1];
            this.jnrIf.fmi2GetBoolean(this.component, valueReferences, 1, values);
            variable.setRuntimeValue(values[0]);
        } else if ("Integer".equals(variable.getType())) {
            int[] values = new int[1];
            this.jnrIf.fmi2GetInteger(this.component, valueReferences, 1, values);
            variable.setRuntimeValue(values[0]);
        } else if ("Real".equals(variable.getType())) {
            double[] values = new double[1];
            this.jnrIf.fmi2GetReal(this.component, valueReferences, 1, values);
            variable.setRuntimeValue(values[0]);
        } else if ("String".equals(variable.getType())) {
            String[] values = new String[1];
            this.jnrIf.fmi2GetString(this.component, valueReferences, 1, values);
            variable.setRuntimeValue(values[0]);
        }
    }

    public void fmi2Set(List<Fmi2ScalarVariable> variables) {
        for (Fmi2ScalarVariable variable : variables) {
            this.fmi2Set(variable);
        }
    }

    public void fmi2Set(Fmi2ScalarVariable variable) {
        int[] valueReferences = new int[]{(int)variable.getValueReference()};
        if ("Boolean".equals(variable.getType())) {
            this.jnrIf.fmi2SetBoolean(this.component, valueReferences, 1, new boolean[]{this.getBoolean(variable.getRuntimeValue())});
        } else if ("Integer".equals(variable.getType())) {
            this.jnrIf.fmi2SetInteger(this.component, valueReferences, 1, new int[]{this.getInteger(variable.getRuntimeValue())});
        } else if ("Real".equals(variable.getType())) {
            this.jnrIf.fmi2SetReal(this.component, valueReferences, 1, new double[]{this.getDouble(variable.getRuntimeValue())});
        } else if ("String".equals(variable.getType())) {
            this.jnrIf.fmi2SetString(this.component, valueReferences, 1, new String[]{this.getString(variable.getRuntimeValue())});
        }
    }

    private boolean getBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        return false;
    }

    private int getInteger(Object value) {
        if (value instanceof String) {
            return Integer.decode((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return 0;
    }

    private double getDouble(Object value) {
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return 0.0;
    }

    private String getString(Object value) {
        return value.toString();
    }

    public JNRFMUInterface getJnrIf() {
        return this.jnrIf;
    }

    public JNRFMUInterface.Fmi2Status fmi2DoStep(double simulatedTime, double stepSize, boolean noSetPrior) {
        return this.jnrIf.fmi2DoStep(this.component, simulatedTime, stepSize, noSetPrior);
    }

    public void dispose() {
        this.jnrIf = null;
    }

    public void fmi2FreeInstance() {
        this.jnrIf.fmi2FreeInstance(this.component);
    }

    public String fmi2GetTypesPlatform() {
        return this.jnrIf.fmi2GetTypesPlatform();
    }

    public String fmi2GetVersion() {
        return this.jnrIf.fmi2GetVersion();
    }

    public JNRFMUInterface.Fmi2Status fmi2SetDebugLogging(boolean loggingOn, int numberOfCategories, String[] categories) {
        return this.jnrIf.fmi2SetDebugLogging(this.component, loggingOn, numberOfCategories, categories);
    }

    public JNRFMUInterface.Fmi2Status fmi2SetupExperiment(boolean toleranceDefined, double tolerance, double startTime, boolean stopTimeDefined, double stopTime) {
        return this.jnrIf.fmi2SetupExperiment(this.component, toleranceDefined, tolerance, startTime, stopTimeDefined, stopTime);
    }

    public int fmi2EnterInitializationMode() {
        return this.jnrIf.fmi2EnterInitializationMode(this.component);
    }

    public JNRFMUInterface.Fmi2Status fmi2ExitInitializationMode() {
        return this.jnrIf.fmi2ExitInitializationMode(this.component);
    }

    public JNRFMUInterface.Fmi2Status fmi2Terminate() {
        return this.jnrIf.fmi2Terminate(this.component);
    }

    public JNRFMUInterface.Fmi2Status fmi2Reset() {
        return this.jnrIf.fmi2Reset(this.component);
    }

    public JNRFMUInterface.Fmi2Status fmi2GetFMUstate(PointerByReference state) {
        return this.jnrIf.fmi2GetFMUstate(this.component, state);
    }

    public JNRFMUInterface.Fmi2Status fmi2SetFMUstate(Pointer state) {
        return this.jnrIf.fmi2SetFMUstate(this.component, state);
    }

    public JNRFMUInterface.Fmi2Status fmi2FreeFMUstate(PointerByReference state) {
        return this.jnrIf.fmi2FreeFMUstate(this.component, state);
    }

    public JNRFMUInterface.Fmi2Status fmi2SerializedFMUstateSize(Pointer state, IntByReference stateSize) {
        return this.jnrIf.fmi2SerializedFMUstateSize(this.component, state, stateSize);
    }

    public JNRFMUInterface.Fmi2Status fmi2SerializeFMUstate(Pointer state, ByteBuffer serializedState, int serializedStateSize) {
        return this.jnrIf.fmi2SerializeFMUstate(this.component, state, serializedState, serializedStateSize);
    }

    public JNRFMUInterface.Fmi2Status fmi2DeSerializeFMUstate(ByteBuffer serializedState, int size, PointerByReference state) {
        return this.jnrIf.fmi2DeSerializeFMUstate(this.component, serializedState, size, state);
    }

    public JNRFMUInterface.Fmi2Status fmi2GetDirectionalDerivative(int[] unknownValueReferences, int numberOfUnknowns, int[] knownValueReferences, int numberOfKnowns, double[] knownDifferential, double[] unknownDifferential) {
        return this.jnrIf.fmi2GetDirectionalDerivative(this.component, unknownValueReferences, numberOfUnknowns, knownValueReferences, numberOfKnowns, knownDifferential, unknownDifferential);
    }

    public JNRFMUInterface.Fmi2Status fmi2SetRealInputDerivatives(int[] valueReferences, int numberOfValueReferences, int[] orders, double[] values) {
        return this.jnrIf.fmi2SetRealInputDerivatives(this.component, valueReferences, numberOfValueReferences, orders, values);
    }

    public JNRFMUInterface.Fmi2Status fmi2GetRealOutputDerivatives(int[] valueReference, int numberOfValueReferences, int[] order, double[] values) {
        return this.jnrIf.fmi2GetRealOutputDerivatives(this.component, valueReference, numberOfValueReferences, order, values);
    }

    public JNRFMUInterface.Fmi2Status fmi2CancelStep() {
        return this.jnrIf.fmi2CancelStep(this.component);
    }

    public JNRFMUInterface.Fmi2Status fmi2GetStatus(JNRFMUInterface.Fmi2StatusKind kind, PointerByReference status) {
        return this.jnrIf.fmi2GetStatus(this.component, kind, status);
    }

    public JNRFMUInterface.Fmi2Status fmi2GetRealStatus(JNRFMUInterface.Fmi2StatusKind kind, DoubleByReference value) {
        return this.jnrIf.fmi2GetRealStatus(this.component, kind, value);
    }

    public JNRFMUInterface.Fmi2Status fmi2GetIntegerStatus(JNRFMUInterface.Fmi2StatusKind kind, IntByReference value) {
        return this.jnrIf.fmi2GetIntegerStatus(this.component, kind, value);
    }

    public JNRFMUInterface.Fmi2Status fmi2GetBooleanStatus(JNRFMUInterface.Fmi2StatusKind kind, IntByReference value) {
        return this.jnrIf.fmi2GetBooleanStatus(this.component, kind, value);
    }

    public JNRFMUInterface.Fmi2Status fmi2GetStringStatus(JNRFMUInterface.Fmi2StatusKind kind, String value) {
        return this.jnrIf.fmi2GetStringStatus(this.component, kind, value);
    }
}

