/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.engine;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.papyrus.moka.debug.engine.DebugServiceHelper;
import org.eclipse.papyrus.moka.debug.engine.IMokaDebugTarget;
import org.eclipse.papyrus.moka.debug.engine.IMokaThread;
import org.eclipse.papyrus.moka.debug.engine.MokaDebugElement;
import org.eclipse.papyrus.moka.debug.engine.MokaDebugTargetState;
import org.eclipse.papyrus.moka.debug.engine.MokaProcess;
import org.eclipse.papyrus.moka.debug.engine.MokaThread;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;

public class MokaDebugTarget
extends MokaDebugElement
implements IMokaDebugTarget {
    protected ILaunch launcher;
    protected MokaProcess executionEngineProcess;
    protected Set<IMokaThread> executionThreads;
    protected ReentrantLock targetLock;
    protected MokaDebugTargetState status;

    public MokaDebugTarget(ILaunch launcher) {
        super(null);
        this.launcher = launcher;
        this.executionEngineProcess = null;
        this.executionThreads = new HashSet<IMokaThread>();
        this.targetLock = new ReentrantLock(true);
        this.status = MokaDebugTargetState.RUNNING;
        this.fireCreationEvent();
    }

    public void setProcess(MokaProcess process) {
        this.executionEngineProcess = process;
    }

    public ILaunch getLaunch() {
        return this.launcher;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.status.equals((Object)MokaDebugTargetState.TERMINATED);
    }

    public void terminate() throws DebugException {
        for (IMokaThread thread : this.executionThreads) {
            if (thread.isSuspended()) {
                thread.resume();
            }
            thread.terminate();
        }
        this.executionThreads.clear();
        this.executionEngineProcess.terminate();
        this.status = MokaDebugTargetState.TERMINATED;
        this.fireTerminateEvent();
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return this.status.equals((Object)MokaDebugTargetState.RUNNING);
    }

    public boolean isSuspended() {
        return this.status.equals((Object)MokaDebugTargetState.SUSPENDED);
    }

    public void resume() throws DebugException {
        this.targetLock.lock();
        try {
            for (IMokaThread logicalThread : this.executionThreads) {
                if (!logicalThread.isSuspended()) continue;
                logicalThread.resume();
            }
            this.status = MokaDebugTargetState.RUNNING;
            this.fireResumeEvent(1);
        }
        finally {
            this.targetLock.unlock();
        }
    }

    public void suspend() throws DebugException {
        this.targetLock.lock();
        try {
            for (IMokaThread logicalThread : this.executionThreads) {
                if (logicalThread.isSuspended()) continue;
                logicalThread.suspend();
            }
            this.status = MokaDebugTargetState.SUSPENDED;
            this.fireChangeEvent(2);
        }
        finally {
            this.targetLock.unlock();
        }
    }

    @Override
    public void registerThread(IObject_ object) {
        this.executionThreads.add(new MokaThread(this, object));
    }

    @Override
    public boolean isNewThread(IObject_ object) {
        IMokaThread existingThread = null;
        Iterator<IMokaThread> threadIterator = this.executionThreads.iterator();
        while (existingThread == null && threadIterator.hasNext()) {
            existingThread = threadIterator.next();
            if (existingThread.getLogicalThread() == object) continue;
            existingThread = null;
        }
        return existingThread == null;
    }

    @Override
    public void unregisterThread(IObject_ object) {
        IMokaThread targetThread = null;
        Iterator<IMokaThread> threadIterator = this.executionThreads.iterator();
        while (targetThread == null && threadIterator.hasNext()) {
            targetThread = threadIterator.next();
            if (targetThread.getLogicalThread() != object) continue;
            threadIterator.remove();
        }
    }

    protected IMokaThread getLogicalThread(IObject_ object) {
        IMokaThread targetThread = null;
        Iterator<IMokaThread> threadIterator = this.executionThreads.iterator();
        while (targetThread == null && threadIterator.hasNext()) {
            IMokaThread currentThread = threadIterator.next();
            if (currentThread.getLogicalThread() != object) continue;
            targetThread = currentThread;
        }
        return targetThread;
    }

    @Override
    public boolean isSuspensionRequired(IObject_ object, ISemanticVisitor nodeVisitor) {
        IMokaThread thread = this.getLogicalThread(object);
        if (thread != null) {
            if (thread.getSuspensionFlag()) {
                return true;
            }
            if (DebugServiceHelper.INSTANCE.hasBreakpoint(nodeVisitor)) {
                try {
                    thread.suspend();
                }
                catch (DebugException e) {
                    e.printStackTrace();
                }
                return true;
            }
            if (thread.isStepping()) {
                try {
                    thread.suspend();
                }
                catch (DebugException e) {
                    e.printStackTrace();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void suspend(IObject_ object, ISemanticVisitor nodeVisitor) {
        IMokaThread logicalThread = this.getLogicalThread(object);
        if (logicalThread != null) {
            logicalThread.suspend(nodeVisitor);
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return !this.isDisconnected() && !this.isTerminated();
    }

    public void disconnect() throws DebugException {
        this.targetLock.lock();
        try {
            for (IMokaThread thread : this.executionThreads) {
                if (!thread.isSuspended()) continue;
                thread.resume();
            }
            this.executionThreads.clear();
            this.status = MokaDebugTargetState.DISCONNECTED;
            this.fireTerminateEvent();
        }
        finally {
            this.targetLock.unlock();
        }
    }

    public boolean isDisconnected() {
        return this.status.equals((Object)MokaDebugTargetState.DISCONNECTED) || this.isTerminated();
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public IProcess getProcess() {
        return this.executionEngineProcess;
    }

    public IThread[] getThreads() throws DebugException {
        return this.executionThreads.toArray(new IThread[0]);
    }

    public boolean hasThreads() throws DebugException {
        return !this.executionThreads.isEmpty();
    }

    public String getName() throws DebugException {
        return "Moka Execution";
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return true;
    }

    @Override
    public void update(IObject_ object, ISemanticVisitor visitor) {
        IMokaThread thread = this.getLogicalThread(object);
        if (thread != null) {
            thread.setSuspensionPoint(visitor);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasSuspendedThread() {
        boolean hasSuspendedThread = false;
        this.targetLock.lock();
        try {
            block6: {
                Iterator<IMokaThread> threadIterator;
                block5: {
                    threadIterator = this.executionThreads.iterator();
                    if (!true) break block5;
                    if (hasSuspendedThread) return hasSuspendedThread;
                    if (!threadIterator.hasNext()) break block6;
                }
                do {
                    hasSuspendedThread = threadIterator.next().isSuspended();
                    if (hasSuspendedThread) return hasSuspendedThread;
                } while (threadIterator.hasNext());
            }
            return hasSuspendedThread;
        }
        finally {
            this.targetLock.unlock();
        }
    }
}

