/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.composites.utils.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.moka.composites.utils.handlers.Utils;
import org.eclipse.papyrus.moka.utils.helper.presentation.LabelProviderHelper;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;

public class GenerateConstructorUsingFieldsDialog
extends TrayDialog {
    protected Class context;
    protected CheckboxTableViewer viewer;
    private Button btUP;
    private Button btDown;
    private List<Object> checkList = new ArrayList<Object>();

    public GenerateConstructorUsingFieldsDialog(Shell shell, Class context) {
        super(shell);
        this.setShellStyle(80);
        this.context = context;
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText("Generate Constructor Using Fields");
        parent.getShell().setMinimumSize(500, 500);
        Composite mainLayout = new Composite(parent, 4);
        mainLayout.setLayoutData((Object)new GridData(4, 4, true, true));
        mainLayout.setLayout((Layout)new GridLayout(1, true));
        Label lblSelectFields = new Label(mainLayout, 0);
        lblSelectFields.setText("Select fields to initialize :");
        Composite cpCenter = new Composite(mainLayout, 16);
        GridData gdCenter = new GridData(4, 4, true, true);
        gdCenter.widthHint = 514;
        gdCenter.heightHint = 274;
        cpCenter.setLayoutData((Object)gdCenter);
        cpCenter.setLayout((Layout)new GridLayout(2, false));
        Composite cpCheckBox = new Composite(cpCenter, 2064);
        cpCheckBox.setLayout((Layout)new GridLayout(1, false));
        GridData gdCheckBox = new GridData(4, 4, true, true);
        gdCheckBox.widthHint = 370;
        cpCheckBox.setLayoutData((Object)gdCheckBox);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)cpCheckBox, (int)65540);
        this.viewer.setContentProvider((IContentProvider)new StruturedContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.setInput((Object)this.context.getOwnedAttributes());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    GenerateConstructorUsingFieldsDialog.this.viewer.setChecked(event.getElement(), true);
                    GenerateConstructorUsingFieldsDialog.this.checkList.add(event.getElement());
                } else {
                    GenerateConstructorUsingFieldsDialog.this.viewer.setChecked(event.getElement(), false);
                    GenerateConstructorUsingFieldsDialog.this.checkList.remove(event.getElement());
                }
            }
        });
        this.viewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                List elements = (List)GenerateConstructorUsingFieldsDialog.this.viewer.getInput();
                Property data = null;
                if (event.item.getData() instanceof Property) {
                    data = (Property)event.item.getData();
                    if (data == elements.get(0)) {
                        GenerateConstructorUsingFieldsDialog.this.btUP.setEnabled(false);
                        GenerateConstructorUsingFieldsDialog.this.btDown.setEnabled(true);
                    } else if (data == elements.get(elements.size() - 1)) {
                        GenerateConstructorUsingFieldsDialog.this.btDown.setEnabled(false);
                        GenerateConstructorUsingFieldsDialog.this.btUP.setEnabled(true);
                    } else {
                        GenerateConstructorUsingFieldsDialog.this.btUP.setEnabled(true);
                        GenerateConstructorUsingFieldsDialog.this.btDown.setEnabled(true);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.setAllChecked(true);
        Object[] tmp = this.viewer.getCheckedElements();
        int i = 0;
        while (i < tmp.length) {
            this.checkList.add(tmp[i]);
            ++i;
        }
        Composite cpButtons = new Composite(cpCenter, 16);
        GridData gdButtons = new GridData(4, 4, true, true);
        gdButtons.widthHint = 144;
        cpButtons.setLayoutData((Object)gdButtons);
        cpButtons.setLayout((Layout)new GridLayout(1, false));
        Button btSelect = new Button(cpButtons, 8);
        btSelect.setText("Select All");
        GridData gdSelect = new GridData(4, 4, false, false);
        gdSelect.widthHint = 100;
        gdSelect.heightHint = 25;
        btSelect.setLayoutData((Object)gdSelect);
        btSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GenerateConstructorUsingFieldsDialog.this.viewer.setAllChecked(true);
                if (GenerateConstructorUsingFieldsDialog.this.checkList.size() != 0) {
                    GenerateConstructorUsingFieldsDialog.this.checkList.removeAll(GenerateConstructorUsingFieldsDialog.this.checkList);
                    Object[] tmp = GenerateConstructorUsingFieldsDialog.this.viewer.getCheckedElements();
                    int i = 0;
                    while (i < tmp.length) {
                        GenerateConstructorUsingFieldsDialog.this.checkList.add(tmp[i]);
                        ++i;
                    }
                }
            }
        });
        Button btDeSelect = new Button(cpButtons, 8);
        btDeSelect.setText("Deselect All");
        GridData gdDeSelect = new GridData(4, 4, false, false);
        gdDeSelect.widthHint = 100;
        gdDeSelect.heightHint = 25;
        btDeSelect.setLayoutData((Object)gdDeSelect);
        btDeSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GenerateConstructorUsingFieldsDialog.this.viewer.setAllChecked(false);
                if (GenerateConstructorUsingFieldsDialog.this.checkList.size() != 0) {
                    GenerateConstructorUsingFieldsDialog.this.checkList.removeAll(GenerateConstructorUsingFieldsDialog.this.checkList);
                }
            }
        });
        this.btUP = new Button(cpButtons, 8);
        this.btUP.setText("Up");
        GridData gdUP = new GridData(4, 4, false, false);
        gdUP.widthHint = 100;
        gdUP.heightHint = 25;
        this.btUP.setLayoutData((Object)gdUP);
        this.btUP.setEnabled(false);
        this.btUP.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GenerateConstructorUsingFieldsDialog.this.viewer.setInput(GenerateConstructorUsingFieldsDialog.this.getElementListUP());
            }
        });
        this.btDown = new Button(cpButtons, 8);
        this.btDown.setText("Down");
        GridData gdDown = new GridData(4, 4, false, false);
        gdDown.widthHint = 100;
        gdDown.heightHint = 25;
        this.btDown.setLayoutData((Object)gdDown);
        this.btDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GenerateConstructorUsingFieldsDialog.this.viewer.setInput(GenerateConstructorUsingFieldsDialog.this.getElementListDown());
            }
        });
        return mainLayout;
    }

    protected boolean isCreate(Operation operation) {
        int j = 0;
        while (j < operation.getAppliedStereotypes().size()) {
            Stereotype st_tmp = (Stereotype)operation.getAppliedStereotypes().get(j);
            if (st_tmp.getName().equals("Create")) {
                return true;
            }
            ++j;
        }
        return false;
    }

    protected List<?> getElementListUP() {
        List elements = (List)this.viewer.getInput();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        List element = selection.toList();
        ArrayList elementList = new ArrayList();
        ArrayList elementListTMP = new ArrayList();
        int i = 0;
        while (i < elements.size()) {
            if (element.get(0) == elements.get(i)) {
                elementListTMP.remove(elements.get(i - 1));
                elementListTMP.add(element.get(0));
                elementListTMP.add(elements.get(i - 1));
            } else {
                elementListTMP.add(elements.get(i));
            }
            ++i;
        }
        elementList.addAll(elementListTMP);
        return elementList;
    }

    protected List<?> getElementListDown() {
        List elements = (List)this.viewer.getInput();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        List element = selection.toList();
        ArrayList elementList = new ArrayList();
        ArrayList elementListTMP = new ArrayList();
        int i = 0;
        while (i < elements.size()) {
            if (element.get(0) == elements.get(i)) {
                elementListTMP.add(elements.get(i + 1));
                elementListTMP.add(element.get(0));
                ++i;
            } else {
                elementListTMP.add(elements.get(i));
            }
            ++i;
        }
        elementList.addAll(elementListTMP);
        return elementList;
    }

    protected void okPressed() {
        if (!Utils.isStandardProfileApplied((Element)this.context)) {
            PackageUtil.applyProfile((Package)this.context.getModel(), (Profile)Utils.standardProfile, (boolean)true);
        }
        Operation operation = Utils.getDefaultConstructor(this.context);
        int flagParamOp = 0;
        int i = 0;
        while (i < this.checkList.size()) {
            if (this.checkList.get(i) instanceof Property) {
                Property prop = (Property)this.checkList.get(i);
                Parameter in = UMLFactory.eINSTANCE.createParameter();
                in.setDirection(ParameterDirectionKind.IN_LITERAL);
                in.setType(prop.getType());
                in.setName(prop.getName());
                flagParamOp = 0;
                if (operation.getOwnedParameters().size() <= 1) {
                    operation.getOwnedParameters().add(operation.getOwnedParameters().size() - 1, (Object)in);
                } else {
                    int j = 0;
                    while (j < operation.getOwnedParameters().size() && flagParamOp == 0) {
                        Parameter opParameter = (Parameter)operation.getOwnedParameters().get(j);
                        flagParamOp = !opParameter.getName().equals(in.getName()) ? 0 : -1;
                        ++j;
                    }
                    if (flagParamOp == 0) {
                        operation.getOwnedParameters().add(operation.getOwnedParameters().size() - 1, (Object)in);
                    }
                }
            }
            ++i;
        }
        super.okPressed();
    }

    static class StruturedContentProvider
    implements IStructuredContentProvider {
        StruturedContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList result = new ArrayList();
            if (inputElement instanceof List) {
                result.addAll((Collection)inputElement);
            }
            return result.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class TableLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof Property) {
                Property current = (Property)element;
                switch (columnIndex) {
                    case 0: {
                        return LabelProviderHelper.getInstance().getImage((Object)current);
                    }
                }
                return null;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Property) {
                Property current = (Property)element;
                switch (columnIndex) {
                    case 0: {
                        return current.getName();
                    }
                }
                return "";
            }
            return "";
        }
    }
}

