/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.StructuredClasses;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CommonBehaviors.Communications.CS_DispatchOperationOfInterfaceStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CommonBehaviors.Communications.CS_StructuralFeatureOfInterfaceAccessStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.InvocationActions.CS_RequestPropagationStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.InvocationActions.CS_SignalInstance;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.StructuredClasses.CS_InteractionPoint;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.StructuredClasses.CS_Link;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.StructuredClasses.CS_Reference;
import org.eclipse.papyrus.moka.composites.interfaces.Semantics.CompositeStructures.StructuredClasses.CS_LinkKind;
import org.eclipse.papyrus.moka.composites.interfaces.Semantics.CompositeStructures.StructuredClasses.ICS_InteractionPoint;
import org.eclipse.papyrus.moka.composites.interfaces.Semantics.CompositeStructures.StructuredClasses.ICS_Link;
import org.eclipse.papyrus.moka.composites.interfaces.Semantics.CompositeStructures.StructuredClasses.ICS_Object;
import org.eclipse.papyrus.moka.composites.interfaces.Semantics.CompositeStructures.StructuredClasses.ICS_Reference;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IExtensionalValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IFeatureValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IReference;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.BasicBehaviors.IExecution;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.ISignalInstance;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Actions.BasicActions.CallOperationActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Actions.BasicActions.SendSignalActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.Object_;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.Reference;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Loci.LociL1.ChoiceStrategy;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectorKind;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StructuralFeature;

public class CS_Object
extends Object_
implements ICS_Object {
    public IExecution dispatchIn(Operation operation, ICS_InteractionPoint interactionPoint) {
        IExecution execution = null;
        if (!interactionPoint.getDefiningPort().isBehavior()) {
            boolean operationIsProvided = true;
            ArrayList<IReference> potentialTargets = new ArrayList<IReference>();
            List<ICS_Link> cddLinks = this.getLinks(interactionPoint);
            Integer linkIndex = 1;
            while (linkIndex <= cddLinks.size()) {
                List<IReference> validTargets = this.selectTargetsForDispatching(cddLinks.get(linkIndex - 1), interactionPoint, ConnectorKind.DELEGATION_LITERAL, operation, operationIsProvided);
                Integer targetIndex = 1;
                while (targetIndex <= validTargets.size()) {
                    potentialTargets.add(validTargets.get(targetIndex - 1));
                    targetIndex = targetIndex + 1;
                }
                linkIndex = linkIndex + 1;
            }
            if (potentialTargets.size() != 0) {
                CS_RequestPropagationStrategy strategy = (CS_RequestPropagationStrategy)this.locus.getFactory().getStrategy("requestPropagation");
                List<IReference> targets = strategy.select(potentialTargets, (ISemanticVisitor)new CallOperationActionActivation());
                IReference target = targets.get(0);
                execution = target.dispatch(operation);
            }
        }
        return execution;
    }

    public void sendIn(ISignalInstance signalInstance, ICS_InteractionPoint interactionPoint) {
        if (interactionPoint.getDefiningPort().isBehavior()) {
            CS_SignalInstance newSignalInstance = (CS_SignalInstance)signalInstance.copy();
            newSignalInstance.interactionPoint = interactionPoint;
            this.send((ISignalInstance)newSignalInstance);
        } else {
            boolean toInternal = true;
            ArrayList<IReference> potentialTargets = new ArrayList<IReference>();
            List<ICS_Link> cddLinks = this.getLinks(interactionPoint);
            Integer linkIndex = 1;
            while (linkIndex <= cddLinks.size()) {
                List<IReference> validTargets = this.selectTargetsForSending(cddLinks.get(linkIndex - 1), interactionPoint, ConnectorKind.DELEGATION_LITERAL, signalInstance.getType(), toInternal);
                Integer targetIndex = 1;
                while (targetIndex <= validTargets.size()) {
                    potentialTargets.add(validTargets.get(targetIndex - 1));
                    targetIndex = targetIndex + 1;
                }
                linkIndex = linkIndex + 1;
            }
            int i = 0;
            while (i < potentialTargets.size()) {
                IReference target = (IReference)potentialTargets.get(i);
                CS_SignalInstance newSignalInstance = (CS_SignalInstance)signalInstance.copy();
                newSignalInstance.interactionPoint = interactionPoint;
                target.send((ISignalInstance)newSignalInstance);
                ++i;
            }
        }
    }

    public List<IReference> selectTargetsForSending(ICS_Link link, ICS_InteractionPoint interactionPoint, ConnectorKind connectorKind, Signal signal, Boolean toInternal) {
        ArrayList<IReference> potentialTargets;
        block21: {
            block20: {
                potentialTargets = new ArrayList<IReference>();
                if (!toInternal.booleanValue() || connectorKind != ConnectorKind.DELEGATION_LITERAL) break block20;
                if (this.getLinkKind(link, interactionPoint) != CS_LinkKind.ToInternal) break block21;
                Integer i = 1;
                while (i <= link.getFeatureValues().size()) {
                    List values = ((IFeatureValue)link.getFeatureValues().get(i - 1)).getValues();
                    if (!values.isEmpty()) {
                        Integer j = 1;
                        while (j <= values.size()) {
                            Reference cddTarget = (Reference)values.get(j - 1);
                            if (!cddTarget.equals((IValue)interactionPoint).booleanValue()) {
                                potentialTargets.add((IReference)cddTarget);
                            }
                            j = j + 1;
                        }
                    }
                    i = i + 1;
                }
                break block21;
            }
            if (this.getLinkKind(link, interactionPoint) == CS_LinkKind.ToEnvironment) {
                Integer i = 1;
                while (i <= link.getFeatureValues().size()) {
                    List values = ((IFeatureValue)link.getFeatureValues().get(i - 1)).getValues();
                    if (!values.isEmpty() && values.get(0) instanceof Reference) {
                        ICS_Object container;
                        Integer j;
                        List<ICS_Object> directContainers;
                        Reference cddTarget = (Reference)values.get(0);
                        if (connectorKind == ConnectorKind.ASSEMBLY_LITERAL) {
                            if (!(cddTarget instanceof CS_InteractionPoint)) {
                                potentialTargets.add((IReference)cddTarget);
                            } else {
                                directContainers = this.getDirectContainers();
                                boolean isAssembly = true;
                                j = 1;
                                if (!this.hasValueForAFeature((IValue)cddTarget).booleanValue()) {
                                    while (isAssembly && j <= directContainers.size()) {
                                        container = directContainers.get(j - 1);
                                        if (container.hasValueForAFeature((IValue)cddTarget).booleanValue()) {
                                            isAssembly = false;
                                        }
                                        j = j + 1;
                                    }
                                } else {
                                    isAssembly = false;
                                }
                                if (isAssembly) {
                                    potentialTargets.add((IReference)cddTarget);
                                }
                            }
                        } else if (cddTarget instanceof CS_InteractionPoint) {
                            directContainers = this.getDirectContainers();
                            boolean isDelegation = false;
                            j = 1;
                            while (!isDelegation && j <= directContainers.size()) {
                                container = directContainers.get(j - 1);
                                if (container.hasValueForAFeature((IValue)cddTarget).booleanValue()) {
                                    isDelegation = true;
                                }
                                j = j + 1;
                            }
                            if (isDelegation) {
                                potentialTargets.add((IReference)cddTarget);
                            }
                        }
                    }
                    i = i + 1;
                }
            }
        }
        return potentialTargets;
    }

    public List<IReference> selectTargetsForDispatching(ICS_Link link, ICS_InteractionPoint interactionPoint, ConnectorKind connectorKind, Operation operation, Boolean toInternal) {
        ArrayList<IReference> potentialTargets;
        block20: {
            block19: {
                potentialTargets = new ArrayList<IReference>();
                if (!toInternal.booleanValue() || connectorKind != ConnectorKind.DELEGATION_LITERAL) break block19;
                if (this.getLinkKind(link, interactionPoint) != CS_LinkKind.ToInternal) break block20;
                Integer i = 1;
                while (i <= link.getFeatureValues().size()) {
                    Reference cddTarget;
                    List values = ((IFeatureValue)link.getFeatureValues().get(i - 1)).getValues();
                    if (!values.isEmpty() && values.get(0) instanceof Reference && (cddTarget = (Reference)values.get(0)) != interactionPoint && this.isOperationProvided((IReference)cddTarget, operation).booleanValue()) {
                        potentialTargets.add((IReference)cddTarget);
                    }
                    i = i + 1;
                }
                break block20;
            }
            if (this.getLinkKind(link, interactionPoint) == CS_LinkKind.ToEnvironment) {
                Integer i = 1;
                while (i <= link.getFeatureValues().size()) {
                    List values = ((IFeatureValue)link.getFeatureValues().get(i - 1)).getValues();
                    if (!values.isEmpty() && values.get(0) instanceof Reference) {
                        ICS_Object container;
                        Integer j;
                        List<ICS_Object> directContainers;
                        Reference cddTarget = (Reference)values.get(0);
                        if (connectorKind == ConnectorKind.ASSEMBLY_LITERAL) {
                            if (!(cddTarget instanceof CS_InteractionPoint)) {
                                if (this.isOperationProvided((IReference)cddTarget, operation).booleanValue()) {
                                    potentialTargets.add((IReference)cddTarget);
                                }
                            } else {
                                directContainers = this.getDirectContainers();
                                boolean isAssembly = true;
                                j = 1;
                                if (!this.hasValueForAFeature((IValue)cddTarget).booleanValue()) {
                                    while (isAssembly && j <= directContainers.size()) {
                                        container = directContainers.get(j - 1);
                                        if (container.hasValueForAFeature((IValue)cddTarget).booleanValue()) {
                                            isAssembly = false;
                                        }
                                        j = j + 1;
                                    }
                                } else {
                                    isAssembly = false;
                                }
                                if (isAssembly && this.isOperationProvided((IReference)cddTarget, operation).booleanValue()) {
                                    potentialTargets.add((IReference)cddTarget);
                                }
                            }
                        } else if (cddTarget instanceof CS_InteractionPoint) {
                            directContainers = this.getDirectContainers();
                            boolean isDelegation = false;
                            j = 1;
                            while (!isDelegation && j <= directContainers.size()) {
                                container = directContainers.get(j - 1);
                                if (container.hasValueForAFeature((IValue)cddTarget).booleanValue()) {
                                    isDelegation = true;
                                }
                                j = j + 1;
                            }
                            if (isDelegation && this.isOperationRequired((IReference)cddTarget, operation).booleanValue()) {
                                potentialTargets.add((IReference)cddTarget);
                            }
                        }
                    }
                    i = i + 1;
                }
            }
        }
        return potentialTargets;
    }

    public void sendOut(ISignalInstance signalInstance, ICS_InteractionPoint interactionPoint) {
        boolean notToInternal = false;
        ArrayList<IReference> allPotentialTargets = new ArrayList<IReference>();
        ArrayList<IReference> targetsForSendingIn = new ArrayList<IReference>();
        ArrayList<IReference> targetsForSendingOut = new ArrayList<IReference>();
        List<ICS_Link> cddLinks = this.getLinks(interactionPoint);
        Integer linkIndex = 1;
        while (linkIndex <= cddLinks.size()) {
            List<IReference> validAssemblyTargets = this.selectTargetsForSending(cddLinks.get(linkIndex - 1), interactionPoint, ConnectorKind.ASSEMBLY_LITERAL, signalInstance.getType(), notToInternal);
            Integer targetIndex = 1;
            while (targetIndex <= validAssemblyTargets.size()) {
                allPotentialTargets.add(validAssemblyTargets.get(targetIndex - 1));
                targetsForSendingIn.add(validAssemblyTargets.get(targetIndex - 1));
                targetIndex = targetIndex + 1;
            }
            List<IReference> validDelegationTargets = this.selectTargetsForSending(cddLinks.get(linkIndex - 1), interactionPoint, ConnectorKind.DELEGATION_LITERAL, signalInstance.getType(), notToInternal);
            targetIndex = 1;
            while (targetIndex <= validDelegationTargets.size()) {
                allPotentialTargets.add(validDelegationTargets.get(targetIndex - 1));
                targetsForSendingOut.add(validDelegationTargets.get(targetIndex - 1));
                targetIndex = targetIndex + 1;
            }
            linkIndex = linkIndex + 1;
        }
        CS_RequestPropagationStrategy strategy = (CS_RequestPropagationStrategy)this.locus.getFactory().getStrategy("requestPropagation");
        List<IReference> selectedTargets = strategy.select(allPotentialTargets, (ISemanticVisitor)new SendSignalActionActivation());
        int j = 0;
        while (j < selectedTargets.size()) {
            IReference cddTarget;
            IReference target = selectedTargets.get(j);
            int k = 0;
            while (k < targetsForSendingIn.size()) {
                cddTarget = (IReference)targetsForSendingIn.get(k);
                if (cddTarget == target) {
                    target.send(signalInstance);
                }
                ++k;
            }
            k = 0;
            while (k < targetsForSendingOut.size()) {
                cddTarget = (ICS_InteractionPoint)targetsForSendingOut.get(k);
                if (cddTarget == target) {
                    ICS_Reference owner = cddTarget.getOwner();
                    owner.sendOut(signalInstance, (ICS_InteractionPoint)cddTarget);
                }
                ++k;
            }
            ++j;
        }
    }

    public IExecution dispatchOut(Operation operation, ICS_InteractionPoint interactionPoint) {
        IExecution execution = null;
        boolean notToInternal = false;
        ArrayList<IReference> allPotentialTargets = new ArrayList<IReference>();
        ArrayList<IReference> targetsForDispatchingIn = new ArrayList<IReference>();
        ArrayList<IReference> targetsForDispatchingOut = new ArrayList<IReference>();
        List<ICS_Link> cddLinks = this.getLinks(interactionPoint);
        Integer linkIndex = 1;
        while (linkIndex <= cddLinks.size()) {
            List<IReference> validAssemblyTargets = this.selectTargetsForDispatching(cddLinks.get(linkIndex - 1), interactionPoint, ConnectorKind.ASSEMBLY_LITERAL, operation, notToInternal);
            Integer targetIndex = 1;
            while (targetIndex <= validAssemblyTargets.size()) {
                allPotentialTargets.add(validAssemblyTargets.get(targetIndex - 1));
                targetsForDispatchingIn.add(validAssemblyTargets.get(targetIndex - 1));
                targetIndex = targetIndex + 1;
            }
            List<IReference> validDelegationTargets = this.selectTargetsForDispatching(cddLinks.get(linkIndex - 1), interactionPoint, ConnectorKind.DELEGATION_LITERAL, operation, notToInternal);
            targetIndex = 1;
            while (targetIndex <= validDelegationTargets.size()) {
                allPotentialTargets.add(validDelegationTargets.get(targetIndex - 1));
                targetsForDispatchingOut.add(validDelegationTargets.get(targetIndex - 1));
                targetIndex = targetIndex + 1;
            }
            linkIndex = linkIndex + 1;
        }
        CS_RequestPropagationStrategy strategy = (CS_RequestPropagationStrategy)this.locus.getFactory().getStrategy("requestPropagation");
        List<IReference> selectedTargets = strategy.select(allPotentialTargets, (ISemanticVisitor)new SendSignalActionActivation());
        int j = 0;
        while (j < selectedTargets.size()) {
            Object cddTarget;
            IReference target = selectedTargets.get(j);
            int k = 0;
            while (k < targetsForDispatchingIn.size() && execution == null) {
                cddTarget = (IReference)targetsForDispatchingIn.get(k);
                if (cddTarget == target) {
                    execution = target.dispatch(operation);
                }
                ++k;
            }
            k = 0;
            while (k < targetsForDispatchingOut.size() && execution == null) {
                cddTarget = (CS_InteractionPoint)((Object)targetsForDispatchingOut.get(k));
                if (cddTarget == target) {
                    ICS_Reference owner = cddTarget.getOwner();
                    execution = owner.dispatchOut(operation, (ICS_InteractionPoint)cddTarget);
                }
                ++k;
            }
            ++j;
        }
        return execution;
    }

    public IFeatureValue getFeatureValue(StructuralFeature feature) {
        if (feature.getNamespace() instanceof Interface) {
            CS_StructuralFeatureOfInterfaceAccessStrategy readStrategy = (CS_StructuralFeatureOfInterfaceAccessStrategy)this.locus.getFactory().getStrategy("structuralFeature");
            return readStrategy.read(this, feature);
        }
        return super.getFeatureValue(feature);
    }

    public void setFeatureValue(StructuralFeature feature, List<IValue> values, Integer position) {
        if (feature.getNamespace() instanceof Interface) {
            CS_StructuralFeatureOfInterfaceAccessStrategy writeStrategy = (CS_StructuralFeatureOfInterfaceAccessStrategy)this.locus.getFactory().getStrategy("structuralFeature");
            writeStrategy.write(this, feature, values, position);
        } else {
            super.setFeatureValue(feature, values, position);
        }
    }

    public Boolean contains(IObject_ object) {
        boolean objectIsContained = this.directlyContains(object);
        int i = 0;
        while (i < this.featureValues.size() && !objectIsContained) {
            IFeatureValue featureValue = (IFeatureValue)this.featureValues.get(i);
            List values = featureValue.getValues();
            int j = 0;
            while (j < values.size() && !objectIsContained) {
                IValue value = (IValue)values.get(j);
                if (value instanceof CS_Object) {
                    objectIsContained = ((CS_Object)value).contains(object);
                } else if (value instanceof CS_Reference) {
                    ICS_Object referent = ((ICS_Reference)value).getCompositeReferent();
                    objectIsContained = referent.contains(object);
                }
                ++j;
            }
            ++i;
        }
        return objectIsContained;
    }

    public Boolean directlyContains(IObject_ object) {
        boolean objectIsContained = false;
        int i = 0;
        while (i < this.featureValues.size() && !objectIsContained) {
            IFeatureValue featureValue = (IFeatureValue)this.featureValues.get(i);
            List values = featureValue.getValues();
            int j = 0;
            while (j < values.size() && !objectIsContained) {
                IValue value = (IValue)values.get(j);
                if (value == object) {
                    objectIsContained = true;
                } else if (value instanceof ICS_Reference) {
                    objectIsContained = ((ICS_Reference)value).getReferent() == object;
                }
                ++j;
            }
            ++i;
        }
        return objectIsContained;
    }

    public List<ICS_Object> getDirectContainers() {
        ArrayList<ICS_Object> containers = new ArrayList<ICS_Object>();
        int i = 0;
        while (i < this.locus.getExtensionalValues().size()) {
            ICS_Object cddContainer;
            IExtensionalValue extensionalValue = (IExtensionalValue)this.locus.getExtensionalValues().get(i);
            if (extensionalValue != this && extensionalValue instanceof ICS_Object && (cddContainer = (ICS_Object)extensionalValue).directlyContains((IObject_)this).booleanValue()) {
                containers.add(cddContainer);
            }
            ++i;
        }
        return containers;
    }

    public Boolean isOperationProvided(IReference reference, Operation operation) {
        boolean isProvided;
        block8: {
            block7: {
                isProvided = false;
                if (!(reference instanceof ICS_InteractionPoint)) break block7;
                if (!(operation.getOwner() instanceof Interface)) break block8;
                Integer interfaceIndex = 1;
                EList providedInterfaces = ((ICS_InteractionPoint)reference).getDefiningPort().getProvideds();
                while (interfaceIndex <= providedInterfaces.size() && !isProvided) {
                    Interface interface_ = (Interface)providedInterfaces.get(interfaceIndex - 1);
                    Integer memberIndex = 1;
                    while (memberIndex <= interface_.getMembers().size() && !isProvided) {
                        NamedElement cddOperation = (NamedElement)interface_.getMembers().get(memberIndex - 1);
                        if (cddOperation instanceof Operation) {
                            isProvided = operation == cddOperation;
                        }
                        memberIndex = memberIndex + 1;
                    }
                    interfaceIndex = interfaceIndex + 1;
                }
                break block8;
            }
            List types = reference.getTypes();
            Integer typeIndex = 1;
            while (typeIndex <= types.size() && !isProvided) {
                if (types.get(typeIndex - 1) instanceof Class) {
                    Integer memberIndex = 1;
                    EList members = ((Class)types.get(typeIndex - 1)).getMembers();
                    while (memberIndex <= members.size() && !isProvided) {
                        NamedElement cddOperation = (NamedElement)members.get(memberIndex - 1);
                        if (cddOperation instanceof Operation) {
                            CS_DispatchOperationOfInterfaceStrategy strategy = new CS_DispatchOperationOfInterfaceStrategy();
                            isProvided = strategy.operationsMatch((Operation)cddOperation, operation);
                        }
                        memberIndex = memberIndex + 1;
                    }
                }
                typeIndex = typeIndex + 1;
            }
        }
        return isProvided;
    }

    public Boolean isOperationRequired(IReference reference, Operation operation) {
        boolean matches = false;
        if (reference instanceof CS_InteractionPoint) {
            Integer interfaceIndex = 1;
            EList requiredInterfaces = ((CS_InteractionPoint)reference).definingPort.getRequireds();
            while (interfaceIndex <= requiredInterfaces.size() && !matches) {
                Interface interface_ = (Interface)requiredInterfaces.get(interfaceIndex - 1);
                Integer memberIndex = 1;
                while (memberIndex <= interface_.getMembers().size() && !matches) {
                    NamedElement cddOperation = (NamedElement)interface_.getMembers().get(memberIndex - 1);
                    if (cddOperation instanceof Operation) {
                        matches = operation == cddOperation;
                    }
                    memberIndex = memberIndex + 1;
                }
                interfaceIndex = interfaceIndex + 1;
            }
        }
        return matches;
    }

    public CS_LinkKind getLinkKind(ICS_Link link, ICS_InteractionPoint interactionPoint) {
        if (!link.hasValueForAFeature((IValue)interactionPoint).booleanValue()) {
            return CS_LinkKind.None;
        }
        CS_LinkKind kind = CS_LinkKind.ToInternal;
        List featureValues = link.getFeatureValues();
        Integer i = 1;
        while (i <= featureValues.size() && kind != CS_LinkKind.None) {
            IFeatureValue value = (IFeatureValue)featureValues.get(i - 1);
            if (value.getValues().isEmpty()) {
                kind = CS_LinkKind.None;
            } else {
                IValue v = (IValue)value.getValues().get(0);
                boolean vIsAValueForAFeatureOfContext = false;
                if (v.equals((IValue)interactionPoint).booleanValue()) {
                    vIsAValueForAFeatureOfContext = true;
                } else if (v instanceof ICS_InteractionPoint) {
                    v = ((ICS_InteractionPoint)v).getOwner();
                    vIsAValueForAFeatureOfContext = this.hasValueForAFeature(v);
                } else {
                    vIsAValueForAFeatureOfContext = this.hasValueForAFeature(v);
                }
                if (!vIsAValueForAFeatureOfContext) {
                    kind = CS_LinkKind.ToEnvironment;
                }
            }
            i = i + 1;
        }
        return kind;
    }

    public List<ICS_Link> getLinks(ICS_InteractionPoint interactionPoint) {
        List extensionalValues = this.locus.getExtensionalValues();
        Integer i = 1;
        ArrayList<ICS_Link> connectorInstances = new ArrayList<ICS_Link>();
        while (i <= extensionalValues.size()) {
            CS_Link link;
            IExtensionalValue value = (IExtensionalValue)extensionalValues.get(i - 1);
            if (value instanceof CS_Link && this.getLinkKind(link = (CS_Link)value, interactionPoint) != CS_LinkKind.None) {
                connectorInstances.add(link);
            }
            i = i + 1;
        }
        return connectorInstances;
    }

    public Boolean hasValueForAFeature(IValue value) {
        List allFeatureValues = this.getFeatureValues();
        Integer i = 1;
        boolean isAValue = false;
        while (i <= allFeatureValues.size() && !isAValue) {
            IFeatureValue featureValue = (IFeatureValue)allFeatureValues.get(i - 1);
            if (!featureValue.getValues().isEmpty()) {
                List valuesForCurrentFeature = featureValue.getValues();
                Integer j = 1;
                while (j <= valuesForCurrentFeature.size() && !isAValue) {
                    isAValue = ((IValue)featureValue.getValues().get(j - 1)).equals(value);
                    j = j + 1;
                }
            }
            i = i + 1;
        }
        return isAValue;
    }

    public void sendOut(ISignalInstance signalInstance, Port onPort) {
        IFeatureValue featureValue = this.getFeatureValue((StructuralFeature)onPort);
        List values = featureValue.getValues();
        ArrayList<IReference> potentialTargets = new ArrayList<IReference>();
        int i = 0;
        while (i < values.size()) {
            potentialTargets.add((IReference)values.get(i));
            ++i;
        }
        CS_RequestPropagationStrategy strategy = (CS_RequestPropagationStrategy)this.locus.getFactory().getStrategy("requestPropagation");
        List<IReference> targets = strategy.select(potentialTargets, (ISemanticVisitor)new SendSignalActionActivation());
        int i2 = 0;
        while (i2 < targets.size()) {
            CS_InteractionPoint target = (CS_InteractionPoint)targets.get(i2);
            this.sendOut(signalInstance, target);
            ++i2;
        }
    }

    public IExecution dispatchOut(Operation operation, Port onPort) {
        IExecution execution = null;
        IFeatureValue featureValue = this.getFeatureValue((StructuralFeature)onPort);
        List values = featureValue.getValues();
        ArrayList<IReference> potentialTargets = new ArrayList<IReference>();
        int i = 0;
        while (i < values.size()) {
            potentialTargets.add((IReference)((Reference)values.get(i)));
            ++i;
        }
        CS_RequestPropagationStrategy strategy = (CS_RequestPropagationStrategy)this.locus.getFactory().getStrategy("requestPropagation");
        List<IReference> targets = strategy.select(potentialTargets, (ISemanticVisitor)new CallOperationActionActivation());
        if (targets.size() >= 1) {
            ICS_InteractionPoint target = (ICS_InteractionPoint)targets.get(0);
            execution = this.dispatchOut(operation, target);
        }
        return execution;
    }

    public IExecution dispatchIn(Operation operation, Port onPort) {
        IFeatureValue featureValue = this.getFeatureValue((StructuralFeature)onPort);
        List values = featureValue.getValues();
        Integer choice = ((ChoiceStrategy)this.locus.getFactory().getStrategy("choice")).choose(Integer.valueOf(featureValue.getValues().size())) - 1;
        CS_InteractionPoint interactionPoint = (CS_InteractionPoint)((Object)values.get(choice));
        return interactionPoint.dispatch(operation);
    }

    public void sendIn(ISignalInstance signalInstance, Port onPort) {
        IFeatureValue featureValue = this.getFeatureValue((StructuralFeature)onPort);
        List values = featureValue.getValues();
        ArrayList<IReference> potentialTargets = new ArrayList<IReference>();
        int i = 0;
        while (i < values.size()) {
            potentialTargets.add((IReference)((Reference)values.get(i)));
            ++i;
        }
        CS_RequestPropagationStrategy strategy = (CS_RequestPropagationStrategy)this.locus.getFactory().getStrategy("requestPropagation");
        List<IReference> targets = strategy.select(potentialTargets, (ISemanticVisitor)new SendSignalActionActivation());
        int i2 = 0;
        while (i2 < targets.size()) {
            IReference target = targets.get(i2);
            target.send(signalInstance);
            ++i2;
        }
    }
}

