/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.animation.presentation.control;

import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.moka.animation.presentation.control.AnimatedDiagramTreeContentProvider;
import org.eclipse.papyrus.moka.animation.presentation.control.AnimationControlViewFilter;
import org.eclipse.papyrus.moka.animation.presentation.control.AnimationEditingSupport;
import org.eclipse.papyrus.moka.animation.presentation.control.AnimatorRightLabelProvider;
import org.eclipse.papyrus.moka.animation.presentation.control.MainColumnLableProvider;
import org.eclipse.papyrus.moka.animation.presentation.data.AnimatedDiagramTree;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class AnimationControlView
extends ViewPart {
    public static final String ID = "org.eclipse.papyrus.moka.animation.presentation.control.controlview";
    protected TreeViewer viewer;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 66304);
        this.viewer.setContentProvider((IContentProvider)new AnimatedDiagramTreeContentProvider());
        this.viewer.addFilter((ViewerFilter)new AnimationControlViewFilter());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        this.createColumns(this.viewer);
    }

    private void createColumns(TreeViewer viewer) {
        TreeViewerColumn mainColumn = new TreeViewerColumn(viewer, 0);
        mainColumn.getColumn().setText("Animators per diagram");
        mainColumn.getColumn().setWidth(450);
        mainColumn.setLabelProvider((CellLabelProvider)new MainColumnLableProvider());
        TreeViewerColumn allowColumn = new TreeViewerColumn(viewer, 0x1000000);
        allowColumn.getColumn().setText("Allow");
        allowColumn.getColumn().setWidth(50);
        allowColumn.setLabelProvider((CellLabelProvider)new AnimatorRightLabelProvider());
        allowColumn.setEditingSupport((EditingSupport)new AnimationEditingSupport(this.viewer));
    }

    public void setInitialInput(AnimatedDiagramTree input) {
        this.viewer.setInput((Object)input);
        this.viewer.expandAll();
    }

    public void dispose() {
        super.dispose();
        this.viewer.setInput(null);
    }

    public void setFocus() {
    }
}

