/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.breakpoint.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.ui.breakpoint.handlers.MokaAbstractHandler;
import org.eclipse.papyrus.moka.utils.constants.MokaConstants;

public class DebugAsHandler
extends MokaAbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            String resourceURI = selectedElement.eResource().getURI().toString();
            try {
                ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.papyrus.moka.launchConfiguration");
                ILaunchConfigurationWorkingCopy configuration = type.newInstance(null, "New Moka Debug Configuration");
                configuration.setAttribute(MokaConstants.URI_ATTRIBUTE_NAME, resourceURI);
                configuration.setAttribute(MokaConstants.FRAGMENT_ATTRIBUTE_NAME, selectedElement.eResource().getURIFragment(selectedElement));
                configuration.doSave();
                DebugUITools.launch((ILaunchConfiguration)configuration, (String)"debug");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

