/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.model.data.mapping.variables;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.papyrus.moka.debug.engine.MokaDebugElement;
import org.eclipse.papyrus.moka.debug.engine.MokaDebugTarget;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.MokaValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.MokaValueAdapterFactory;

public abstract class MokaVariableAdapter<V>
extends MokaDebugElement
implements IVariable {
    protected MokaValueAdapter<?> value;
    protected V adaptedVariable;

    public MokaVariableAdapter(MokaDebugTarget debugTarget, V adaptedVariable) {
        super(debugTarget);
        this.adaptedVariable = adaptedVariable;
    }

    public IValue getValue() throws DebugException {
        if (this.value == null) {
            this.value = MokaValueAdapterFactory.getInstance().instantiate(this.adaptedVariable, this.debugTarget);
        }
        return this.value;
    }

    public String getReferenceTypeName() throws DebugException {
        return "<no reference type>";
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public V getAdapted() {
        return this.adaptedVariable;
    }
}

