/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.animation.engine.animators;

import java.util.List;
import org.eclipse.papyrus.moka.animation.engine.animators.actions.DerivedAnimationAction;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationEngine;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IReference;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.service.IMokaExecutionListener;
import org.eclipse.papyrus.moka.service.IMokaStepListener;

public abstract class Animator
implements IMokaExecutionListener,
IMokaStepListener {
    protected AnimationEngine engine;
    protected int priority;
    protected List<DerivedAnimationAction> derivedAnimationAction;

    public AnimationEngine getAnimationEngine() {
        return this.engine;
    }

    public void setAnimationEngine(AnimationEngine engine) {
        this.engine = engine;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setDerivedAnimationAction(List<DerivedAnimationAction> derivedAnimationActions) {
        this.derivedAnimationAction = derivedAnimationActions;
    }

    public List<DerivedAnimationAction> getDerivedAnimationAction() {
        return this.derivedAnimationAction;
    }

    public abstract boolean accept(ISemanticVisitor var1);

    public final void nodeVisited(ISemanticVisitor nodeVisitor) {
        for (DerivedAnimationAction derivedAction : this.derivedAnimationAction) {
            if (!derivedAction.accept(nodeVisitor)) continue;
            derivedAction.preVisitAction(this.engine, nodeVisitor);
        }
        this.nodeVisited_(nodeVisitor);
        for (DerivedAnimationAction derivedAction : this.derivedAnimationAction) {
            if (!derivedAction.accept(nodeVisitor)) continue;
            derivedAction.postVisitAction(this.engine, nodeVisitor);
        }
    }

    public abstract void nodeVisited_(ISemanticVisitor var1);

    public final void nodeLeft(ISemanticVisitor nodeVisitor) {
        for (DerivedAnimationAction derivedAction : this.derivedAnimationAction) {
            if (!derivedAction.accept(nodeVisitor)) continue;
            derivedAction.preLeftAction(this.engine, nodeVisitor);
        }
        this.nodeLeft_(nodeVisitor);
        for (DerivedAnimationAction derivedAction : this.derivedAnimationAction) {
            if (!derivedAction.accept(nodeVisitor)) continue;
            derivedAction.postLeftAction(this.engine, nodeVisitor);
        }
    }

    public abstract void nodeLeft_(ISemanticVisitor var1);

    public void valueCreated(IValue value) {
    }

    public void valueDestroyed(IValue value) {
    }

    public void stepStart(IReference context) {
    }

    public void stepEnd(IReference context) {
    }
}

