/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.animation.engine.animators;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.animation.engine.animators.Animator;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationKind;
import org.eclipse.papyrus.moka.fuml.Semantics.Actions.BasicActions.ICallActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Actions.CompleteActions.IAcceptEventActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.utils.constants.MokaConstants;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.CallAction;
import org.eclipse.uml2.uml.InvocationAction;

public class ActivityAnimator
extends Animator {
    @Override
    public void nodeVisited_(ISemanticVisitor nodeVisitor) {
        IActivityEdgeInstance edgeInstance;
        if (nodeVisitor instanceof IActivityNodeActivation) {
            IActivityNodeActivation activation = (IActivityNodeActivation)nodeVisitor;
            ActivityNode activityNode = activation.getNode();
            if (activityNode != null) {
                if (activation instanceof IAcceptEventActionActivation) {
                    this.engine.renderAs((EObject)activityNode, activation.getExecutionContext(), AnimationKind.ANIMATED);
                } else if (activation instanceof ICallActionActivation && ((CallAction)activityNode).isSynchronous()) {
                    this.engine.renderAs((EObject)activation.getNode(), activation.getExecutionContext(), AnimationKind.ANIMATED);
                } else {
                    this.engine.renderAs((EObject)activityNode, activation.getExecutionContext(), AnimationKind.ANIMATED, AnimationKind.VISITED, MokaConstants.MOKA_ANIMATION_DELAY);
                }
                if (activityNode instanceof InvocationAction) {
                    this.engine.renderAs((EObject)((InvocationAction)activityNode).getOnPort(), activation.getExecutionContext(), AnimationKind.ANIMATED, AnimationKind.VISITED, MokaConstants.MOKA_ANIMATION_DELAY);
                }
            }
        } else if (nodeVisitor instanceof IActivityEdgeInstance && (edgeInstance = (IActivityEdgeInstance)nodeVisitor).getEdge() != null) {
            this.engine.startRendering((EObject)edgeInstance.getEdge(), edgeInstance.getGroup().getActivityExecution().getContext(), AnimationKind.ANIMATED);
        }
    }

    @Override
    public void nodeLeft_(ISemanticVisitor nodeVisitor) {
        IActivityEdgeInstance edgeInstance;
        if (nodeVisitor instanceof IActivityNodeActivation) {
            IActivityNodeActivation activation = (IActivityNodeActivation)nodeVisitor;
            ActivityNode activityNode = activation.getNode();
            if (activityNode != null) {
                if (activation instanceof IAcceptEventActionActivation) {
                    this.engine.renderAs((EObject)activation.getNode(), activation.getExecutionContext(), AnimationKind.VISITED);
                } else if (activation instanceof ICallActionActivation && ((CallAction)activityNode).isSynchronous()) {
                    this.engine.renderAs((EObject)activation.getNode(), activation.getExecutionContext(), AnimationKind.VISITED);
                }
            }
        } else if (nodeVisitor instanceof IActivityEdgeInstance && (edgeInstance = (IActivityEdgeInstance)nodeVisitor).getEdge() != null) {
            this.engine.renderAs((EObject)edgeInstance.getEdge(), edgeInstance.getGroup().getActivityExecution().getContext(), AnimationKind.VISITED);
        }
    }

    @Override
    public boolean accept(ISemanticVisitor visitor) {
        boolean accept = false;
        if (visitor instanceof IActivityNodeActivation) {
            accept = true;
        } else if (visitor instanceof IActivityEdgeInstance) {
            accept = true;
        }
        return accept;
    }
}

