/*****************************************************************************
 * Copyright (c) 2019 CEA LIST and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.model2doc.odt.internal.constants;

/**
 * This class contains values for Constants described in the file {@link ParagraphPropertiesConstants}
 */
public class ParagraphPropertiesValues {

	private ParagraphPropertiesValues() {
		// to prevent instanciation
	}

	/**
	 * Values for {@link ParagraphPropertiesConstants#NUMBERING_STYLE}
	 */
	public static final String NUMBERING_STYLE_BULLET = "List 1"; //$NON-NLS-1$

	public static final String NUMBERING_STYLE_DASH = "List 2"; //$NON-NLS-1$

}
