/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.internal.mapping;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.model2doc.emf.documentstructure.BodyPart;
import org.eclipse.papyrus.model2doc.emf.documentstructure.InsertedFile;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentStructureTemplatePackage;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.InsertFileTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.AbstractBodyPartTemplateToStructureMapper;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;

public class InsertFileTemplateMapper
extends AbstractBodyPartTemplateToStructureMapper<InsertFileTemplate> {
    public InsertFileTemplateMapper() {
        super(DocumentStructureTemplatePackage.eINSTANCE.getInsertFileTemplate(), BodyPart.class);
    }

    @Override
    protected <T> List<T> doMap(IMappingService mappingService, InsertFileTemplate insertFileTemplate, EObject semanticModelElement, Class<T> expectedReturnedClass) {
        if (!insertFileTemplate.generateBranch(semanticModelElement)) {
            return Collections.emptyList();
        }
        ArrayList<T> returnedElements = new ArrayList<T>();
        if (insertFileTemplate.isGenerate()) {
            InsertedFile insertedFile = STRUCTURE_EFACTORY.createInsertedFile();
            if (this.isFileExist(insertFileTemplate)) {
                String path = URI.decode((String)insertFileTemplate.getFileAccessor().createInputFilePlatformURI().toString());
                insertedFile.setFilePath(path);
                returnedElements.add(expectedReturnedClass.cast(insertedFile));
            }
        }
        return this.buildMapperResult(insertFileTemplate, semanticModelElement, expectedReturnedClass, returnedElements);
    }

    protected boolean isFileExist(InsertFileTemplate insertFileTemplate) {
        String ecoreFilePrefix = "file:";
        String emptyString = "";
        URL url = insertFileTemplate.getFileAccessor().createInputFileURL();
        if (url != null) {
            File file = new File(URI.decode((String)url.getPath()).replaceFirst("file:", ""));
            return file.exists();
        }
        return false;
    }
}

