/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.presentation;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.presentation.DocumentStructureTemplateEditor;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.provider.DocumentStructureTemplateItemProviderAdapterFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class CustomDocumentStructureTemplateEditor
extends DocumentStructureTemplateEditor {
    private CommandStackListener commandStackListener;

    @Override
    protected void initializeEditingDomain() {
        this.initAdapterFactory();
        this.initDomainAndStack();
    }

    protected void initDomainAndStack() {
        BasicCommandStack commandStack = new BasicCommandStack();
        this.addCommandStackListener((CommandStack)commandStack);
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected void initAdapterFactory() {
        this.adapterFactory = this.createComposedAdapterFactory();
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new DocumentStructureTemplateItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }

    protected ComposedAdapterFactory createComposedAdapterFactory() {
        return new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    }

    protected void addCommandStackListener(CommandStack commandStack) {
        this.commandStackListener = new CustomCommandStackListener();
        commandStack.addCommandStackListener(this.commandStackListener);
    }

    @Override
    public void dispose() {
        this.editingDomain.getCommandStack().removeCommandStackListener(this.commandStackListener);
        super.dispose();
    }

    private class CustomCommandStackListener
    implements CommandStackListener {
        private CustomCommandStackListener() {
        }

        public void commandStackChanged(final EventObject event) {
            Composite container = CustomDocumentStructureTemplateEditor.this.getContainer();
            if (container.isDisposed()) {
                return;
            }
            CustomDocumentStructureTemplateEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CustomDocumentStructureTemplateEditor.this.firePropertyChange(257);
                    Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                    if (mostRecentCommand != null) {
                        CustomDocumentStructureTemplateEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                    }
                    Iterator i = ((CustomCommandStackListener)CustomCommandStackListener.this).CustomDocumentStructureTemplateEditor.this.propertySheetPages.iterator();
                    while (i.hasNext()) {
                        PropertySheetPage propertySheetPage = (PropertySheetPage)i.next();
                        if (propertySheetPage.getControl().isDisposed()) {
                            i.remove();
                            continue;
                        }
                        propertySheetPage.refresh();
                    }
                }
            });
        }
    }
}

